/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.GenericShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;

class OrderedShorthandBuilder
extends GenericShorthandBuilder {
    final String freeProperty;
    private final String freePropertyStringValue;

    OrderedShorthandBuilder(String shorthandName, BaseCSSStyleDeclaration parentStyle, String initialvalue, String freeProperty) {
        super(shorthandName, parentStyle, initialvalue);
        this.freeProperty = freeProperty.toLowerCase(Locale.ROOT);
        StyleValue freePropertyValue = this.getCSSValue(freeProperty);
        this.freePropertyStringValue = freePropertyValue != null && freePropertyValue.getCssValueType() == CSSValue.CssType.TYPED && freePropertyValue.getPrimitiveType() == CSSValue.Type.IDENT && this.isNotInitialValue(freePropertyValue, freeProperty) ? ((CSSTypedValue)((Object)freePropertyValue)).getStringValue() : null;
    }

    @Override
    boolean invalidPrimitiveValueClash(Set<String> declaredSet, String propertyName, TypedValue primi) {
        return !this.freeProperty.equals(propertyName) && super.invalidPrimitiveValueClash(declaredSet, propertyName, primi);
    }

    @Override
    boolean identifierValuesAreKnown(String propertyName) {
        return !this.freeProperty.equals(propertyName) && super.identifierValuesAreKnown(propertyName);
    }

    @Override
    boolean appendValueText(BufferSimpleWriter wri, DeclarationFormattingContext context, String property, boolean appended) {
        StyleValue cssVal = this.getCSSValue(property);
        if (this.isNotInitialValue(cssVal, property) || !this.freeProperty.equals(property) && this.validValueClash(property)) {
            if (appended) {
                wri.getBuffer().append(' ');
            }
            try {
                context.writeMinifiedValue((SimpleWriter)wri, property, cssVal);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return appended;
    }

    boolean validValueClash(String property) {
        return this.freePropertyStringValue != null && OrderedShorthandBuilder.getShorthandDatabase().isIdentifierValue(property, this.freePropertyStringValue);
    }
}

