require 'spec_helper'
require 'rex/post/meterpreter/extensions/stdapi/sys/config'

RSpec.describe Msf::Exploit::Local do
  describe '#exploit_type' do
    it 'indicates that the exploit is local' do
      expect(subject.exploit_type).to eq 'local'
    end
  end

  describe '#sysinfo' do
    before(:each) do
      allow(subject).to receive(:session).and_return(session)
    end

    context 'when the session is nil' do
      let(:session) { nil }

      it 'returns nil' do
        expect(subject.sysinfo).to eq nil
      end
    end

    context 'when the session is not Meterpreter' do
      let(:session) do
        connection = nil
        Msf::Sessions::CommandShell.new(connection)
      end

      it 'returns nil' do
        expect(subject.sysinfo).to eq nil
      end
    end

    context 'when the session is Meterpreter' do
      let(:session) do
        connection = nil
        session = Msf::Sessions::Meterpreter_x86_Win.new(connection)
        session.register_extension_alias(
          'sys',
          Rex::Post::Meterpreter::ObjectAliases.new(
            'config' => instance_double(
              ::Rex::Post::Meterpreter::Extensions::Stdapi::Sys::Config,
              sysinfo: { 'Computer' => 'FooComputer' }
            )
          )
        )
        session
      end

      it 'returns the sysinfo object' do
        expect(subject.sysinfo).to eq({ 'Computer' => 'FooComputer' })
      end
    end
  end
end
