/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.net.UrlEscapers;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;

public class TemplateRequestURLBuilder
implements Function<CriteriaSet, String> {
    @Nonnull
    @NotEmpty
    public static final String CONTEXT_KEY_ENTITY_ID = "entityID";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplateRequestURLBuilder.class);
    @Nonnull
    private Template template;
    @Nonnull
    private String templateText;
    @Nullable
    private Function<String, String> transformer;
    private EncodingStyle entityIDEncodingStyle;

    public TemplateRequestURLBuilder(@Nonnull VelocityEngine engine, @Nonnull @NotEmpty String templateString, @Nullable EncodingStyle encodingStyle) {
        this(engine, templateString, encodingStyle, null, StandardCharsets.US_ASCII);
    }

    public TemplateRequestURLBuilder(@Nonnull VelocityEngine engine, @Nonnull @NotEmpty String templateString, @Nullable EncodingStyle encodingStyle, @Nullable Function<String, String> transform) {
        this(engine, templateString, encodingStyle, transform, StandardCharsets.US_ASCII);
    }

    public TemplateRequestURLBuilder(@Nonnull VelocityEngine engine, @Nonnull @NotEmpty String templateString, EncodingStyle encodingStyle, @Nullable Function<String, String> transform, @Nullable Charset charSet) {
        Constraint.isNotNull(engine, "VelocityEngine was null");
        String trimmedTemplate = StringSupport.trimOrNull(templateString);
        this.templateText = Constraint.isNotNull(trimmedTemplate, "Template string was null or empty");
        this.transformer = transform;
        this.template = charSet != null ? Template.fromTemplate(engine, this.templateText, charSet) : Template.fromTemplate(engine, this.templateText);
        this.entityIDEncodingStyle = encodingStyle != null ? encodingStyle : EncodingStyle.none;
    }

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        EntityIdCriterion criterion;
        EntityIdCriterion entityIdCriterion = criterion = criteria != null ? criteria.get(EntityIdCriterion.class) : null;
        if (criterion == null) {
            this.log.trace("CriteriaSet did not contain EntityIdCriterion, unable to build request URL");
            return null;
        }
        String entityID = criterion.getEntityId();
        this.log.debug("Saw input entityID '{}'", (Object)entityID);
        if (this.transformer != null) {
            entityID = this.transformer.apply(entityID);
            this.log.debug("Transformed entityID is '{}'", (Object)entityID);
            if (entityID == null) {
                this.log.debug("Transformed entityID was null");
                return null;
            }
        }
        VelocityContext context = new VelocityContext();
        switch (this.entityIDEncodingStyle) {
            case none: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)entityID);
                break;
            }
            case form: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)UrlEscapers.urlFormParameterEscaper().escape(entityID));
                break;
            }
            case path: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)UrlEscapers.urlPathSegmentEscaper().escape(entityID));
                break;
            }
            case fragment: {
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)UrlEscapers.urlFragmentEscaper().escape(entityID));
                break;
            }
            default: {
                this.log.warn("An unsupported EncodingStyle value was seen, treating as 'none': {}", (Object)this.entityIDEncodingStyle);
                context.put(CONTEXT_KEY_ENTITY_ID, (Object)entityID);
            }
        }
        try {
            String result = this.template.merge((Context)context);
            this.log.debug("From entityID '{}' and template text '{}', built request URL: {}", new Object[]{entityID, this.templateText, result});
            return result;
        }
        catch (Throwable t) {
            this.log.error("Encountered fatal error attempting to build request URL", t);
            return null;
        }
    }

    public static enum EncodingStyle {
        none,
        form,
        path,
        fragment;

    }
}

