import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CloudFrontServiceException as __BaseException } from "./CloudFrontServiceException";
export declare const ResponseHeadersPolicyAccessControlAllowMethodsValues: {
  readonly ALL: "ALL";
  readonly DELETE: "DELETE";
  readonly GET: "GET";
  readonly HEAD: "HEAD";
  readonly OPTIONS: "OPTIONS";
  readonly PATCH: "PATCH";
  readonly POST: "POST";
  readonly PUT: "PUT";
};
export type ResponseHeadersPolicyAccessControlAllowMethodsValues =
  (typeof ResponseHeadersPolicyAccessControlAllowMethodsValues)[keyof typeof ResponseHeadersPolicyAccessControlAllowMethodsValues];
export declare class AccessDenied extends __BaseException {
  readonly name: "AccessDenied";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<AccessDenied, __BaseException>);
}
export interface KeyPairIds {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface KGKeyPairIds {
  KeyGroupId?: string | undefined;
  KeyPairIds?: KeyPairIds | undefined;
}
export interface ActiveTrustedKeyGroups {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: KGKeyPairIds[] | undefined;
}
export interface Signer {
  AwsAccountNumber?: string | undefined;
  KeyPairIds?: KeyPairIds | undefined;
}
export interface ActiveTrustedSigners {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: Signer[] | undefined;
}
export interface Aliases {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export declare const ICPRecordalStatus: {
  readonly APPROVED: "APPROVED";
  readonly PENDING: "PENDING";
  readonly SUSPENDED: "SUSPENDED";
};
export type ICPRecordalStatus =
  (typeof ICPRecordalStatus)[keyof typeof ICPRecordalStatus];
export interface AliasICPRecordal {
  CNAME?: string | undefined;
  ICPRecordalStatus?: ICPRecordalStatus | undefined;
}
export declare const Method: {
  readonly DELETE: "DELETE";
  readonly GET: "GET";
  readonly HEAD: "HEAD";
  readonly OPTIONS: "OPTIONS";
  readonly PATCH: "PATCH";
  readonly POST: "POST";
  readonly PUT: "PUT";
};
export type Method = (typeof Method)[keyof typeof Method];
export interface CachedMethods {
  Quantity: number | undefined;
  Items: Method[] | undefined;
}
export interface AllowedMethods {
  Quantity: number | undefined;
  Items: Method[] | undefined;
  CachedMethods?: CachedMethods | undefined;
}
export declare const IpAddressType: {
  readonly DualStack: "dualstack";
  readonly Ipv4: "ipv4";
  readonly Ipv6: "ipv6";
};
export type IpAddressType = (typeof IpAddressType)[keyof typeof IpAddressType];
export interface AnycastIpList {
  Id: string | undefined;
  Name: string | undefined;
  Status: string | undefined;
  Arn: string | undefined;
  IpAddressType?: IpAddressType | undefined;
  AnycastIps: string[] | undefined;
  IpCount: number | undefined;
  LastModifiedTime: Date | undefined;
}
export interface AnycastIpListSummary {
  Id: string | undefined;
  Name: string | undefined;
  Status: string | undefined;
  Arn: string | undefined;
  IpCount: number | undefined;
  LastModifiedTime: Date | undefined;
  IpAddressType?: IpAddressType | undefined;
  ETag?: string | undefined;
}
export interface AnycastIpListCollection {
  Items?: AnycastIpListSummary[] | undefined;
  Marker: string | undefined;
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  IsTruncated: boolean | undefined;
  Quantity: number | undefined;
}
export interface AssociateAliasRequest {
  TargetDistributionId: string | undefined;
  Alias: string | undefined;
}
export declare class IllegalUpdate extends __BaseException {
  readonly name: "IllegalUpdate";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<IllegalUpdate, __BaseException>);
}
export declare class InvalidArgument extends __BaseException {
  readonly name: "InvalidArgument";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<InvalidArgument, __BaseException>);
}
export declare class NoSuchDistribution extends __BaseException {
  readonly name: "NoSuchDistribution";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<NoSuchDistribution, __BaseException>);
}
export declare class TooManyDistributionCNAMEs extends __BaseException {
  readonly name: "TooManyDistributionCNAMEs";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyDistributionCNAMEs, __BaseException>
  );
}
export interface AssociateDistributionTenantWebACLRequest {
  Id: string | undefined;
  WebACLArn: string | undefined;
  IfMatch?: string | undefined;
}
export interface AssociateDistributionTenantWebACLResult {
  Id?: string | undefined;
  WebACLArn?: string | undefined;
  ETag?: string | undefined;
}
export declare class EntityNotFound extends __BaseException {
  readonly name: "EntityNotFound";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<EntityNotFound, __BaseException>);
}
export declare class InvalidIfMatchVersion extends __BaseException {
  readonly name: "InvalidIfMatchVersion";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidIfMatchVersion, __BaseException>
  );
}
export declare class PreconditionFailed extends __BaseException {
  readonly name: "PreconditionFailed";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<PreconditionFailed, __BaseException>);
}
export interface AssociateDistributionWebACLRequest {
  Id: string | undefined;
  WebACLArn: string | undefined;
  IfMatch?: string | undefined;
}
export interface AssociateDistributionWebACLResult {
  Id?: string | undefined;
  WebACLArn?: string | undefined;
  ETag?: string | undefined;
}
export declare class BatchTooLarge extends __BaseException {
  readonly name: "BatchTooLarge";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<BatchTooLarge, __BaseException>);
}
export declare const ItemSelection: {
  readonly all: "all";
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type ItemSelection = (typeof ItemSelection)[keyof typeof ItemSelection];
export interface CookieNames {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface CookiePreference {
  Forward: ItemSelection | undefined;
  WhitelistedNames?: CookieNames | undefined;
}
export interface Headers {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface QueryStringCacheKeys {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ForwardedValues {
  QueryString: boolean | undefined;
  Cookies: CookiePreference | undefined;
  Headers?: Headers | undefined;
  QueryStringCacheKeys?: QueryStringCacheKeys | undefined;
}
export declare const EventType: {
  readonly origin_request: "origin-request";
  readonly origin_response: "origin-response";
  readonly viewer_request: "viewer-request";
  readonly viewer_response: "viewer-response";
};
export type EventType = (typeof EventType)[keyof typeof EventType];
export interface FunctionAssociation {
  FunctionARN: string | undefined;
  EventType: EventType | undefined;
}
export interface FunctionAssociations {
  Quantity: number | undefined;
  Items?: FunctionAssociation[] | undefined;
}
export interface GrpcConfig {
  Enabled: boolean | undefined;
}
export interface LambdaFunctionAssociation {
  LambdaFunctionARN: string | undefined;
  EventType: EventType | undefined;
  IncludeBody?: boolean | undefined;
}
export interface LambdaFunctionAssociations {
  Quantity: number | undefined;
  Items?: LambdaFunctionAssociation[] | undefined;
}
export interface TrustedKeyGroups {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface TrustedSigners {
  Enabled: boolean | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export declare const ViewerProtocolPolicy: {
  readonly allow_all: "allow-all";
  readonly https_only: "https-only";
  readonly redirect_to_https: "redirect-to-https";
};
export type ViewerProtocolPolicy =
  (typeof ViewerProtocolPolicy)[keyof typeof ViewerProtocolPolicy];
export interface CacheBehavior {
  PathPattern: string | undefined;
  TargetOriginId: string | undefined;
  TrustedSigners?: TrustedSigners | undefined;
  TrustedKeyGroups?: TrustedKeyGroups | undefined;
  ViewerProtocolPolicy: ViewerProtocolPolicy | undefined;
  AllowedMethods?: AllowedMethods | undefined;
  SmoothStreaming?: boolean | undefined;
  Compress?: boolean | undefined;
  LambdaFunctionAssociations?: LambdaFunctionAssociations | undefined;
  FunctionAssociations?: FunctionAssociations | undefined;
  FieldLevelEncryptionId?: string | undefined;
  RealtimeLogConfigArn?: string | undefined;
  CachePolicyId?: string | undefined;
  OriginRequestPolicyId?: string | undefined;
  ResponseHeadersPolicyId?: string | undefined;
  GrpcConfig?: GrpcConfig | undefined;
  ForwardedValues?: ForwardedValues | undefined;
  MinTTL?: number | undefined;
  DefaultTTL?: number | undefined;
  MaxTTL?: number | undefined;
}
export interface CacheBehaviors {
  Quantity: number | undefined;
  Items?: CacheBehavior[] | undefined;
}
export declare const CachePolicyCookieBehavior: {
  readonly all: "all";
  readonly allExcept: "allExcept";
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type CachePolicyCookieBehavior =
  (typeof CachePolicyCookieBehavior)[keyof typeof CachePolicyCookieBehavior];
export interface CachePolicyCookiesConfig {
  CookieBehavior: CachePolicyCookieBehavior | undefined;
  Cookies?: CookieNames | undefined;
}
export declare const CachePolicyHeaderBehavior: {
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type CachePolicyHeaderBehavior =
  (typeof CachePolicyHeaderBehavior)[keyof typeof CachePolicyHeaderBehavior];
export interface CachePolicyHeadersConfig {
  HeaderBehavior: CachePolicyHeaderBehavior | undefined;
  Headers?: Headers | undefined;
}
export declare const CachePolicyQueryStringBehavior: {
  readonly all: "all";
  readonly allExcept: "allExcept";
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type CachePolicyQueryStringBehavior =
  (typeof CachePolicyQueryStringBehavior)[keyof typeof CachePolicyQueryStringBehavior];
export interface QueryStringNames {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface CachePolicyQueryStringsConfig {
  QueryStringBehavior: CachePolicyQueryStringBehavior | undefined;
  QueryStrings?: QueryStringNames | undefined;
}
export interface ParametersInCacheKeyAndForwardedToOrigin {
  EnableAcceptEncodingGzip: boolean | undefined;
  EnableAcceptEncodingBrotli?: boolean | undefined;
  HeadersConfig: CachePolicyHeadersConfig | undefined;
  CookiesConfig: CachePolicyCookiesConfig | undefined;
  QueryStringsConfig: CachePolicyQueryStringsConfig | undefined;
}
export interface CachePolicyConfig {
  Comment?: string | undefined;
  Name: string | undefined;
  DefaultTTL?: number | undefined;
  MaxTTL?: number | undefined;
  MinTTL: number | undefined;
  ParametersInCacheKeyAndForwardedToOrigin?:
    | ParametersInCacheKeyAndForwardedToOrigin
    | undefined;
}
export interface CachePolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  CachePolicyConfig: CachePolicyConfig | undefined;
}
export declare class CachePolicyAlreadyExists extends __BaseException {
  readonly name: "CachePolicyAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<CachePolicyAlreadyExists, __BaseException>
  );
}
export declare class CachePolicyInUse extends __BaseException {
  readonly name: "CachePolicyInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<CachePolicyInUse, __BaseException>);
}
export declare const CachePolicyType: {
  readonly custom: "custom";
  readonly managed: "managed";
};
export type CachePolicyType =
  (typeof CachePolicyType)[keyof typeof CachePolicyType];
export interface CachePolicySummary {
  Type: CachePolicyType | undefined;
  CachePolicy: CachePolicy | undefined;
}
export interface CachePolicyList {
  NextMarker?: string | undefined;
  MaxItems: number | undefined;
  Quantity: number | undefined;
  Items?: CachePolicySummary[] | undefined;
}
export declare class CannotChangeImmutablePublicKeyFields extends __BaseException {
  readonly name: "CannotChangeImmutablePublicKeyFields";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      CannotChangeImmutablePublicKeyFields,
      __BaseException
    >
  );
}
export declare class CannotDeleteEntityWhileInUse extends __BaseException {
  readonly name: "CannotDeleteEntityWhileInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<CannotDeleteEntityWhileInUse, __BaseException>
  );
}
export declare class CannotUpdateEntityWhileInUse extends __BaseException {
  readonly name: "CannotUpdateEntityWhileInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<CannotUpdateEntityWhileInUse, __BaseException>
  );
}
export interface Certificate {
  Arn: string | undefined;
}
export declare const CertificateSource: {
  readonly acm: "acm";
  readonly cloudfront: "cloudfront";
  readonly iam: "iam";
};
export type CertificateSource =
  (typeof CertificateSource)[keyof typeof CertificateSource];
export declare const CertificateTransparencyLoggingPreference: {
  readonly Disabled: "disabled";
  readonly Enabled: "enabled";
};
export type CertificateTransparencyLoggingPreference =
  (typeof CertificateTransparencyLoggingPreference)[keyof typeof CertificateTransparencyLoggingPreference];
export declare class CNAMEAlreadyExists extends __BaseException {
  readonly name: "CNAMEAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<CNAMEAlreadyExists, __BaseException>);
}
export interface CopyDistributionRequest {
  PrimaryDistributionId: string | undefined;
  Staging?: boolean | undefined;
  IfMatch?: string | undefined;
  CallerReference: string | undefined;
  Enabled?: boolean | undefined;
}
export declare const ConnectionMode: {
  readonly Direct: "direct";
  readonly TenantOnly: "tenant-only";
};
export type ConnectionMode =
  (typeof ConnectionMode)[keyof typeof ConnectionMode];
export interface CustomErrorResponse {
  ErrorCode: number | undefined;
  ResponsePagePath?: string | undefined;
  ResponseCode?: string | undefined;
  ErrorCachingMinTTL?: number | undefined;
}
export interface CustomErrorResponses {
  Quantity: number | undefined;
  Items?: CustomErrorResponse[] | undefined;
}
export interface DefaultCacheBehavior {
  TargetOriginId: string | undefined;
  TrustedSigners?: TrustedSigners | undefined;
  TrustedKeyGroups?: TrustedKeyGroups | undefined;
  ViewerProtocolPolicy: ViewerProtocolPolicy | undefined;
  AllowedMethods?: AllowedMethods | undefined;
  SmoothStreaming?: boolean | undefined;
  Compress?: boolean | undefined;
  LambdaFunctionAssociations?: LambdaFunctionAssociations | undefined;
  FunctionAssociations?: FunctionAssociations | undefined;
  FieldLevelEncryptionId?: string | undefined;
  RealtimeLogConfigArn?: string | undefined;
  CachePolicyId?: string | undefined;
  OriginRequestPolicyId?: string | undefined;
  ResponseHeadersPolicyId?: string | undefined;
  GrpcConfig?: GrpcConfig | undefined;
  ForwardedValues?: ForwardedValues | undefined;
  MinTTL?: number | undefined;
  DefaultTTL?: number | undefined;
  MaxTTL?: number | undefined;
}
export declare const HttpVersion: {
  readonly http1_1: "http1.1";
  readonly http2: "http2";
  readonly http2and3: "http2and3";
  readonly http3: "http3";
};
export type HttpVersion = (typeof HttpVersion)[keyof typeof HttpVersion];
export interface LoggingConfig {
  Enabled?: boolean | undefined;
  IncludeCookies?: boolean | undefined;
  Bucket?: string | undefined;
  Prefix?: string | undefined;
}
export interface StatusCodes {
  Quantity: number | undefined;
  Items: number[] | undefined;
}
export interface OriginGroupFailoverCriteria {
  StatusCodes: StatusCodes | undefined;
}
export interface OriginGroupMember {
  OriginId: string | undefined;
}
export interface OriginGroupMembers {
  Quantity: number | undefined;
  Items: OriginGroupMember[] | undefined;
}
export declare const OriginGroupSelectionCriteria: {
  readonly Default: "default";
  readonly MediaQualityBased: "media-quality-based";
};
export type OriginGroupSelectionCriteria =
  (typeof OriginGroupSelectionCriteria)[keyof typeof OriginGroupSelectionCriteria];
export interface OriginGroup {
  Id: string | undefined;
  FailoverCriteria: OriginGroupFailoverCriteria | undefined;
  Members: OriginGroupMembers | undefined;
  SelectionCriteria?: OriginGroupSelectionCriteria | undefined;
}
export interface OriginGroups {
  Quantity: number | undefined;
  Items?: OriginGroup[] | undefined;
}
export interface OriginCustomHeader {
  HeaderName: string | undefined;
  HeaderValue: string | undefined;
}
export interface CustomHeaders {
  Quantity: number | undefined;
  Items?: OriginCustomHeader[] | undefined;
}
export declare const OriginProtocolPolicy: {
  readonly http_only: "http-only";
  readonly https_only: "https-only";
  readonly match_viewer: "match-viewer";
};
export type OriginProtocolPolicy =
  (typeof OriginProtocolPolicy)[keyof typeof OriginProtocolPolicy];
export declare const SslProtocol: {
  readonly SSLv3: "SSLv3";
  readonly TLSv1: "TLSv1";
  readonly TLSv1_1: "TLSv1.1";
  readonly TLSv1_2: "TLSv1.2";
};
export type SslProtocol = (typeof SslProtocol)[keyof typeof SslProtocol];
export interface OriginSslProtocols {
  Quantity: number | undefined;
  Items: SslProtocol[] | undefined;
}
export interface CustomOriginConfig {
  HTTPPort: number | undefined;
  HTTPSPort: number | undefined;
  OriginProtocolPolicy: OriginProtocolPolicy | undefined;
  OriginSslProtocols?: OriginSslProtocols | undefined;
  OriginReadTimeout?: number | undefined;
  OriginKeepaliveTimeout?: number | undefined;
  IpAddressType?: IpAddressType | undefined;
}
export interface OriginShield {
  Enabled: boolean | undefined;
  OriginShieldRegion?: string | undefined;
}
export interface S3OriginConfig {
  OriginAccessIdentity: string | undefined;
  OriginReadTimeout?: number | undefined;
}
export interface VpcOriginConfig {
  VpcOriginId: string | undefined;
  OwnerAccountId?: string | undefined;
  OriginReadTimeout?: number | undefined;
  OriginKeepaliveTimeout?: number | undefined;
}
export interface Origin {
  Id: string | undefined;
  DomainName: string | undefined;
  OriginPath?: string | undefined;
  CustomHeaders?: CustomHeaders | undefined;
  S3OriginConfig?: S3OriginConfig | undefined;
  CustomOriginConfig?: CustomOriginConfig | undefined;
  VpcOriginConfig?: VpcOriginConfig | undefined;
  ConnectionAttempts?: number | undefined;
  ConnectionTimeout?: number | undefined;
  ResponseCompletionTimeout?: number | undefined;
  OriginShield?: OriginShield | undefined;
  OriginAccessControlId?: string | undefined;
}
export interface Origins {
  Quantity: number | undefined;
  Items: Origin[] | undefined;
}
export declare const PriceClass: {
  readonly None: "None";
  readonly PriceClass_100: "PriceClass_100";
  readonly PriceClass_200: "PriceClass_200";
  readonly PriceClass_All: "PriceClass_All";
};
export type PriceClass = (typeof PriceClass)[keyof typeof PriceClass];
export declare const GeoRestrictionType: {
  readonly blacklist: "blacklist";
  readonly none: "none";
  readonly whitelist: "whitelist";
};
export type GeoRestrictionType =
  (typeof GeoRestrictionType)[keyof typeof GeoRestrictionType];
export interface GeoRestriction {
  RestrictionType: GeoRestrictionType | undefined;
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface Restrictions {
  GeoRestriction: GeoRestriction | undefined;
}
export interface StringSchemaConfig {
  Comment?: string | undefined;
  DefaultValue?: string | undefined;
  Required: boolean | undefined;
}
export interface ParameterDefinitionSchema {
  StringSchema?: StringSchemaConfig | undefined;
}
export interface ParameterDefinition {
  Name: string | undefined;
  Definition: ParameterDefinitionSchema | undefined;
}
export interface TenantConfig {
  ParameterDefinitions?: ParameterDefinition[] | undefined;
}
export declare const MinimumProtocolVersion: {
  readonly SSLv3: "SSLv3";
  readonly TLSv1: "TLSv1";
  readonly TLSv1_1_2016: "TLSv1.1_2016";
  readonly TLSv1_2016: "TLSv1_2016";
  readonly TLSv1_2_2018: "TLSv1.2_2018";
  readonly TLSv1_2_2019: "TLSv1.2_2019";
  readonly TLSv1_2_2021: "TLSv1.2_2021";
  readonly TLSv1_2_2025: "TLSv1.2_2025";
  readonly TLSv1_3_2025: "TLSv1.3_2025";
};
export type MinimumProtocolVersion =
  (typeof MinimumProtocolVersion)[keyof typeof MinimumProtocolVersion];
export declare const SSLSupportMethod: {
  readonly sni_only: "sni-only";
  readonly static_ip: "static-ip";
  readonly vip: "vip";
};
export type SSLSupportMethod =
  (typeof SSLSupportMethod)[keyof typeof SSLSupportMethod];
export interface ViewerCertificate {
  CloudFrontDefaultCertificate?: boolean | undefined;
  IAMCertificateId?: string | undefined;
  ACMCertificateArn?: string | undefined;
  SSLSupportMethod?: SSLSupportMethod | undefined;
  MinimumProtocolVersion?: MinimumProtocolVersion | undefined;
  Certificate?: string | undefined;
  CertificateSource?: CertificateSource | undefined;
}
export interface DistributionConfig {
  CallerReference: string | undefined;
  Aliases?: Aliases | undefined;
  DefaultRootObject?: string | undefined;
  Origins: Origins | undefined;
  OriginGroups?: OriginGroups | undefined;
  DefaultCacheBehavior: DefaultCacheBehavior | undefined;
  CacheBehaviors?: CacheBehaviors | undefined;
  CustomErrorResponses?: CustomErrorResponses | undefined;
  Comment: string | undefined;
  Logging?: LoggingConfig | undefined;
  PriceClass?: PriceClass | undefined;
  Enabled: boolean | undefined;
  ViewerCertificate?: ViewerCertificate | undefined;
  Restrictions?: Restrictions | undefined;
  WebACLId?: string | undefined;
  HttpVersion?: HttpVersion | undefined;
  IsIPV6Enabled?: boolean | undefined;
  ContinuousDeploymentPolicyId?: string | undefined;
  Staging?: boolean | undefined;
  AnycastIpListId?: string | undefined;
  TenantConfig?: TenantConfig | undefined;
  ConnectionMode?: ConnectionMode | undefined;
}
export interface Distribution {
  Id: string | undefined;
  ARN: string | undefined;
  Status: string | undefined;
  LastModifiedTime: Date | undefined;
  InProgressInvalidationBatches: number | undefined;
  DomainName: string | undefined;
  ActiveTrustedSigners?: ActiveTrustedSigners | undefined;
  ActiveTrustedKeyGroups?: ActiveTrustedKeyGroups | undefined;
  DistributionConfig: DistributionConfig | undefined;
  AliasICPRecordals?: AliasICPRecordal[] | undefined;
}
export interface CopyDistributionResult {
  Distribution?: Distribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class DistributionAlreadyExists extends __BaseException {
  readonly name: "DistributionAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<DistributionAlreadyExists, __BaseException>
  );
}
export declare class IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior extends __BaseException {
  readonly name: "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior,
      __BaseException
    >
  );
}
export declare class InconsistentQuantities extends __BaseException {
  readonly name: "InconsistentQuantities";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InconsistentQuantities, __BaseException>
  );
}
export declare class InvalidDefaultRootObject extends __BaseException {
  readonly name: "InvalidDefaultRootObject";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidDefaultRootObject, __BaseException>
  );
}
export declare class InvalidErrorCode extends __BaseException {
  readonly name: "InvalidErrorCode";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<InvalidErrorCode, __BaseException>);
}
export declare class InvalidForwardCookies extends __BaseException {
  readonly name: "InvalidForwardCookies";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidForwardCookies, __BaseException>
  );
}
export declare class InvalidFunctionAssociation extends __BaseException {
  readonly name: "InvalidFunctionAssociation";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidFunctionAssociation, __BaseException>
  );
}
export declare class InvalidGeoRestrictionParameter extends __BaseException {
  readonly name: "InvalidGeoRestrictionParameter";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidGeoRestrictionParameter, __BaseException>
  );
}
export declare class InvalidHeadersForS3Origin extends __BaseException {
  readonly name: "InvalidHeadersForS3Origin";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidHeadersForS3Origin, __BaseException>
  );
}
export declare class InvalidLambdaFunctionAssociation extends __BaseException {
  readonly name: "InvalidLambdaFunctionAssociation";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      InvalidLambdaFunctionAssociation,
      __BaseException
    >
  );
}
export declare class InvalidLocationCode extends __BaseException {
  readonly name: "InvalidLocationCode";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidLocationCode, __BaseException>
  );
}
export declare class InvalidMinimumProtocolVersion extends __BaseException {
  readonly name: "InvalidMinimumProtocolVersion";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidMinimumProtocolVersion, __BaseException>
  );
}
export declare class InvalidOrigin extends __BaseException {
  readonly name: "InvalidOrigin";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<InvalidOrigin, __BaseException>);
}
export declare class InvalidOriginAccessControl extends __BaseException {
  readonly name: "InvalidOriginAccessControl";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidOriginAccessControl, __BaseException>
  );
}
export declare class InvalidOriginAccessIdentity extends __BaseException {
  readonly name: "InvalidOriginAccessIdentity";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidOriginAccessIdentity, __BaseException>
  );
}
export declare class InvalidOriginKeepaliveTimeout extends __BaseException {
  readonly name: "InvalidOriginKeepaliveTimeout";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidOriginKeepaliveTimeout, __BaseException>
  );
}
export declare class InvalidOriginReadTimeout extends __BaseException {
  readonly name: "InvalidOriginReadTimeout";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidOriginReadTimeout, __BaseException>
  );
}
export declare class InvalidProtocolSettings extends __BaseException {
  readonly name: "InvalidProtocolSettings";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidProtocolSettings, __BaseException>
  );
}
export declare class InvalidQueryStringParameters extends __BaseException {
  readonly name: "InvalidQueryStringParameters";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidQueryStringParameters, __BaseException>
  );
}
export declare class InvalidRelativePath extends __BaseException {
  readonly name: "InvalidRelativePath";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidRelativePath, __BaseException>
  );
}
export declare class InvalidRequiredProtocol extends __BaseException {
  readonly name: "InvalidRequiredProtocol";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidRequiredProtocol, __BaseException>
  );
}
export declare class InvalidResponseCode extends __BaseException {
  readonly name: "InvalidResponseCode";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidResponseCode, __BaseException>
  );
}
export declare class InvalidTTLOrder extends __BaseException {
  readonly name: "InvalidTTLOrder";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<InvalidTTLOrder, __BaseException>);
}
export declare class InvalidViewerCertificate extends __BaseException {
  readonly name: "InvalidViewerCertificate";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidViewerCertificate, __BaseException>
  );
}
export declare class InvalidWebACLId extends __BaseException {
  readonly name: "InvalidWebACLId";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<InvalidWebACLId, __BaseException>);
}
export declare class MissingBody extends __BaseException {
  readonly name: "MissingBody";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<MissingBody, __BaseException>);
}
export declare class NoSuchCachePolicy extends __BaseException {
  readonly name: "NoSuchCachePolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<NoSuchCachePolicy, __BaseException>);
}
export declare class NoSuchFieldLevelEncryptionConfig extends __BaseException {
  readonly name: "NoSuchFieldLevelEncryptionConfig";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      NoSuchFieldLevelEncryptionConfig,
      __BaseException
    >
  );
}
export declare class NoSuchOrigin extends __BaseException {
  readonly name: "NoSuchOrigin";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<NoSuchOrigin, __BaseException>);
}
export declare class NoSuchOriginRequestPolicy extends __BaseException {
  readonly name: "NoSuchOriginRequestPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NoSuchOriginRequestPolicy, __BaseException>
  );
}
export declare class NoSuchRealtimeLogConfig extends __BaseException {
  readonly name: "NoSuchRealtimeLogConfig";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NoSuchRealtimeLogConfig, __BaseException>
  );
}
export declare class NoSuchResponseHeadersPolicy extends __BaseException {
  readonly name: "NoSuchResponseHeadersPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NoSuchResponseHeadersPolicy, __BaseException>
  );
}
export declare class RealtimeLogConfigOwnerMismatch extends __BaseException {
  readonly name: "RealtimeLogConfigOwnerMismatch";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<RealtimeLogConfigOwnerMismatch, __BaseException>
  );
}
export declare class TooManyCacheBehaviors extends __BaseException {
  readonly name: "TooManyCacheBehaviors";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyCacheBehaviors, __BaseException>
  );
}
export declare class TooManyCertificates extends __BaseException {
  readonly name: "TooManyCertificates";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyCertificates, __BaseException>
  );
}
export declare class TooManyCookieNamesInWhiteList extends __BaseException {
  readonly name: "TooManyCookieNamesInWhiteList";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyCookieNamesInWhiteList, __BaseException>
  );
}
export declare class TooManyDistributions extends __BaseException {
  readonly name: "TooManyDistributions";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyDistributions, __BaseException>
  );
}
export declare class TooManyDistributionsAssociatedToCachePolicy extends __BaseException {
  readonly name: "TooManyDistributionsAssociatedToCachePolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsAssociatedToCachePolicy,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsAssociatedToFieldLevelEncryptionConfig extends __BaseException {
  readonly name: "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsAssociatedToFieldLevelEncryptionConfig,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsAssociatedToKeyGroup extends __BaseException {
  readonly name: "TooManyDistributionsAssociatedToKeyGroup";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsAssociatedToKeyGroup,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsAssociatedToOriginAccessControl extends __BaseException {
  readonly name: "TooManyDistributionsAssociatedToOriginAccessControl";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsAssociatedToOriginAccessControl,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsAssociatedToOriginRequestPolicy extends __BaseException {
  readonly name: "TooManyDistributionsAssociatedToOriginRequestPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsAssociatedToOriginRequestPolicy,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsAssociatedToResponseHeadersPolicy extends __BaseException {
  readonly name: "TooManyDistributionsAssociatedToResponseHeadersPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsAssociatedToResponseHeadersPolicy,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsWithFunctionAssociations extends __BaseException {
  readonly name: "TooManyDistributionsWithFunctionAssociations";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsWithFunctionAssociations,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsWithLambdaAssociations extends __BaseException {
  readonly name: "TooManyDistributionsWithLambdaAssociations";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsWithLambdaAssociations,
      __BaseException
    >
  );
}
export declare class TooManyDistributionsWithSingleFunctionARN extends __BaseException {
  readonly name: "TooManyDistributionsWithSingleFunctionARN";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyDistributionsWithSingleFunctionARN,
      __BaseException
    >
  );
}
export declare class TooManyFunctionAssociations extends __BaseException {
  readonly name: "TooManyFunctionAssociations";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyFunctionAssociations, __BaseException>
  );
}
export declare class TooManyHeadersInForwardedValues extends __BaseException {
  readonly name: "TooManyHeadersInForwardedValues";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyHeadersInForwardedValues,
      __BaseException
    >
  );
}
export declare class TooManyKeyGroupsAssociatedToDistribution extends __BaseException {
  readonly name: "TooManyKeyGroupsAssociatedToDistribution";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyKeyGroupsAssociatedToDistribution,
      __BaseException
    >
  );
}
export declare class TooManyLambdaFunctionAssociations extends __BaseException {
  readonly name: "TooManyLambdaFunctionAssociations";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyLambdaFunctionAssociations,
      __BaseException
    >
  );
}
export declare class TooManyOriginCustomHeaders extends __BaseException {
  readonly name: "TooManyOriginCustomHeaders";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyOriginCustomHeaders, __BaseException>
  );
}
export declare class TooManyOriginGroupsPerDistribution extends __BaseException {
  readonly name: "TooManyOriginGroupsPerDistribution";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyOriginGroupsPerDistribution,
      __BaseException
    >
  );
}
export declare class TooManyOrigins extends __BaseException {
  readonly name: "TooManyOrigins";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<TooManyOrigins, __BaseException>);
}
export declare class TooManyQueryStringParameters extends __BaseException {
  readonly name: "TooManyQueryStringParameters";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyQueryStringParameters, __BaseException>
  );
}
export declare class TooManyTrustedSigners extends __BaseException {
  readonly name: "TooManyTrustedSigners";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyTrustedSigners, __BaseException>
  );
}
export declare class TrustedKeyGroupDoesNotExist extends __BaseException {
  readonly name: "TrustedKeyGroupDoesNotExist";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TrustedKeyGroupDoesNotExist, __BaseException>
  );
}
export declare class TrustedSignerDoesNotExist extends __BaseException {
  readonly name: "TrustedSignerDoesNotExist";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TrustedSignerDoesNotExist, __BaseException>
  );
}
export interface Tag {
  Key: string | undefined;
  Value?: string | undefined;
}
export interface Tags {
  Items?: Tag[] | undefined;
}
export interface CreateAnycastIpListRequest {
  Name: string | undefined;
  IpCount: number | undefined;
  Tags?: Tags | undefined;
  IpAddressType?: IpAddressType | undefined;
}
export interface CreateAnycastIpListResult {
  AnycastIpList?: AnycastIpList | undefined;
  ETag?: string | undefined;
}
export declare class EntityAlreadyExists extends __BaseException {
  readonly name: "EntityAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<EntityAlreadyExists, __BaseException>
  );
}
export declare class EntityLimitExceeded extends __BaseException {
  readonly name: "EntityLimitExceeded";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<EntityLimitExceeded, __BaseException>
  );
}
export declare class InvalidTagging extends __BaseException {
  readonly name: "InvalidTagging";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<InvalidTagging, __BaseException>);
}
export declare class UnsupportedOperation extends __BaseException {
  readonly name: "UnsupportedOperation";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<UnsupportedOperation, __BaseException>
  );
}
export interface CreateCachePolicyRequest {
  CachePolicyConfig: CachePolicyConfig | undefined;
}
export interface CreateCachePolicyResult {
  CachePolicy?: CachePolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class TooManyCachePolicies extends __BaseException {
  readonly name: "TooManyCachePolicies";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyCachePolicies, __BaseException>
  );
}
export declare class TooManyCookiesInCachePolicy extends __BaseException {
  readonly name: "TooManyCookiesInCachePolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyCookiesInCachePolicy, __BaseException>
  );
}
export declare class TooManyHeadersInCachePolicy extends __BaseException {
  readonly name: "TooManyHeadersInCachePolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyHeadersInCachePolicy, __BaseException>
  );
}
export declare class TooManyQueryStringsInCachePolicy extends __BaseException {
  readonly name: "TooManyQueryStringsInCachePolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyQueryStringsInCachePolicy,
      __BaseException
    >
  );
}
export declare class CloudFrontOriginAccessIdentityAlreadyExists extends __BaseException {
  readonly name: "CloudFrontOriginAccessIdentityAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      CloudFrontOriginAccessIdentityAlreadyExists,
      __BaseException
    >
  );
}
export interface CloudFrontOriginAccessIdentityConfig {
  CallerReference: string | undefined;
  Comment: string | undefined;
}
export interface CreateCloudFrontOriginAccessIdentityRequest {
  CloudFrontOriginAccessIdentityConfig:
    | CloudFrontOriginAccessIdentityConfig
    | undefined;
}
export interface CloudFrontOriginAccessIdentity {
  Id: string | undefined;
  S3CanonicalUserId: string | undefined;
  CloudFrontOriginAccessIdentityConfig?:
    | CloudFrontOriginAccessIdentityConfig
    | undefined;
}
export interface CreateCloudFrontOriginAccessIdentityResult {
  CloudFrontOriginAccessIdentity?: CloudFrontOriginAccessIdentity | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class TooManyCloudFrontOriginAccessIdentities extends __BaseException {
  readonly name: "TooManyCloudFrontOriginAccessIdentities";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyCloudFrontOriginAccessIdentities,
      __BaseException
    >
  );
}
export interface CreateConnectionGroupRequest {
  Name: string | undefined;
  Ipv6Enabled?: boolean | undefined;
  Tags?: Tags | undefined;
  AnycastIpListId?: string | undefined;
  Enabled?: boolean | undefined;
}
export interface ConnectionGroup {
  Id?: string | undefined;
  Name?: string | undefined;
  Arn?: string | undefined;
  CreatedTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  Tags?: Tags | undefined;
  Ipv6Enabled?: boolean | undefined;
  RoutingEndpoint?: string | undefined;
  AnycastIpListId?: string | undefined;
  Status?: string | undefined;
  Enabled?: boolean | undefined;
  IsDefault?: boolean | undefined;
}
export interface CreateConnectionGroupResult {
  ConnectionGroup?: ConnectionGroup | undefined;
  ETag?: string | undefined;
}
export declare class ContinuousDeploymentPolicyAlreadyExists extends __BaseException {
  readonly name: "ContinuousDeploymentPolicyAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      ContinuousDeploymentPolicyAlreadyExists,
      __BaseException
    >
  );
}
export interface StagingDistributionDnsNames {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface ContinuousDeploymentSingleHeaderConfig {
  Header: string | undefined;
  Value: string | undefined;
}
export interface SessionStickinessConfig {
  IdleTTL: number | undefined;
  MaximumTTL: number | undefined;
}
export interface ContinuousDeploymentSingleWeightConfig {
  Weight: number | undefined;
  SessionStickinessConfig?: SessionStickinessConfig | undefined;
}
export declare const ContinuousDeploymentPolicyType: {
  readonly SingleHeader: "SingleHeader";
  readonly SingleWeight: "SingleWeight";
};
export type ContinuousDeploymentPolicyType =
  (typeof ContinuousDeploymentPolicyType)[keyof typeof ContinuousDeploymentPolicyType];
export interface TrafficConfig {
  SingleWeightConfig?: ContinuousDeploymentSingleWeightConfig | undefined;
  SingleHeaderConfig?: ContinuousDeploymentSingleHeaderConfig | undefined;
  Type: ContinuousDeploymentPolicyType | undefined;
}
export interface ContinuousDeploymentPolicyConfig {
  StagingDistributionDnsNames: StagingDistributionDnsNames | undefined;
  Enabled: boolean | undefined;
  TrafficConfig?: TrafficConfig | undefined;
}
export interface CreateContinuousDeploymentPolicyRequest {
  ContinuousDeploymentPolicyConfig:
    | ContinuousDeploymentPolicyConfig
    | undefined;
}
export interface ContinuousDeploymentPolicy {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  ContinuousDeploymentPolicyConfig:
    | ContinuousDeploymentPolicyConfig
    | undefined;
}
export interface CreateContinuousDeploymentPolicyResult {
  ContinuousDeploymentPolicy?: ContinuousDeploymentPolicy | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class StagingDistributionInUse extends __BaseException {
  readonly name: "StagingDistributionInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<StagingDistributionInUse, __BaseException>
  );
}
export declare class TooManyContinuousDeploymentPolicies extends __BaseException {
  readonly name: "TooManyContinuousDeploymentPolicies";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyContinuousDeploymentPolicies,
      __BaseException
    >
  );
}
export declare class ContinuousDeploymentPolicyInUse extends __BaseException {
  readonly name: "ContinuousDeploymentPolicyInUse";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      ContinuousDeploymentPolicyInUse,
      __BaseException
    >
  );
}
export interface CreateDistributionRequest {
  DistributionConfig: DistributionConfig | undefined;
}
export interface CreateDistributionResult {
  Distribution?: Distribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class IllegalOriginAccessConfiguration extends __BaseException {
  readonly name: "IllegalOriginAccessConfiguration";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      IllegalOriginAccessConfiguration,
      __BaseException
    >
  );
}
export declare class InvalidDomainNameForOriginAccessControl extends __BaseException {
  readonly name: "InvalidDomainNameForOriginAccessControl";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      InvalidDomainNameForOriginAccessControl,
      __BaseException
    >
  );
}
export declare class NoSuchContinuousDeploymentPolicy extends __BaseException {
  readonly name: "NoSuchContinuousDeploymentPolicy";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      NoSuchContinuousDeploymentPolicy,
      __BaseException
    >
  );
}
export interface GeoRestrictionCustomization {
  RestrictionType: GeoRestrictionType | undefined;
  Locations?: string[] | undefined;
}
export declare const CustomizationActionType: {
  readonly disable: "disable";
  readonly override: "override";
};
export type CustomizationActionType =
  (typeof CustomizationActionType)[keyof typeof CustomizationActionType];
export interface WebAclCustomization {
  Action: CustomizationActionType | undefined;
  Arn?: string | undefined;
}
export interface Customizations {
  WebAcl?: WebAclCustomization | undefined;
  Certificate?: Certificate | undefined;
  GeoRestrictions?: GeoRestrictionCustomization | undefined;
}
export interface DomainItem {
  Domain: string | undefined;
}
export declare const ValidationTokenHost: {
  readonly CloudFront: "cloudfront";
  readonly SelfHosted: "self-hosted";
};
export type ValidationTokenHost =
  (typeof ValidationTokenHost)[keyof typeof ValidationTokenHost];
export interface ManagedCertificateRequest {
  ValidationTokenHost: ValidationTokenHost | undefined;
  PrimaryDomainName?: string | undefined;
  CertificateTransparencyLoggingPreference?:
    | CertificateTransparencyLoggingPreference
    | undefined;
}
export interface Parameter {
  Name: string | undefined;
  Value: string | undefined;
}
export interface CreateDistributionTenantRequest {
  DistributionId: string | undefined;
  Name: string | undefined;
  Domains: DomainItem[] | undefined;
  Tags?: Tags | undefined;
  Customizations?: Customizations | undefined;
  Parameters?: Parameter[] | undefined;
  ConnectionGroupId?: string | undefined;
  ManagedCertificateRequest?: ManagedCertificateRequest | undefined;
  Enabled?: boolean | undefined;
}
export declare const DomainStatus: {
  readonly Active: "active";
  readonly Inactive: "inactive";
};
export type DomainStatus = (typeof DomainStatus)[keyof typeof DomainStatus];
export interface DomainResult {
  Domain: string | undefined;
  Status?: DomainStatus | undefined;
}
export interface DistributionTenant {
  Id?: string | undefined;
  DistributionId?: string | undefined;
  Name?: string | undefined;
  Arn?: string | undefined;
  Domains?: DomainResult[] | undefined;
  Tags?: Tags | undefined;
  Customizations?: Customizations | undefined;
  Parameters?: Parameter[] | undefined;
  ConnectionGroupId?: string | undefined;
  CreatedTime?: Date | undefined;
  LastModifiedTime?: Date | undefined;
  Enabled?: boolean | undefined;
  Status?: string | undefined;
}
export interface CreateDistributionTenantResult {
  DistributionTenant?: DistributionTenant | undefined;
  ETag?: string | undefined;
}
export declare class InvalidAssociation extends __BaseException {
  readonly name: "InvalidAssociation";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<InvalidAssociation, __BaseException>);
}
export interface DistributionConfigWithTags {
  DistributionConfig: DistributionConfig | undefined;
  Tags: Tags | undefined;
}
export interface CreateDistributionWithTagsRequest {
  DistributionConfigWithTags: DistributionConfigWithTags | undefined;
}
export interface CreateDistributionWithTagsResult {
  Distribution?: Distribution | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare const Format: {
  readonly URLEncoded: "URLEncoded";
};
export type Format = (typeof Format)[keyof typeof Format];
export interface ContentTypeProfile {
  Format: Format | undefined;
  ProfileId?: string | undefined;
  ContentType: string | undefined;
}
export interface ContentTypeProfiles {
  Quantity: number | undefined;
  Items?: ContentTypeProfile[] | undefined;
}
export interface ContentTypeProfileConfig {
  ForwardWhenContentTypeIsUnknown: boolean | undefined;
  ContentTypeProfiles?: ContentTypeProfiles | undefined;
}
export interface QueryArgProfile {
  QueryArg: string | undefined;
  ProfileId: string | undefined;
}
export interface QueryArgProfiles {
  Quantity: number | undefined;
  Items?: QueryArgProfile[] | undefined;
}
export interface QueryArgProfileConfig {
  ForwardWhenQueryArgProfileIsUnknown: boolean | undefined;
  QueryArgProfiles?: QueryArgProfiles | undefined;
}
export interface FieldLevelEncryptionConfig {
  CallerReference: string | undefined;
  Comment?: string | undefined;
  QueryArgProfileConfig?: QueryArgProfileConfig | undefined;
  ContentTypeProfileConfig?: ContentTypeProfileConfig | undefined;
}
export interface CreateFieldLevelEncryptionConfigRequest {
  FieldLevelEncryptionConfig: FieldLevelEncryptionConfig | undefined;
}
export interface FieldLevelEncryption {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  FieldLevelEncryptionConfig: FieldLevelEncryptionConfig | undefined;
}
export interface CreateFieldLevelEncryptionConfigResult {
  FieldLevelEncryption?: FieldLevelEncryption | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class FieldLevelEncryptionConfigAlreadyExists extends __BaseException {
  readonly name: "FieldLevelEncryptionConfigAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      FieldLevelEncryptionConfigAlreadyExists,
      __BaseException
    >
  );
}
export declare class NoSuchFieldLevelEncryptionProfile extends __BaseException {
  readonly name: "NoSuchFieldLevelEncryptionProfile";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      NoSuchFieldLevelEncryptionProfile,
      __BaseException
    >
  );
}
export declare class QueryArgProfileEmpty extends __BaseException {
  readonly name: "QueryArgProfileEmpty";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<QueryArgProfileEmpty, __BaseException>
  );
}
export declare class TooManyFieldLevelEncryptionConfigs extends __BaseException {
  readonly name: "TooManyFieldLevelEncryptionConfigs";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyFieldLevelEncryptionConfigs,
      __BaseException
    >
  );
}
export declare class TooManyFieldLevelEncryptionContentTypeProfiles extends __BaseException {
  readonly name: "TooManyFieldLevelEncryptionContentTypeProfiles";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyFieldLevelEncryptionContentTypeProfiles,
      __BaseException
    >
  );
}
export declare class TooManyFieldLevelEncryptionQueryArgProfiles extends __BaseException {
  readonly name: "TooManyFieldLevelEncryptionQueryArgProfiles";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyFieldLevelEncryptionQueryArgProfiles,
      __BaseException
    >
  );
}
export interface FieldPatterns {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface EncryptionEntity {
  PublicKeyId: string | undefined;
  ProviderId: string | undefined;
  FieldPatterns: FieldPatterns | undefined;
}
export interface EncryptionEntities {
  Quantity: number | undefined;
  Items?: EncryptionEntity[] | undefined;
}
export interface FieldLevelEncryptionProfileConfig {
  Name: string | undefined;
  CallerReference: string | undefined;
  Comment?: string | undefined;
  EncryptionEntities: EncryptionEntities | undefined;
}
export interface CreateFieldLevelEncryptionProfileRequest {
  FieldLevelEncryptionProfileConfig:
    | FieldLevelEncryptionProfileConfig
    | undefined;
}
export interface FieldLevelEncryptionProfile {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  FieldLevelEncryptionProfileConfig:
    | FieldLevelEncryptionProfileConfig
    | undefined;
}
export interface CreateFieldLevelEncryptionProfileResult {
  FieldLevelEncryptionProfile?: FieldLevelEncryptionProfile | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class FieldLevelEncryptionProfileAlreadyExists extends __BaseException {
  readonly name: "FieldLevelEncryptionProfileAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      FieldLevelEncryptionProfileAlreadyExists,
      __BaseException
    >
  );
}
export declare class FieldLevelEncryptionProfileSizeExceeded extends __BaseException {
  readonly name: "FieldLevelEncryptionProfileSizeExceeded";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      FieldLevelEncryptionProfileSizeExceeded,
      __BaseException
    >
  );
}
export declare class NoSuchPublicKey extends __BaseException {
  readonly name: "NoSuchPublicKey";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<NoSuchPublicKey, __BaseException>);
}
export declare class TooManyFieldLevelEncryptionEncryptionEntities extends __BaseException {
  readonly name: "TooManyFieldLevelEncryptionEncryptionEntities";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyFieldLevelEncryptionEncryptionEntities,
      __BaseException
    >
  );
}
export declare class TooManyFieldLevelEncryptionFieldPatterns extends __BaseException {
  readonly name: "TooManyFieldLevelEncryptionFieldPatterns";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyFieldLevelEncryptionFieldPatterns,
      __BaseException
    >
  );
}
export declare class TooManyFieldLevelEncryptionProfiles extends __BaseException {
  readonly name: "TooManyFieldLevelEncryptionProfiles";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TooManyFieldLevelEncryptionProfiles,
      __BaseException
    >
  );
}
export interface KeyValueStoreAssociation {
  KeyValueStoreARN: string | undefined;
}
export interface KeyValueStoreAssociations {
  Quantity: number | undefined;
  Items?: KeyValueStoreAssociation[] | undefined;
}
export declare const FunctionRuntime: {
  readonly cloudfront_js_1_0: "cloudfront-js-1.0";
  readonly cloudfront_js_2_0: "cloudfront-js-2.0";
};
export type FunctionRuntime =
  (typeof FunctionRuntime)[keyof typeof FunctionRuntime];
export interface FunctionConfig {
  Comment: string | undefined;
  Runtime: FunctionRuntime | undefined;
  KeyValueStoreAssociations?: KeyValueStoreAssociations | undefined;
}
export interface CreateFunctionRequest {
  Name: string | undefined;
  FunctionConfig: FunctionConfig | undefined;
  FunctionCode: Uint8Array | undefined;
}
export declare const FunctionStage: {
  readonly DEVELOPMENT: "DEVELOPMENT";
  readonly LIVE: "LIVE";
};
export type FunctionStage = (typeof FunctionStage)[keyof typeof FunctionStage];
export interface FunctionMetadata {
  FunctionARN: string | undefined;
  Stage?: FunctionStage | undefined;
  CreatedTime?: Date | undefined;
  LastModifiedTime: Date | undefined;
}
export interface FunctionSummary {
  Name: string | undefined;
  Status?: string | undefined;
  FunctionConfig: FunctionConfig | undefined;
  FunctionMetadata: FunctionMetadata | undefined;
}
export interface CreateFunctionResult {
  FunctionSummary?: FunctionSummary | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class FunctionAlreadyExists extends __BaseException {
  readonly name: "FunctionAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<FunctionAlreadyExists, __BaseException>
  );
}
export declare class FunctionSizeLimitExceeded extends __BaseException {
  readonly name: "FunctionSizeLimitExceeded";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<FunctionSizeLimitExceeded, __BaseException>
  );
}
export declare class TooManyFunctions extends __BaseException {
  readonly name: "TooManyFunctions";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<TooManyFunctions, __BaseException>);
}
export interface Paths {
  Quantity: number | undefined;
  Items?: string[] | undefined;
}
export interface InvalidationBatch {
  Paths: Paths | undefined;
  CallerReference: string | undefined;
}
export interface CreateInvalidationRequest {
  DistributionId: string | undefined;
  InvalidationBatch: InvalidationBatch | undefined;
}
export interface Invalidation {
  Id: string | undefined;
  Status: string | undefined;
  CreateTime: Date | undefined;
  InvalidationBatch: InvalidationBatch | undefined;
}
export interface CreateInvalidationResult {
  Location?: string | undefined;
  Invalidation?: Invalidation | undefined;
}
export declare class TooManyInvalidationsInProgress extends __BaseException {
  readonly name: "TooManyInvalidationsInProgress";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyInvalidationsInProgress, __BaseException>
  );
}
export interface CreateInvalidationForDistributionTenantRequest {
  Id: string | undefined;
  InvalidationBatch: InvalidationBatch | undefined;
}
export interface CreateInvalidationForDistributionTenantResult {
  Location?: string | undefined;
  Invalidation?: Invalidation | undefined;
}
export interface KeyGroupConfig {
  Name: string | undefined;
  Items: string[] | undefined;
  Comment?: string | undefined;
}
export interface CreateKeyGroupRequest {
  KeyGroupConfig: KeyGroupConfig | undefined;
}
export interface KeyGroup {
  Id: string | undefined;
  LastModifiedTime: Date | undefined;
  KeyGroupConfig: KeyGroupConfig | undefined;
}
export interface CreateKeyGroupResult {
  KeyGroup?: KeyGroup | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare class KeyGroupAlreadyExists extends __BaseException {
  readonly name: "KeyGroupAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<KeyGroupAlreadyExists, __BaseException>
  );
}
export declare class TooManyKeyGroups extends __BaseException {
  readonly name: "TooManyKeyGroups";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(opts: __ExceptionOptionType<TooManyKeyGroups, __BaseException>);
}
export declare class TooManyPublicKeysInKeyGroup extends __BaseException {
  readonly name: "TooManyPublicKeysInKeyGroup";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TooManyPublicKeysInKeyGroup, __BaseException>
  );
}
export declare const ImportSourceType: {
  readonly S3: "S3";
};
export type ImportSourceType =
  (typeof ImportSourceType)[keyof typeof ImportSourceType];
export interface ImportSource {
  SourceType: ImportSourceType | undefined;
  SourceARN: string | undefined;
}
export interface CreateKeyValueStoreRequest {
  Name: string | undefined;
  Comment?: string | undefined;
  ImportSource?: ImportSource | undefined;
}
export interface KeyValueStore {
  Name: string | undefined;
  Id: string | undefined;
  Comment: string | undefined;
  ARN: string | undefined;
  Status?: string | undefined;
  LastModifiedTime: Date | undefined;
}
export interface CreateKeyValueStoreResult {
  KeyValueStore?: KeyValueStore | undefined;
  ETag?: string | undefined;
  Location?: string | undefined;
}
export declare class EntitySizeLimitExceeded extends __BaseException {
  readonly name: "EntitySizeLimitExceeded";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<EntitySizeLimitExceeded, __BaseException>
  );
}
export declare const RealtimeMetricsSubscriptionStatus: {
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
};
export type RealtimeMetricsSubscriptionStatus =
  (typeof RealtimeMetricsSubscriptionStatus)[keyof typeof RealtimeMetricsSubscriptionStatus];
export interface RealtimeMetricsSubscriptionConfig {
  RealtimeMetricsSubscriptionStatus:
    | RealtimeMetricsSubscriptionStatus
    | undefined;
}
export interface MonitoringSubscription {
  RealtimeMetricsSubscriptionConfig?:
    | RealtimeMetricsSubscriptionConfig
    | undefined;
}
export interface CreateMonitoringSubscriptionRequest {
  DistributionId: string | undefined;
  MonitoringSubscription: MonitoringSubscription | undefined;
}
export interface CreateMonitoringSubscriptionResult {
  MonitoringSubscription?: MonitoringSubscription | undefined;
}
export declare class MonitoringSubscriptionAlreadyExists extends __BaseException {
  readonly name: "MonitoringSubscriptionAlreadyExists";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      MonitoringSubscriptionAlreadyExists,
      __BaseException
    >
  );
}
export declare const OriginAccessControlOriginTypes: {
  readonly lambda: "lambda";
  readonly mediapackagev2: "mediapackagev2";
  readonly mediastore: "mediastore";
  readonly s3: "s3";
};
export type OriginAccessControlOriginTypes =
  (typeof OriginAccessControlOriginTypes)[keyof typeof OriginAccessControlOriginTypes];
export declare const OriginAccessControlSigningBehaviors: {
  readonly always: "always";
  readonly never: "never";
  readonly no_override: "no-override";
};
export type OriginAccessControlSigningBehaviors =
  (typeof OriginAccessControlSigningBehaviors)[keyof typeof OriginAccessControlSigningBehaviors];
export declare const OriginAccessControlSigningProtocols: {
  readonly sigv4: "sigv4";
};
export type OriginAccessControlSigningProtocols =
  (typeof OriginAccessControlSigningProtocols)[keyof typeof OriginAccessControlSigningProtocols];
export interface OriginAccessControlConfig {
  Name: string | undefined;
  Description?: string | undefined;
  SigningProtocol: OriginAccessControlSigningProtocols | undefined;
  SigningBehavior: OriginAccessControlSigningBehaviors | undefined;
  OriginAccessControlOriginType: OriginAccessControlOriginTypes | undefined;
}
export interface CreateOriginAccessControlRequest {
  OriginAccessControlConfig: OriginAccessControlConfig | undefined;
}
export interface OriginAccessControl {
  Id: string | undefined;
  OriginAccessControlConfig?: OriginAccessControlConfig | undefined;
}
export interface CreateOriginAccessControlResult {
  OriginAccessControl?: OriginAccessControl | undefined;
  Location?: string | undefined;
  ETag?: string | undefined;
}
export declare const OriginCustomHeaderFilterSensitiveLog: (
  obj: OriginCustomHeader
) => any;
export declare const CustomHeadersFilterSensitiveLog: (
  obj: CustomHeaders
) => any;
export declare const OriginFilterSensitiveLog: (obj: Origin) => any;
export declare const OriginsFilterSensitiveLog: (obj: Origins) => any;
export declare const StringSchemaConfigFilterSensitiveLog: (
  obj: StringSchemaConfig
) => any;
export declare const ParameterDefinitionSchemaFilterSensitiveLog: (
  obj: ParameterDefinitionSchema
) => any;
export declare const ParameterDefinitionFilterSensitiveLog: (
  obj: ParameterDefinition
) => any;
export declare const TenantConfigFilterSensitiveLog: (obj: TenantConfig) => any;
export declare const DistributionConfigFilterSensitiveLog: (
  obj: DistributionConfig
) => any;
export declare const DistributionFilterSensitiveLog: (obj: Distribution) => any;
export declare const CopyDistributionResultFilterSensitiveLog: (
  obj: CopyDistributionResult
) => any;
export declare const CreateDistributionRequestFilterSensitiveLog: (
  obj: CreateDistributionRequest
) => any;
export declare const CreateDistributionResultFilterSensitiveLog: (
  obj: CreateDistributionResult
) => any;
export declare const DistributionConfigWithTagsFilterSensitiveLog: (
  obj: DistributionConfigWithTags
) => any;
export declare const CreateDistributionWithTagsRequestFilterSensitiveLog: (
  obj: CreateDistributionWithTagsRequest
) => any;
export declare const CreateDistributionWithTagsResultFilterSensitiveLog: (
  obj: CreateDistributionWithTagsResult
) => any;
export declare const CreateFunctionRequestFilterSensitiveLog: (
  obj: CreateFunctionRequest
) => any;
