﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amplifyuibuilder/AmplifyUIBuilder_EXPORTS.h>
#include <aws/amplifyuibuilder/model/ComponentBindingPropertiesValueProperties.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AmplifyUIBuilder {
namespace Model {

/**
 * <p>Represents the data binding configuration for a component at runtime. You can
 * use <code>ComponentBindingPropertiesValue</code> to add exposed properties to a
 * component to allow different values to be entered when a component is reused in
 * different places in an app.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/ComponentBindingPropertiesValue">AWS
 * API Reference</a></p>
 */
class ComponentBindingPropertiesValue {
 public:
  AWS_AMPLIFYUIBUILDER_API ComponentBindingPropertiesValue() = default;
  AWS_AMPLIFYUIBUILDER_API ComponentBindingPropertiesValue(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFYUIBUILDER_API ComponentBindingPropertiesValue& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFYUIBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The property type.</p>
   */
  inline const Aws::String& GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  template <typename TypeT = Aws::String>
  void SetType(TypeT&& value) {
    m_typeHasBeenSet = true;
    m_type = std::forward<TypeT>(value);
  }
  template <typename TypeT = Aws::String>
  ComponentBindingPropertiesValue& WithType(TypeT&& value) {
    SetType(std::forward<TypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Describes the properties to customize with data at runtime.</p>
   */
  inline const ComponentBindingPropertiesValueProperties& GetBindingProperties() const { return m_bindingProperties; }
  inline bool BindingPropertiesHasBeenSet() const { return m_bindingPropertiesHasBeenSet; }
  template <typename BindingPropertiesT = ComponentBindingPropertiesValueProperties>
  void SetBindingProperties(BindingPropertiesT&& value) {
    m_bindingPropertiesHasBeenSet = true;
    m_bindingProperties = std::forward<BindingPropertiesT>(value);
  }
  template <typename BindingPropertiesT = ComponentBindingPropertiesValueProperties>
  ComponentBindingPropertiesValue& WithBindingProperties(BindingPropertiesT&& value) {
    SetBindingProperties(std::forward<BindingPropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The default value of the property.</p>
   */
  inline const Aws::String& GetDefaultValue() const { return m_defaultValue; }
  inline bool DefaultValueHasBeenSet() const { return m_defaultValueHasBeenSet; }
  template <typename DefaultValueT = Aws::String>
  void SetDefaultValue(DefaultValueT&& value) {
    m_defaultValueHasBeenSet = true;
    m_defaultValue = std::forward<DefaultValueT>(value);
  }
  template <typename DefaultValueT = Aws::String>
  ComponentBindingPropertiesValue& WithDefaultValue(DefaultValueT&& value) {
    SetDefaultValue(std::forward<DefaultValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_type;

  ComponentBindingPropertiesValueProperties m_bindingProperties;

  Aws::String m_defaultValue;
  bool m_typeHasBeenSet = false;
  bool m_bindingPropertiesHasBeenSet = false;
  bool m_defaultValueHasBeenSet = false;
};

}  // namespace Model
}  // namespace AmplifyUIBuilder
}  // namespace Aws
