﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/connectcases/model/CaseSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ConnectCases {
namespace Model {
class ListCasesForContactResult {
 public:
  AWS_CONNECTCASES_API ListCasesForContactResult() = default;
  AWS_CONNECTCASES_API ListCasesForContactResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECTCASES_API ListCasesForContactResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of Case summary information.</p>
   */
  inline const Aws::Vector<CaseSummary>& GetCases() const { return m_cases; }
  template <typename CasesT = Aws::Vector<CaseSummary>>
  void SetCases(CasesT&& value) {
    m_casesHasBeenSet = true;
    m_cases = std::forward<CasesT>(value);
  }
  template <typename CasesT = Aws::Vector<CaseSummary>>
  ListCasesForContactResult& WithCases(CasesT&& value) {
    SetCases(std::forward<CasesT>(value));
    return *this;
  }
  template <typename CasesT = CaseSummary>
  ListCasesForContactResult& AddCases(CasesT&& value) {
    m_casesHasBeenSet = true;
    m_cases.emplace_back(std::forward<CasesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next set of results. This is null if there are no more
   * results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCasesForContactResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListCasesForContactResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<CaseSummary> m_cases;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_casesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCases
}  // namespace Aws
