/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.storage.StringContentStorage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StyledTextUtils;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.data.IStreamValueEditorPersistent;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.content.ContentEditorInput;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsActivator;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class AbstractTextPanelEditor<EDITOR extends BaseTextEditor>
implements IStreamValueEditorPersistent<StyledText>,
DBPAdaptable {
    private static final String PREF_TEXT_EDITOR_WORD_WRAP = "content.text.editor.word-wrap";
    private static final String PREF_TEXT_EDITOR_AUTO_FORMAT = "content.text.editor.auto-format";
    private static final String PREF_TEXT_EDITOR_ENCODING = "content.text.editor.encoding";
    private static final String PREF_TEXT_EDITOR_MINIFY = "content.text.editor.minify";
    private static final Log log = Log.getLog(AbstractTextPanelEditor.class);
    private IValueController valueController;
    private IEditorSite subSite;
    private EDITOR editor;
    private Path tempFile;
    private MessageBar messageBar;
    private static IDialogSettings viewerSettings;

    @Override
    public StyledText createControl(IValueController valueController) {
        this.valueController = valueController;
        this.subSite = new SubEditorSite(valueController.getValueSite());
        this.editor = this.createEditorParty(valueController);
        try {
            this.editor.init(this.subSite, StringEditorInput.EMPTY_INPUT);
        }
        catch (PartInitException e) {
            valueController.showMessage(e.getMessage(), DBPMessageType.ERROR);
            return new StyledText(valueController.getEditPlaceholder(), 0);
        }
        GridLayout lt = new GridLayout(1, false);
        lt.marginWidth = 0;
        lt.marginHeight = 0;
        valueController.getEditPlaceholder().setLayout((Layout)lt);
        Composite cmpsBase = new Composite(valueController.getEditPlaceholder(), 0);
        cmpsBase.setLayout((Layout)lt);
        cmpsBase.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite cmpsInternalBase = new Composite(cmpsBase, 0);
        cmpsInternalBase.setLayout((Layout)lt);
        cmpsInternalBase.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.editor.createPartControl(cmpsInternalBase);
        this.reasignLayout(cmpsInternalBase);
        StyledText editorControl = this.editor.getEditorControl();
        assert (editorControl != null);
        this.initEditorSettings(editorControl);
        this.editor.addContextMenuContributor(manager -> this.contributeTextEditorActions(manager, editorControl));
        this.messageBar = new MessageBar(cmpsBase);
        this.messageBar.hideMessage();
        return editorControl;
    }

    private void reasignLayout(Composite cmpsInternalBase) {
        Control[] children = cmpsInternalBase.getChildren();
        Stream.of(children).forEach(c -> c.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1)));
    }

    protected abstract EDITOR createEditorParty(IValueController var1);

    protected void contributeTextEditorActions(@NotNull IContributionManager manager, @NotNull StyledText control) {
        manager.removeAll();
        Point selectionRange = control.getSelectionRange();
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.copy", selectionRange.y > 0, control, 17039369));
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.paste", control.getEditable(), control, 16908297));
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.cut", selectionRange.y > 0, control, 131199));
        manager.add((IAction)new StyledTextUtils.StyledTextAction("org.eclipse.ui.edit.selectAll", true, control, 262209));
        manager.add((IAction)new AutoFormatAction());
        manager.add((IAction)new WordWrapAction(control));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.editor.getSite(), (String)"org.eclipse.ui.edit.findReplace"));
        IAction preferencesAction = this.editor.getAction("Preferences.ContextAction");
        if (preferencesAction != null) {
            manager.add((IContributionItem)new Separator());
            manager.add(preferencesAction);
        }
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull StyledText control) {
    }

    @Override
    public void contributeSettings(@NotNull IContributionManager manager, final @NotNull StyledText editorControl) {
        manager.add((IContributionItem)new Separator());
        Action wwAction = new Action(ResultSetMessages.panel_editor_text_word_wrap_name, 2){

            public void run() {
                boolean newWW = !editorControl.getWordWrap();
                this.setChecked(newWW);
                editorControl.setWordWrap(newWW);
                AbstractTextPanelEditor.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_WORD_WRAP, newWW);
            }
        };
        wwAction.setChecked(editorControl.getWordWrap());
        manager.add((IAction)wwAction);
        EDITOR textEditor = this.getTextEditor();
        if (textEditor != null) {
            AutoFormatAction afAction = new AutoFormatAction();
            afAction.setChecked(AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_AUTO_FORMAT));
            manager.add((IAction)afAction);
            if (this.supportMinify()) {
                SaveMinifyValue msAction = new SaveMinifyValue();
                msAction.setChecked(AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_MINIFY));
                manager.add((IAction)msAction);
            }
        }
        if (textEditor != null) {
            manager.add((IAction)new Action(ResultSetMessages.panel_editor_text_encoding_name){

                public void run() {
                    StyledText control;
                    TextViewer viewer;
                    ChangeEncodingDialog dialog = new ChangeEncodingDialog(AbstractTextPanelEditor.getPanelSettings().get(AbstractTextPanelEditor.PREF_TEXT_EDITOR_ENCODING));
                    if (dialog.open() != 0) {
                        return;
                    }
                    AbstractTextPanelEditor.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_ENCODING, dialog.getEncoding());
                    Object editor = AbstractTextPanelEditor.this.getTextEditor();
                    if (editor != null && (viewer = editor.getTextViewer()) != null && (control = viewer.getTextWidget()) != null && !control.isDisposed()) {
                        try {
                            AbstractTextPanelEditor.this.primeEditorValue((DBRProgressMonitor)new VoidProgressMonitor(), control, (DBDContent)null);
                        }
                        catch (DBException e) {
                            log.error((Object)"Can't refresh editor", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void disposeEditor() {
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.tempFile != null) {
            try {
                Files.deleteIfExists(this.tempFile);
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
        }
    }

    protected EDITOR getTextEditor() {
        return this.editor;
    }

    private void initEditorSettings(StyledText control) {
        boolean wwEnabled = AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_WORD_WRAP);
        control.getWordWrap();
    }

    private void applyEditorStyle() {
        TextViewer textViewer;
        if (this.editor == null) {
            return;
        }
        StyledText textWidget = this.editor.getEditorControl();
        if (textWidget == null || textWidget.isDisposed()) {
            return;
        }
        if (AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_AUTO_FORMAT) && (textViewer = this.editor.getTextViewer()) != null) {
            boolean oldEditable = textViewer.isEditable();
            try {
                if (!oldEditable) {
                    textViewer.setEditable(true);
                }
                try {
                    if (textViewer.canDoOperation(15)) {
                        textViewer.doOperation(15);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("Error formatting text: " + e.getMessage()));
                }
            }
            finally {
                if (!oldEditable) {
                    textViewer.setEditable(false);
                }
            }
        }
        if (AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_WORD_WRAP)) {
            UIUtils.asyncExec(() -> {
                if (!textWidget.isDisposed()) {
                    textWidget.setWordWrap(true);
                }
            });
        }
    }

    public <T> T getAdapter(@NotNull Class<T> adapter) {
        EDITOR textEditor = this.getTextEditor();
        if (textEditor != null) {
            TextViewer textViewer;
            if (adapter.isAssignableFrom(textEditor.getClass())) {
                return adapter.cast(textEditor);
            }
            if (adapter == IUndoManager.class && (textViewer = textEditor.getTextViewer()) != null && textViewer.getUndoManager() != null) {
                return adapter.cast(textViewer.getUndoManager());
            }
            return (T)textEditor.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public void primeEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @Nullable DBDContent value) throws DBException {
        if (value == null) {
            log.error((Object)"Content value (LOB) is null");
            return;
        }
        if (this.editor == null) {
            log.error((Object)"Editor is null or undefined");
            return;
        }
        StyledText editorControl = this.editor.getEditorControl();
        if (editorControl == null) {
            return;
        }
        if (this.valueController.isReadOnly()) {
            editorControl.setBackground(UIStyles.getDefaultWidgetBackground());
        }
        try {
            try {
                editorControl.setRedraw(false);
                this.resetEditorInput();
                DBPPreferenceStore store = this.valueController.getExecutionContext() != null ? this.valueController.getExecutionContext().getDataSource().getContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
                int maxContentLength = store.getInt("resultset.edit.maxtextsize") * 1000;
                if (value.getContentLength() > (long)maxContentLength) {
                    this.showLimitedContent(editorControl, value, maxContentLength);
                } else {
                    this.showRegularContent(editorControl, monitor);
                }
            }
            catch (Exception e) {
                throw new DBException("Error loading text value", (Throwable)e);
            }
        }
        finally {
            monitor.done();
            editorControl.setRedraw(true);
        }
    }

    private void resetEditorInput() {
        UIUtils.syncExec(() -> {
            if (this.editor != null) {
                this.messageBar.hideMessage();
                this.editor.setInput(StringEditorInput.EMPTY_INPUT);
            }
        });
    }

    private void showRegularContent(StyledText editorControl, @NotNull DBRProgressMonitor monitor) throws DBException {
        String encoding = AbstractTextPanelEditor.getPanelSettings().get(PREF_TEXT_EDITOR_ENCODING);
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8.name();
        }
        ContentEditorInput textInput = new ContentEditorInput(this.valueController, null, null, encoding, monitor);
        TextViewer textViewer = this.editor.getTextViewer();
        if (textViewer != null) {
            long contentLength = textInput.getContentLength();
            StyledText textWidget = textViewer.getTextWidget();
            if (textWidget != null) {
                if (contentLength > 100000L) {
                    GC gc = new GC((Drawable)textWidget);
                    try {
                        UIUtils.drawMessageOverControl((Control)textWidget, (GC)gc, (String)NLS.bind((String)ResultSetMessages.panel_editor_text_loading_placeholder_label, (Object)contentLength), (int)0);
                    }
                    finally {
                        gc.dispose();
                    }
                }
                editorControl.setWordWrap(false);
                this.editor.setInput((IEditorInput)textInput);
                this.messageBar.hideMessage();
            } else {
                this.editor.setInput((IEditorInput)textInput);
            }
            this.applyEditorStyle();
        }
    }

    private void showLimitedContent(StyledText editorControl, @NotNull DBDContent value, int lengthInBytes) throws DBCException, IOException {
        DBDContentStorage contents = value.getContents((DBRProgressMonitor)new VoidProgressMonitor());
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream stream = contents.getContentStream();){
            byte[] displayingContentBytes = stream.readNBytes(lengthInBytes);
            String content = new String(displayingContentBytes);
            if (this.editor != null) {
                editorControl.setWordWrap(false);
                this.editor.setInput((IEditorInput)new StringEditorInput("Limited Content ", (CharSequence)content, true, StandardCharsets.UTF_8.name()));
                this.messageBar.showMessage(NLS.bind((String)ResultSetMessages.panel_editor_text_content_limitation_lbl, (Object)(lengthInBytes / 1000)));
            }
            this.applyEditorStyle();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    public Path getExternalFilePath(@NotNull StyledText control) {
        try {
            if (this.tempFile != null) {
                Files.deleteIfExists(this.tempFile);
            }
            this.tempFile = Files.createTempFile(DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), this.getFileFolderName()), "file", this.getFileExtension(), new FileAttribute[0]);
            this.tempFile.toFile().deleteOnExit();
            Files.writeString(this.tempFile, (CharSequence)control.getText(), new OpenOption[0]);
            return this.tempFile;
        }
        catch (IOException e) {
            log.error((Object)e);
            return null;
        }
    }

    protected abstract String getFileFolderName();

    protected abstract String getFileExtension();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void extractEditorValue(@NotNull DBRProgressMonitor monitor, @NotNull StyledText control, @NotNull DBDContent value) throws DBException {
        if (this.valueController.getValue() instanceof DBDContent) {
            monitor.beginTask("Extract text", 1);
            try {
                try {
                    monitor.subTask("Extracting text from editor");
                    this.editor.doSave(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                    IEditorInput editorInput = this.editor.getEditorInput();
                    if (!(editorInput instanceof ContentEditorInput)) return;
                    ContentEditorInput contentEditorInput = (ContentEditorInput)editorInput;
                    contentEditorInput.updateContentFromFile(monitor, value);
                    return;
                }
                catch (Exception e) {
                    throw new DBException("Error extracting text from editor", (Throwable)e);
                }
            }
            finally {
                monitor.done();
            }
        } else {
            String text = control.getText();
            if (AbstractTextPanelEditor.getPanelSettings().getBoolean(PREF_TEXT_EDITOR_MINIFY)) {
                text = this.minify(text);
            }
            value.updateContents(monitor, (DBDContentStorage)new StringContentStorage(text));
        }
    }

    public static IDialogSettings getPanelSettings() {
        if (viewerSettings == null) {
            viewerSettings = UIUtils.getSettingsSection((IDialogSettings)DataEditorsActivator.getDefault().getDialogSettings(), (String)AbstractTextPanelEditor.class.getSimpleName());
        }
        return viewerSettings;
    }

    public boolean supportMinify() {
        return false;
    }

    public String minify(String value) {
        return value;
    }

    private class AutoFormatAction
    extends Action {
        AutoFormatAction() {
            super(ResultSetMessages.panel_editor_text_auto_format_name, 2);
        }

        public boolean isChecked() {
            return AbstractTextPanelEditor.getPanelSettings().getBoolean(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT);
        }

        public void run() {
            boolean newAF = !AbstractTextPanelEditor.getPanelSettings().getBoolean(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT);
            AbstractTextPanelEditor.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_AUTO_FORMAT, newAF);
            AbstractTextPanelEditor.this.applyEditorStyle();
        }
    }

    private static class ChangeEncodingDialog
    extends BaseDialog {
        private String encoding;

        public ChangeEncodingDialog(@NotNull String defaultEncoding) {
            super(UIUtils.getActiveShell(), ResultSetMessages.panel_editor_text_encoding_title, null);
            this.encoding = defaultEncoding;
            this.setShellStyle(2144);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            Composite innerComposite = UIUtils.createComposite((Composite)composite, (int)1);
            innerComposite.setLayoutData((Object)new GridData(768));
            Combo encodingCombo = UIUtils.createEncodingCombo((Composite)innerComposite, (String)this.encoding);
            encodingCombo.setLayoutData((Object)new GridData(768));
            encodingCombo.addModifyListener(event -> {
                this.encoding = encodingCombo.getText();
                this.updateCompletion();
            });
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.updateCompletion();
        }

        private void updateCompletion() {
            Button button = this.getButton(0);
            try {
                Charset.forName(this.encoding);
                button.setEnabled(true);
            }
            catch (Exception exception) {
                button.setEnabled(false);
            }
        }

        @NotNull
        public String getEncoding() {
            return this.encoding;
        }
    }

    private static class MessageBar
    extends Composite {
        private final Link message;

        public MessageBar(@NotNull Composite parent) {
            super(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.setLayout((Layout)layout);
            this.setLayoutData(new GridData(4, 4, true, false));
            UIUtils.createLabelSeparator((Composite)this, (int)256);
            this.message = UIUtils.createInfoLink((Composite)this, (String)"", () -> UIUtils.showPreferencesFor((Shell)this.getShell(), null, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.resultset.editors"}));
        }

        public void showMessage(@NotNull String text) {
            this.message.setText(text);
            UIUtils.setControlVisible((Control)this, (boolean)true);
            this.getParent().layout(true, true);
        }

        public void hideMessage() {
            UIUtils.setControlVisible((Control)this, (boolean)false);
            this.getParent().layout(true, true);
        }
    }

    private class SaveMinifyValue
    extends Action {
        SaveMinifyValue() {
            super(ResultSetMessages.panel_editor_text_minify_name, 2);
        }

        public boolean isChecked() {
            return AbstractTextPanelEditor.getPanelSettings().getBoolean(AbstractTextPanelEditor.PREF_TEXT_EDITOR_MINIFY);
        }

        public void run() {
            boolean newMF = !AbstractTextPanelEditor.getPanelSettings().getBoolean(AbstractTextPanelEditor.PREF_TEXT_EDITOR_MINIFY);
            AbstractTextPanelEditor.getPanelSettings().put(AbstractTextPanelEditor.PREF_TEXT_EDITOR_MINIFY, newMF);
            AbstractTextPanelEditor.this.applyEditorStyle();
        }
    }

    private static class WordWrapAction
    extends StyledTextUtils.StyledTextActionEx {
        private final StyledText text;

        WordWrapAction(StyledText text) {
            super("org.eclipse.ui.edit.text.toggleWordWrap", 2);
            this.text = text;
        }

        public boolean isChecked() {
            return this.text.getWordWrap();
        }

        public void run() {
            this.text.setWordWrap(!this.text.getWordWrap());
        }
    }
}

