/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.dnd.GClipboard;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeNodeTransferable;
import docking.widgets.tree.support.GTreeTransferHandler;
import ghidra.framework.main.datatree.Cuttable;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DataTreeDragNDropHandler;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;

public class DataTreeClipboardUtils {
    private static final ClipboardOwner DATATREE_CLIPBOARD_OWNER = (clipboard, contents) -> DataTreeClipboardUtils.clearCuttables(contents);

    public static void setClipboardContents(DataTree tree, TreePath[] paths) {
        DataTreeClipboardUtils.clearCuttables();
        Clipboard clipboard = GClipboard.getSystemClipboard();
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        for (TreePath element : paths) {
            GTreeNode node = (GTreeNode)element.getLastPathComponent();
            list.add(node);
        }
        GTreeNodeTransferable contents = new GTreeNodeTransferable((GTreeTransferHandler)tree.getDragNDropHandler(), list);
        try {
            clipboard.setContents((Transferable)contents, DATATREE_CLIPBOARD_OWNER);
        }
        catch (IllegalStateException ise) {
            Msg.showError(DataTreeClipboardUtils.class, (Component)((Object)tree), (String)"Unable to Access Clipboard", (Object)"Unable to perform cut/copy operation on the system clipboard.  The clipboard may just be busy at this time. Please try again.");
        }
    }

    public static void clearCuttables() {
        DataTreeClipboardUtils.clearCuttables(DataTreeClipboardUtils.getSystemClipboardTransferable());
    }

    public static void clearCuttables(Transferable transferable) {
        for (GTreeNode node : DataTreeClipboardUtils.getDataTreeNodesFromClipboard(transferable)) {
            if (!(node instanceof Cuttable)) continue;
            ((Cuttable)node).setIsCut(false);
        }
    }

    public static boolean isCuttablePresent() {
        for (GTreeNode node : DataTreeClipboardUtils.getDataTreeNodesFromClipboard()) {
            if (!(node instanceof Cuttable)) continue;
            return ((Cuttable)node).isCut();
        }
        return false;
    }

    public static List<GTreeNode> getDataTreeNodesFromClipboard() {
        Transferable transferable = DataTreeClipboardUtils.getSystemClipboardTransferable();
        return DataTreeClipboardUtils.getDataTreeNodesFromClipboard(transferable);
    }

    private static List<GTreeNode> getDataTreeNodesFromClipboard(Transferable transferable) {
        if (transferable != null && transferable.isDataFlavorSupported(DataTreeDragNDropHandler.localDomainFileTreeFlavor)) {
            try {
                List list = (List)transferable.getTransferData(DataTreeDragNDropHandler.localDomainFileTreeFlavor);
                if (list != null) {
                    return list;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                Msg.debug(DataTreeClipboardUtils.class, (Object)"Failed retrieve tree nodes from clipboard", (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private static Transferable getSystemClipboardTransferable() {
        try {
            return GClipboard.getSystemClipboard().getContents(DataTreeClipboardUtils.class);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

