/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.app.plugin.core.calltree.CallTreeOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.apache.commons.collections4.map.LazyMap;
import resources.Icons;

public class IncomingCallNode
extends CallNode {
    private static final Icon INCOMING_ICON = Icons.ARROW_UP_LEFT_ICON;
    private static final Icon CALL_REFERENCE_ICON = IncomingCallNode.createIcon(INCOMING_ICON, true);
    private static final Icon NON_CALL_REFERENCE_ICON = IncomingCallNode.createIcon(INCOMING_ICON, false);
    private static final Icon RECURSIVE_CALL_REFERENCE_ICON = IncomingCallNode.createIcon(RECURSIVE_ICON, true);
    private static final Icon RECURSIVE_NON_CALL_REFERENCE_ICON = IncomingCallNode.createIcon(RECURSIVE_ICON, false);
    private Icon icon = null;
    private final Address functionAddress;
    protected final Program program;
    protected final Function function;
    protected String name;
    private final Address sourceAddress;

    IncomingCallNode(Program program, Function function, Address sourceAddress, boolean isCallReference, CallTreeOptions callTreeOptions) {
        super(callTreeOptions);
        this.program = program;
        this.function = function;
        this.name = function.getName(callTreeOptions.showNamespace());
        this.sourceAddress = sourceAddress;
        this.functionAddress = function.getEntryPoint();
        this.isCallReference = isCallReference;
    }

    @Override
    CallNode recreate() {
        return new IncomingCallNode(this.program, this.function, this.sourceAddress, this.isCallReference, this.callTreeOptions);
    }

    @Override
    public Function getRemoteFunction() {
        return this.function;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        this.doGenerateChildren(this.functionAddress, children, monitor);
        Collections.sort(children, new CallNode.CallNodeComparator(this));
        return children;
    }

    private void doGenerateChildren(Address address, List<GTreeNode> results, TaskMonitor monitor) throws CancelledException {
        ReferenceIterator refIter = this.program.getReferenceManager().getReferencesTo(address);
        LazyMap nodesByFunction = LazyMap.lazyMap(new HashMap(), k -> new ArrayList());
        FunctionManager functionManager = this.program.getFunctionManager();
        while (refIter.hasNext()) {
            monitor.checkCancelled();
            Reference ref = refIter.next();
            Address fromAddress = ref.getFromAddress();
            Function caller = functionManager.getFunctionContaining(fromAddress);
            if (caller == null) continue;
            if (caller.isThunk() && !this.callTreeOptions.allowsThunks()) {
                Address callerEntry = caller.getEntryPoint();
                if (address.equals((Object)callerEntry)) continue;
                this.doGenerateChildren(callerEntry, results, monitor);
                continue;
            }
            IncomingCallNode node = new IncomingCallNode(this.program, caller, fromAddress, ref.getReferenceType().isCall(), this.callTreeOptions);
            this.addNode((LazyMap<Function, List<GTreeNode>>)nodesByFunction, node);
        }
        List children = nodesByFunction.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
        results.addAll(children);
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public Icon getIcon(boolean expanded) {
        if (this.icon == null) {
            this.icon = this.functionIsInPath() ? (this.isCallReference ? RECURSIVE_CALL_REFERENCE_ICON : RECURSIVE_NON_CALL_REFERENCE_ICON) : (this.isCallReference ? CALL_REFERENCE_ICON : NON_CALL_REFERENCE_ICON);
        }
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLeaf() {
        return false;
    }
}

