/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.cmd.function.FunctionPurgeAnalysisCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class X86FunctionPurgeAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "X86 Function Callee Purge";
    private static final String DESCRIPTION = "Figures out the function Purge value for Callee cleaned up function call parameters (stdcall) on X86 platforms.";

    public X86FunctionPurgeAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setPriority(AnalysisPriority.FUNCTION_ANALYSIS);
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        FunctionPurgeAnalysisCmd cmd = new FunctionPurgeAnalysisCmd(set);
        cmd.applyTo((DomainObject)program, monitor);
        return true;
    }

    @Override
    public boolean canAnalyze(Program program) {
        Processor processor = program.getLanguage().getProcessor();
        if (program.getLanguage().getDefaultSpace().getSize() > 32) {
            return false;
        }
        return processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86"));
    }
}

