/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.Omf2or4;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfIndex;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfData;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;

public class OmfFixupRecord
extends OmfRecord {
    private Subrecord[] subrecs;
    private OmfData lastData = null;

    public OmfFixupRecord(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        ArrayList<Subrecord> subreclist = new ArrayList<Subrecord>();
        long max = this.dataReader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        while (this.dataReader.getPointerIndex() < max) {
            subreclist.add(Subrecord.readSubrecord(this.dataReader, this.hasBigFields()));
        }
        this.subrecs = new Subrecord[subreclist.size()];
        subreclist.toArray(this.subrecs);
    }

    public void setDataBlock(OmfData last) {
        this.lastData = last;
    }

    public OmfData getDataBlock() {
        return this.lastData;
    }

    public Subrecord[] getSubrecords() {
        return this.subrecs;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return OmfUtils.toOmfRecordDataType(this, OmfRecordTypes.getName(this.recordType));
    }

    public static class Subrecord {
        private byte first;
        private byte hiFixup;
        private byte fixData;
        private OmfIndex index;
        private OmfIndex frameDatum;
        private OmfIndex targetDatum;
        private Omf2or4 targetDisplacement;

        public static Subrecord readSubrecord(BinaryReader reader, boolean hasBigFields) throws IOException {
            Subrecord rec = new Subrecord();
            rec.first = reader.readNextByte();
            rec.index = new OmfIndex(1, -1);
            if (rec.isThreadSubrecord()) {
                int method = rec.getThreadMethod();
                if (method < 4) {
                    rec.index = OmfUtils.readIndex(reader);
                }
                return rec;
            }
            rec.targetDisplacement = new Omf2or4(2, 0L);
            rec.targetDatum = new OmfIndex(1, 0);
            rec.hiFixup = reader.readNextByte();
            rec.fixData = reader.readNextByte();
            int method = rec.getFrameMethod();
            if (!rec.isFrameThread() && method < 3) {
                rec.frameDatum = OmfUtils.readIndex(reader);
            }
            if (!rec.isTargetThread()) {
                rec.targetDatum = OmfUtils.readIndex(reader);
            }
            if ((rec.fixData & 4) == 0) {
                rec.targetDisplacement = OmfUtils.readInt2Or4(reader, hasBigFields);
            }
            return rec;
        }

        public boolean isThreadSubrecord() {
            return (this.first & 0x80) == 0;
        }

        public int getThreadMethod() {
            return this.first >> 2 & 7;
        }

        public boolean isFrameInSubThread() {
            return (this.first & 0x40) != 0;
        }

        public int getIndex() {
            return this.index.value();
        }

        public int getThreadNum() {
            return this.first & 3;
        }

        public boolean isFrameThread() {
            return (this.fixData & 0x80) != 0;
        }

        public boolean isTargetThread() {
            return (this.fixData & 8) != 0;
        }

        public int getFrameMethod() {
            return this.fixData >> 4 & 7;
        }

        public int getFixThreadNum() {
            return this.fixData & 3;
        }

        public int getFixMethodWithSub(Subrecord rec) {
            return this.fixData & 4 | rec.getThreadMethod() & 3;
        }

        public int getFixMethod() {
            return this.fixData & 7;
        }

        public int getTargetDatum() {
            return this.targetDatum.value();
        }

        public int getTargetDisplacement() {
            return (int)this.targetDisplacement.value();
        }

        public int getLocationType() {
            return this.first >> 2 & 0xF;
        }

        public int getDataRecordOffset() {
            return (this.first & 3) << 8 | this.hiFixup & 0xFF;
        }

        public boolean isSegmentRelative() {
            return (this.first & 0x40) != 0;
        }
    }
}

