/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.features.base.memsearch.gui.MemoryMatchTableLoader;
import ghidra.features.base.memsearch.searcher.MemoryMatch;
import ghidra.features.base.memsearch.searcher.MemorySearcher;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.task.TaskMonitor;
import java.util.Iterator;

public class NewSearchTableLoader
implements MemoryMatchTableLoader {
    private MemorySearcher memSearcher;
    private boolean completedSearch;
    private MemoryMatch firstMatch;

    NewSearchTableLoader(MemorySearcher memSearcher) {
        this.memSearcher = memSearcher;
    }

    @Override
    public void loadResults(Accumulator<MemoryMatch> accumulator, TaskMonitor monitor) {
        this.completedSearch = this.memSearcher.findAll(accumulator, monitor);
        Iterator iterator = accumulator.iterator();
        if (iterator.hasNext()) {
            this.firstMatch = (MemoryMatch)iterator.next();
        }
    }

    @Override
    public boolean didTerminateEarly() {
        return !this.completedSearch;
    }

    @Override
    public void dispose() {
    }

    @Override
    public MemoryMatch getFirstMatch() {
        return this.firstMatch;
    }

    @Override
    public boolean hasResults() {
        return this.firstMatch != null;
    }
}

