/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class IntegerFormatModel
implements UniversalDataFormatModel {
    private int symbolSize = 11;

    @Override
    public String getName() {
        return "Integer";
    }

    @Override
    public int getUnitByteSize() {
        return 4;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        int i = block.getInt(index);
        String str = Integer.toString(i);
        return this.pad(str);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int pos, char c) throws ByteBlockAccessException {
        return false;
    }

    @Override
    public int getGroupSize() {
        return 1;
    }

    @Override
    public void setGroupSize(int groupSize) {
        throw new UnsupportedOperationException("groups are not supported");
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    @Override
    public boolean validateBytesPerLine(int bytesPerLine) {
        return bytesPerLine % 4 == 0;
    }

    private String pad(String value) {
        StringBuffer sb = new StringBuffer();
        int len = this.symbolSize - value.length();
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
        }
        sb.append(value);
        return sb.toString();
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Integer");
    }

    @Override
    public void dispose() {
    }
}

