/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import docking.widgets.OptionDialog;
import ghidra.debug.api.tracermi.TerminalSession;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LaunchFailureDialog
extends OptionDialog {
    private static final String MSGPAT_PART_TOP = "<html><body width=\"400px\">\n<h3>Failed to launch '%s' due to an exception:</h3>\n\n<tt>%s</tt>\n\n<h3>Troubleshooting</h3>\n<p>\n<b>Check the Terminal!</b>\nIf no terminal is visible, check the menus: <b>Window &rarr; Terminals &rarr;\n...</b>.\nA path or other configuration parameter may be incorrect.\nThe back-end debugger may have paused for user input.\nThere may be a missing dependency.\nThere may be an incorrect version, etc.</p>\n\n";
    private static final String MSGPAT_PART_RESOURCES = "<h3>These resources remain after the failed launch:</h3>\n<ul>\n%s\n</ul>\n\n<h3>How do you want to proceed?</h3>\n<ul>\n<li>Choose <b>Keep</b> to stop here and diagnose or complete the launch manually.</li>\n<li>Choose <b>Retry</b> to clean up and retry at the launch dialog.</li>\n<li>Choose <b>Cancel</b> to clean up without retrying.</li>\n</ul>\n";
    private static final String MSGPAT_WITH_RESOURCES = "<html><body width=\"400px\">\n<h3>Failed to launch '%s' due to an exception:</h3>\n\n<tt>%s</tt>\n\n<h3>Troubleshooting</h3>\n<p>\n<b>Check the Terminal!</b>\nIf no terminal is visible, check the menus: <b>Window &rarr; Terminals &rarr;\n...</b>.\nA path or other configuration parameter may be incorrect.\nThe back-end debugger may have paused for user input.\nThere may be a missing dependency.\nThere may be an incorrect version, etc.</p>\n\n<h3>These resources remain after the failed launch:</h3>\n<ul>\n%s\n</ul>\n\n<h3>How do you want to proceed?</h3>\n<ul>\n<li>Choose <b>Keep</b> to stop here and diagnose or complete the launch manually.</li>\n<li>Choose <b>Retry</b> to clean up and retry at the launch dialog.</li>\n<li>Choose <b>Cancel</b> to clean up without retrying.</li>\n</ul>\n";
    private static final String MSGPAT_WITHOUT_RESOURCES = "<html><body width=\"400px\">\n<h3>Failed to launch '%s' due to an exception:</h3>\n\n<tt>%s</tt>\n\n<h3>Troubleshooting</h3>\n<p>\n<b>Check the Terminal!</b>\nIf no terminal is visible, check the menus: <b>Window &rarr; Terminals &rarr;\n...</b>.\nA path or other configuration parameter may be incorrect.\nThe back-end debugger may have paused for user input.\nThere may be a missing dependency.\nThere may be an incorrect version, etc.</p>\n\n";
    private static final int MAX_TERM_CONTENT_LINES = 2;

    protected static String formatMessage(TraceRmiLaunchOffer.LaunchResult result) {
        return LaunchFailureDialog.hasResources(result) ? MSGPAT_WITH_RESOURCES.formatted(LaunchFailureDialog.htmlProgramName(result), LaunchFailureDialog.htmlExceptionMessage(result), LaunchFailureDialog.htmlResources(result)) : "<html><body width=\"400px\">\n<h3>Failed to launch '%s' due to an exception:</h3>\n\n<tt>%s</tt>\n\n<h3>Troubleshooting</h3>\n<p>\n<b>Check the Terminal!</b>\nIf no terminal is visible, check the menus: <b>Window &rarr; Terminals &rarr;\n...</b>.\nA path or other configuration parameter may be incorrect.\nThe back-end debugger may have paused for user input.\nThere may be a missing dependency.\nThere may be an incorrect version, etc.</p>\n\n".formatted(LaunchFailureDialog.htmlProgramName(result), LaunchFailureDialog.htmlExceptionMessage(result));
    }

    protected static String htmlProgramName(TraceRmiLaunchOffer.LaunchResult result) {
        if (result.program() == null) {
            return "";
        }
        return "<tt>" + HTMLUtilities.escapeHTML((String)result.program().getName()) + "</tt>";
    }

    protected static String htmlExceptionMessage(TraceRmiLaunchOffer.LaunchResult result) {
        if (result.exception() == null) {
            return "(No exception)";
        }
        return HTMLUtilities.escapeHTML((String)result.exception().toString());
    }

    protected static boolean hasResources(TraceRmiLaunchOffer.LaunchResult result) {
        return !result.sessions().isEmpty() || result.acceptor() != null || result.connection() != null || result.trace() != null;
    }

    protected static String shorten(String title) {
        if (title.length() > 80) {
            return title.substring(0, 77) + "...";
        }
        return title;
    }

    protected static String htmlContent(TerminalSession session) {
        String content = session.content().trim();
        List<String> lines = Arrays.asList(content.split("\n"));
        String note = "";
        if (lines.size() >= 2) {
            note = "(last %d lines)".formatted(2);
            content = lines.subList(lines.size() - 2, lines.size()).stream().collect(Collectors.joining("\n"));
        }
        return "<div style=\"font:bold;\">Title: %s</div>%s\n<div style=\"background:black;color:white;\">\n<pre>%s</pre>".formatted(HTMLUtilities.escapeHTML((String)LaunchFailureDialog.shorten(session.title())), note, content);
    }

    protected static String htmlResources(TraceRmiLaunchOffer.LaunchResult result) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry ent : result.sessions().entrySet()) {
            TerminalSession session = (TerminalSession)ent.getValue();
            sb.append("<li>Terminal: %s &rarr; <tt>%s</tt>".formatted(HTMLUtilities.escapeHTML((String)((String)ent.getKey())), HTMLUtilities.escapeHTML((String)session.description())));
            if (session.isTerminated()) {
                sb.append(" (Terminated)");
            }
            sb.append("<div>\n");
            sb.append(LaunchFailureDialog.htmlContent(session));
            sb.append("</div>");
            sb.append("</li>\n");
        }
        if (result.acceptor() != null) {
            sb.append("<li>Acceptor: <tt>%s</tt></li>\n".formatted(HTMLUtilities.escapeHTML((String)result.acceptor().getAddress().toString())));
        }
        if (result.connection() != null) {
            sb.append("<li>Connection: <tt>%s</tt></li>\n".formatted(HTMLUtilities.escapeHTML((String)result.connection().getRemoteAddress().toString())));
        }
        if (result.trace() != null) {
            sb.append("<li>Trace: %s</li>\n".formatted(HTMLUtilities.escapeHTML((String)result.trace().getName())));
        }
        return sb.toString();
    }

    public static ErrPromptResponse show(TraceRmiLaunchOffer.LaunchResult result, HelpLocation helpLocation) {
        return switch (new LaunchFailureDialog(result, helpLocation).show()) {
            case 1 -> ErrPromptResponse.KEEP;
            case 2 -> ErrPromptResponse.RETRY;
            case 0 -> ErrPromptResponse.TERMINATE;
            default -> throw new AssertionError();
        };
    }

    protected LaunchFailureDialog(TraceRmiLaunchOffer.LaunchResult result, HelpLocation helpLocation) {
        super("Launch Failed", LaunchFailureDialog.formatMessage(result), LaunchFailureDialog.hasResources(result) ? "&Keep" : null, "&Retry", 0, null, true, "Retry");
        this.setHelpLocation(helpLocation);
    }

    public static enum ErrPromptResponse {
        KEEP,
        RETRY,
        TERMINATE;

    }
}

