/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.dnd.DragDropNode;
import docking.dnd.GenericDataFlavor;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DragDropTreeTransferable
implements Transferable,
ClipboardOwner {
    public static DataFlavor localTreeNodeFlavor = DragDropTreeTransferable.createLocalTreeNodeFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localTreeNodeFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private ArrayList<DragDropNode> dataList;

    private static DataFlavor createLocalTreeNodeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.util.ArrayList", "Local list of Drag/Drop Tree objects");
        }
        catch (Exception e) {
            Msg.showError(DragDropTreeTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    public DragDropTreeTransferable(DragDropNode[] nodes) {
        this.dataList = new ArrayList<DragDropNode>(Arrays.asList(nodes));
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localTreeNodeFlavor)) {
            return this.dataList;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "DragDropTreeTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

