/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.CoffSymbolRvaC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.CrossScopeExportsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.CrossScopeImportsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.FileChecksumsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.FrameDataC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.FuncMdTokenMapC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.IlLinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.InlineeLinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.LinesC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.MergedAssemblyInputC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringTableC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.SymbolsC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeMdTokenMapC13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.UnknownC13Section;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.Map;

enum C13Type {
    UNKNOWN(Integer.MIN_VALUE, UnknownC13Section.class),
    ALL(0, C13Section.class),
    SYMBOLS(241, SymbolsC13Section.class),
    LINES(242, LinesC13Section.class),
    STRING_TABLE(243, StringTableC13Section.class),
    FILE_CHECKSUMS(244, FileChecksumsC13Section.class),
    FRAMEDATA(245, FrameDataC13Section.class),
    INLINEE_LINES(246, InlineeLinesC13Section.class),
    CROSS_SCOPE_IMPORTS(247, CrossScopeImportsC13Section.class),
    CROSS_SCOPE_EXPORTS(248, CrossScopeExportsC13Section.class),
    IL_LINES(249, IlLinesC13Section.class),
    FUNC_MDTOKEN_MAP(250, FuncMdTokenMapC13Section.class),
    TYPE_MDTOKEN_MAP(251, TypeMdTokenMapC13Section.class),
    MERGED_ASSEMBLY_INPUT(252, MergedAssemblyInputC13Section.class),
    COFF_SYMBOL_RVA(253, CoffSymbolRvaC13Section.class);

    private static final int IGNORE_BIT = Integer.MIN_VALUE;
    private static final int IGNORE_BIT_MASK = Integer.MAX_VALUE;
    private static final Map<Integer, C13Type> BY_VALUE;
    private static final Map<Class<? extends C13Section>, C13Type> BY_CLASS_VALUE;
    private final int value;
    private final Class<? extends C13Section> classValue;

    public static C13Type fromValue(int val) {
        C13Type t = BY_VALUE.getOrDefault(C13Type.maskIgnore(val), UNKNOWN);
        if (t == UNKNOWN) {
            Msg.debug(C13Type.class, (Object)String.format("C13Debug - Unknown section type %08x", val));
        }
        return t;
    }

    public static C13Type fromClassValue(Class<? extends C13Section> classVal) {
        C13Type t = BY_CLASS_VALUE.getOrDefault(classVal, UNKNOWN);
        if (t == UNKNOWN) {
            Msg.debug(C13Type.class, (Object)String.format("C13Debug - Unknown classValue %s", classVal.getSimpleName()));
        }
        return t;
    }

    static boolean ignore(int val) {
        return (val & Integer.MIN_VALUE) != 0;
    }

    static int maskIgnore(int val) {
        return val & Integer.MAX_VALUE;
    }

    private C13Type(int value, Class<? extends C13Section> classValue) {
        this.value = value;
        this.classValue = classValue;
    }

    public int getValue() {
        return this.value;
    }

    public Class<? extends C13Section> getSectionClass() {
        return this.classValue;
    }

    static {
        BY_VALUE = new HashMap<Integer, C13Type>();
        BY_CLASS_VALUE = new HashMap<Class<? extends C13Section>, C13Type>();
        for (C13Type val : C13Type.values()) {
            BY_VALUE.put(val.value, val);
            BY_CLASS_VALUE.put(val.classValue, val);
        }
    }
}

