/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.emulator;

import ghidra.app.emulator.Emulator;
import ghidra.program.model.address.AddressSpace;

public abstract class MemoryAccessFilter {
    private MemoryAccessFilter prevFilter;
    private MemoryAccessFilter nextFilter;
    protected Emulator emu;
    private boolean filterOnExecutionOnly = true;

    final void filterRead(AddressSpace spc, long off, int size, byte[] values) {
        if (this.filterOnExecutionOnly() && !this.emu.isExecuting()) {
            return;
        }
        this.processRead(spc, off, size, values);
        if (this.nextFilter != null) {
            this.nextFilter.filterRead(spc, off, size, values);
        }
    }

    protected abstract void processRead(AddressSpace var1, long var2, int var4, byte[] var5);

    final void filterWrite(AddressSpace spc, long off, int size, byte[] values) {
        if (this.filterOnExecutionOnly() && !this.emu.isExecuting()) {
            return;
        }
        this.processWrite(spc, off, size, values);
        if (this.nextFilter != null) {
            this.nextFilter.filterWrite(spc, off, size, values);
        }
    }

    protected abstract void processWrite(AddressSpace var1, long var2, int var4, byte[] var5);

    final void addFilter(Emulator emu) {
        this.emu = emu;
        this.nextFilter = emu.getFilteredMemState().setFilter(this);
        if (this.nextFilter != null) {
            this.nextFilter.prevFilter = this;
        }
    }

    public void dispose() {
        if (this.nextFilter != null) {
            this.nextFilter.prevFilter = this.prevFilter;
        }
        if (this.prevFilter != null) {
            this.prevFilter.nextFilter = this.nextFilter;
        } else {
            this.emu.getFilteredMemState().setFilter(this.nextFilter);
        }
    }

    public boolean filterOnExecutionOnly() {
        return this.filterOnExecutionOnly;
    }

    public void setFilterOnExecutionOnly(boolean filterOnExecutionOnly) {
        this.filterOnExecutionOnly = filterOnExecutionOnly;
    }
}

