/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.op.JitBinOp;
import ghidra.pcode.emu.jit.op.JitBranchIndOp;
import ghidra.pcode.emu.jit.op.JitBranchOp;
import ghidra.pcode.emu.jit.op.JitCBranchOp;
import ghidra.pcode.emu.jit.op.JitCallOtherDefOp;
import ghidra.pcode.emu.jit.op.JitCallOtherMissingOp;
import ghidra.pcode.emu.jit.op.JitCallOtherOp;
import ghidra.pcode.emu.jit.op.JitCatenateOp;
import ghidra.pcode.emu.jit.op.JitLoadOp;
import ghidra.pcode.emu.jit.op.JitNopOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.op.JitPhiOp;
import ghidra.pcode.emu.jit.op.JitStoreOp;
import ghidra.pcode.emu.jit.op.JitSynthSubPieceOp;
import ghidra.pcode.emu.jit.op.JitUnOp;
import ghidra.pcode.emu.jit.op.JitUnimplementedOp;
import ghidra.pcode.emu.jit.var.JitConstVal;
import ghidra.pcode.emu.jit.var.JitDirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitFailVal;
import ghidra.pcode.emu.jit.var.JitIndirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitInputVar;
import ghidra.pcode.emu.jit.var.JitMissingVar;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.emu.jit.var.JitVar;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public interface JitOpVisitor {
    default public void visitOp(JitOp op) {
        JitOp jitOp = op;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitUnOp.class, JitBinOp.class, JitStoreOp.class, JitLoadOp.class, JitCallOtherOp.class, JitCallOtherDefOp.class, JitCallOtherMissingOp.class, JitCatenateOp.class, JitPhiOp.class, JitSynthSubPieceOp.class, JitBranchOp.class, JitCBranchOp.class, JitBranchIndOp.class, JitUnimplementedOp.class, JitNopOp.class}, (Object)jitOp, n)) {
            case -1: {
                throw new NullPointerException("null op");
            }
            case 0: {
                JitUnOp unOp = (JitUnOp)jitOp;
                this.visitUnOp(unOp);
                break;
            }
            case 1: {
                JitBinOp binOp = (JitBinOp)jitOp;
                this.visitBinOp(binOp);
                break;
            }
            case 2: {
                JitStoreOp storeOp = (JitStoreOp)jitOp;
                this.visitStoreOp(storeOp);
                break;
            }
            case 3: {
                JitLoadOp loadOp = (JitLoadOp)jitOp;
                this.visitLoadOp(loadOp);
                break;
            }
            case 4: {
                JitCallOtherOp otherOp = (JitCallOtherOp)jitOp;
                this.visitCallOtherOp(otherOp);
                break;
            }
            case 5: {
                JitCallOtherDefOp otherOp = (JitCallOtherDefOp)jitOp;
                this.visitCallOtherDefOp(otherOp);
                break;
            }
            case 6: {
                JitCallOtherMissingOp otherOp = (JitCallOtherMissingOp)jitOp;
                this.visitCallOtherMissingOp(otherOp);
                break;
            }
            case 7: {
                JitCatenateOp catOp = (JitCatenateOp)jitOp;
                this.visitCatenateOp(catOp);
                break;
            }
            case 8: {
                JitPhiOp phiOp = (JitPhiOp)jitOp;
                this.visitPhiOp(phiOp);
                break;
            }
            case 9: {
                JitSynthSubPieceOp pieceOp = (JitSynthSubPieceOp)jitOp;
                this.visitSubPieceOp(pieceOp);
                break;
            }
            case 10: {
                JitBranchOp branchOp = (JitBranchOp)jitOp;
                this.visitBranchOp(branchOp);
                break;
            }
            case 11: {
                JitCBranchOp cBranchOp = (JitCBranchOp)jitOp;
                this.visitCBranchOp(cBranchOp);
                break;
            }
            case 12: {
                JitBranchIndOp branchIndOp = (JitBranchIndOp)jitOp;
                this.visitBranchIndOp(branchIndOp);
                break;
            }
            case 13: {
                JitUnimplementedOp unimplOp = (JitUnimplementedOp)jitOp;
                this.visitUnimplementedOp(unimplOp);
                break;
            }
            case 14: {
                JitNopOp nopOp = (JitNopOp)jitOp;
                this.visitNopOp(nopOp);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized op: " + String.valueOf(op)));
            }
        }
    }

    default public void visitUnOp(JitUnOp unOp) {
    }

    default public void visitBinOp(JitBinOp binOp) {
    }

    default public void visitStoreOp(JitStoreOp storeOp) {
    }

    default public void visitLoadOp(JitLoadOp loadOp) {
    }

    default public void visitCallOtherOp(JitCallOtherOp otherOp) {
    }

    default public void visitCallOtherDefOp(JitCallOtherDefOp otherOp) {
    }

    default public void visitCallOtherMissingOp(JitCallOtherMissingOp otherOp) {
    }

    default public void visitCatenateOp(JitCatenateOp catOp) {
    }

    default public void visitPhiOp(JitPhiOp phiOp) {
    }

    default public void visitSubPieceOp(JitSynthSubPieceOp pieceOp) {
    }

    default public void visitBranchOp(JitBranchOp branchOp) {
    }

    default public void visitCBranchOp(JitCBranchOp cBranchOp) {
    }

    default public void visitBranchIndOp(JitBranchIndOp branchIndOp) {
    }

    default public void visitUnimplementedOp(JitUnimplementedOp unimplOp) {
    }

    default public void visitNopOp(JitNopOp nopOp) {
    }

    default public void visitVal(JitVal v) {
        JitVal jitVal = v;
        Objects.requireNonNull(jitVal);
        JitVal jitVal2 = jitVal;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitConstVal.class, JitFailVal.class, JitVar.class}, (Object)jitVal2, n)) {
            case 0: {
                JitConstVal constVal = (JitConstVal)jitVal2;
                this.visitConstVal(constVal);
                break;
            }
            case 1: {
                JitFailVal failVal = (JitFailVal)jitVal2;
                this.visitFailVal(failVal);
                break;
            }
            case 2: {
                JitVar jVar = (JitVar)jitVal2;
                this.visitVar(jVar);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    default public void visitVar(JitVar v) {
        JitVar jitVar = v;
        Objects.requireNonNull(jitVar);
        JitVar jitVar2 = jitVar;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitInputVar.class, JitMissingVar.class, JitOutVar.class, JitDirectMemoryVar.class, JitIndirectMemoryVar.class}, (Object)jitVar2, n)) {
            case 0: {
                JitInputVar inputVar = (JitInputVar)jitVar2;
                this.visitInputVar(inputVar);
                break;
            }
            case 1: {
                JitMissingVar missingVar = (JitMissingVar)jitVar2;
                this.visitMissingVar(missingVar);
                break;
            }
            case 2: {
                JitOutVar outVar = (JitOutVar)jitVar2;
                this.visitOutVar(outVar);
                break;
            }
            case 3: {
                JitDirectMemoryVar dirMemVar = (JitDirectMemoryVar)jitVar2;
                this.visitDirectMemoryVar(dirMemVar);
                break;
            }
            case 4: {
                JitIndirectMemoryVar indMemVar = (JitIndirectMemoryVar)jitVar2;
                this.visitIndirectMemoryVar(indMemVar);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    default public void visitConstVal(JitConstVal constVal) {
    }

    default public void visitFailVal(JitFailVal failVal) {
    }

    default public void visitDirectMemoryVar(JitDirectMemoryVar dirMemVar) {
    }

    default public void visitIndirectMemoryVar(JitIndirectMemoryVar indMemVar) {
        throw new AssertionError();
    }

    default public void visitInputVar(JitInputVar inputVar) {
    }

    default public void visitMissingVar(JitMissingVar missingVar) {
    }

    default public void visitOutVar(JitOutVar outVar) {
    }
}

