/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.trace.model.Trace;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;

public class MapModulesBackgroundCommand
extends BackgroundCommand<Trace> {
    private final DebuggerStaticMappingService service;
    private final Collection<ModuleMapProposal.ModuleMapEntry> entries;

    public MapModulesBackgroundCommand(DebuggerStaticMappingService service, Collection<ModuleMapProposal.ModuleMapEntry> entries) {
        super("Map modules", true, true, true);
        this.service = service;
        this.entries = entries;
    }

    public boolean applyTo(Trace trace, TaskMonitor monitor) {
        try {
            this.service.addModuleMappings(this.entries, monitor, true);
        }
        catch (CancelledException e) {
            return false;
        }
        return true;
    }
}

