/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.control;

import db.Transaction;
import generic.theme.GIcon;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.PatchStep;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public enum ControlMode {
    RO_TARGET("Control Target w/ Edits Disabled", (Icon)new GIcon("icon.debugger.control.mode.ro.target")){

        @Override
        public boolean isTarget() {
            return true;
        }

        @Override
        public boolean followsPresent() {
            return true;
        }

        @Override
        public boolean canEdit(DebuggerCoordinates coordinates) {
            return false;
        }

        @Override
        public boolean isVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            return false;
        }

        @Override
        public CompletableFuture<Void> setVariable(PluginTool tool, DebuggerCoordinates coordinates, Address address, byte[] data) {
            return CompletableFuture.failedFuture((Throwable)new MemoryAccessException("Read-only mode"));
        }

        @Override
        public boolean useEmulatedBreakpoints() {
            return false;
        }

        @Override
        public boolean isSelectable(DebuggerCoordinates coordinates) {
            return coordinates.isAlive();
        }

        @Override
        public ControlMode getAlternative(DebuggerCoordinates coordinates) {
            return RW_EMULATOR;
        }
    }
    ,
    RW_TARGET("Control Target", (Icon)new GIcon("icon.debugger.control.mode.rw.target")){

        @Override
        public boolean isTarget() {
            return true;
        }

        @Override
        public boolean followsPresent() {
            return true;
        }

        @Override
        public boolean canEdit(DebuggerCoordinates coordinates) {
            return coordinates.isAliveAndPresent();
        }

        @Override
        public boolean isVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            if (!coordinates.isAliveAndPresent()) {
                return false;
            }
            Target target = coordinates.getTarget();
            return target.isVariableExists(this.platformFor(coordinates, address), coordinates.getThread(), coordinates.getFrame(), address, length);
        }

        @Override
        public CompletableFuture<Void> setVariable(PluginTool tool, DebuggerCoordinates coordinates, Address address, byte[] data) {
            Target target = coordinates.getTarget();
            if (target == null) {
                return CompletableFuture.failedFuture((Throwable)new MemoryAccessException("Trace has no live target"));
            }
            if (!coordinates.isAliveAndPresent()) {
                return CompletableFuture.failedFuture((Throwable)new MemoryAccessException("View is not the present"));
            }
            return target.writeVariableAsync(this.platformFor(coordinates, address), coordinates.getThread(), coordinates.getFrame(), address, data);
        }

        @Override
        public boolean useEmulatedBreakpoints() {
            return false;
        }

        @Override
        public boolean isSelectable(DebuggerCoordinates coordinates) {
            return coordinates.isAlive();
        }

        @Override
        public ControlMode getAlternative(DebuggerCoordinates coordinates) {
            return RW_EMULATOR;
        }
    }
    ,
    RO_TRACE("Control Trace w/ Edits Disabled", (Icon)new GIcon("icon.debugger.control.mode.ro.trace")){

        @Override
        public boolean isTarget() {
            return false;
        }

        @Override
        public boolean followsPresent() {
            return false;
        }

        @Override
        public boolean canEdit(DebuggerCoordinates coordinates) {
            return false;
        }

        @Override
        public boolean isVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            return false;
        }

        @Override
        public CompletableFuture<Void> setVariable(PluginTool tool, DebuggerCoordinates coordinates, Address address, byte[] data) {
            return CompletableFuture.failedFuture((Throwable)new MemoryAccessException("Read-only mode"));
        }

        @Override
        public boolean useEmulatedBreakpoints() {
            return true;
        }
    }
    ,
    RW_TRACE("Control Trace", (Icon)new GIcon("icon.debugger.control.mode.rw.trace")){

        @Override
        public boolean isTarget() {
            return false;
        }

        @Override
        public boolean followsPresent() {
            return false;
        }

        @Override
        public boolean canEdit(DebuggerCoordinates coordinates) {
            return coordinates.getTrace() != null;
        }

        @Override
        public boolean isVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            return address.isMemoryAddress() || coordinates.getThread() != null;
        }

        @Override
        public CompletableFuture<Void> setVariable(PluginTool tool, DebuggerCoordinates coordinates, Address guestAddress, byte[] data) {
            Trace trace = coordinates.getTrace();
            TracePlatform platform = this.platformFor(coordinates, guestAddress);
            long snap = coordinates.getViewSnap();
            Address hostAddress = platform.mapGuestToHost(guestAddress);
            if (hostAddress == null) {
                throw new IllegalArgumentException("Guest address " + String.valueOf(guestAddress) + " is not mapped");
            }
            try (Transaction tx = trace.openTransaction("Edit Variable");){
                Address overlayAddress;
                TraceMemoryManager memOrRegs;
                if (hostAddress.isRegisterAddress()) {
                    TraceThread thread = coordinates.getThread();
                    if (thread == null) {
                        throw new IllegalArgumentException("Register edits require a thread.");
                    }
                    TraceMemorySpace regs = trace.getMemoryManager().getMemoryRegisterSpace(thread, coordinates.getFrame(), true);
                    memOrRegs = regs;
                    overlayAddress = regs.getAddressSpace().getOverlayAddress(hostAddress);
                } else {
                    memOrRegs = trace.getMemoryManager();
                    overlayAddress = hostAddress;
                }
                if (memOrRegs.putBytes(snap, overlayAddress, ByteBuffer.wrap(data)) != data.length) {
                    CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture((Throwable)new MemoryAccessException());
                    return completableFuture;
                }
            }
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public boolean useEmulatedBreakpoints() {
            return true;
        }
    }
    ,
    RW_EMULATOR("Control Emulator", (Icon)new GIcon("icon.debugger.control.mode.rw.emulator")){

        @Override
        public boolean isTarget() {
            return false;
        }

        @Override
        public boolean followsPresent() {
            return false;
        }

        @Override
        public boolean canEdit(DebuggerCoordinates coordinates) {
            return coordinates.getTrace() != null;
        }

        @Override
        public boolean isVariableEditable(DebuggerCoordinates coordinates, Address address, int length) {
            if (coordinates.getThread() == null) {
                return false;
            }
            if (!RW_TRACE.isVariableEditable(coordinates, address, length)) {
                return false;
            }
            Register ctxReg = coordinates.getTrace().getBaseLanguage().getContextBaseRegister();
            if (ctxReg == Register.NO_CONTEXT) {
                return true;
            }
            AddressRange ctxRange = TraceRegisterUtils.rangeForRegister((Register)ctxReg);
            return !ctxRange.contains(address);
        }

        @Override
        public CompletableFuture<Void> setVariable(PluginTool tool, DebuggerCoordinates coordinates, Address address, byte[] data) {
            if (!(coordinates.getView() instanceof TraceVariableSnapProgramView)) {
                throw new IllegalArgumentException("Cannot emulate using a Fixed Program View");
            }
            TraceThread thread = coordinates.getThread();
            if (thread == null) {
                throw new IllegalArgumentException("Emulator edits require a thread.");
            }
            Language language = coordinates.getPlatform().getLanguage();
            TraceSchedule time = coordinates.getTime().patched(thread, language, PatchStep.generateSleigh((Language)language, (Address)address, (byte[])data));
            DebuggerCoordinates withTime = coordinates.time(time);
            DebuggerTraceManagerService traceManager = Objects.requireNonNull((DebuggerTraceManagerService)tool.getService(DebuggerTraceManagerService.class), "No trace manager service");
            Long found = traceManager.findSnapshot(withTime);
            if (found == null) {
                DebuggerEmulationService emulationService = Objects.requireNonNull((DebuggerEmulationService)tool.getService(DebuggerEmulationService.class), "No emulation service");
                try {
                    emulationService.emulate(coordinates.getPlatform(), time, TaskMonitor.DUMMY);
                }
                catch (CancelledException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return traceManager.activateAndNotify(withTime, DebuggerTraceManagerService.ActivationCause.EMU_STATE_EDIT);
        }

        @Override
        public boolean useEmulatedBreakpoints() {
            return true;
        }
    };

    public static final List<ControlMode> ALL;
    public static final ControlMode DEFAULT;
    public final String name;
    public final Icon icon;

    private ControlMode(String name, Icon icon) {
        this.name = name;
        this.icon = icon;
    }

    public abstract boolean followsPresent();

    public DebuggerCoordinates validateCoordinates(PluginTool tool, DebuggerCoordinates coordinates, DebuggerTraceManagerService.ActivationCause cause) {
        TraceSchedule.ScheduleForm form;
        if (!this.followsPresent() || cause != DebuggerTraceManagerService.ActivationCause.USER) {
            return coordinates;
        }
        Target target = coordinates.getTarget();
        if (target == null) {
            return coordinates;
        }
        TraceSchedule.ScheduleForm scheduleForm = form = coordinates.getObject() == null ? null : target.getSupportedTimeForm(coordinates.getObject(), coordinates.getSnap());
        if (form == null) {
            if (coordinates.getTime().isSnapOnly() && coordinates.getSnap() == target.getSnap()) {
                return coordinates;
            }
            tool.setStatusInfo("Cannot navigate time in %s mode. Switch to Trace or Emulate mode first.".formatted(this.name), true);
            return null;
        }
        TraceSchedule norm = form.validate(coordinates.getTrace(), coordinates.getTime());
        if (norm != null) {
            return coordinates.time(norm);
        }
        String errMsg = switch (form) {
            default -> throw new MatchException(null, null);
            case TraceSchedule.ScheduleForm.SNAP_ONLY -> "Target can only navigate to snapshots. Switch to Emulate mode first.";
            case TraceSchedule.ScheduleForm.SNAP_EVT_STEPS -> "Target can only replay steps on the event thread. Switch to Emulate mode first.";
            case TraceSchedule.ScheduleForm.SNAP_ANY_STEPS -> "Target cannot perform p-code steps. Switch to Emulate mode first.";
            case TraceSchedule.ScheduleForm.SNAP_ANY_STEPS_OPS -> throw new AssertionError();
        };
        tool.setStatusInfo(errMsg, true);
        return null;
    }

    protected TracePlatform platformFor(DebuggerCoordinates coordinates, Address address) {
        if (address.isRegisterAddress()) {
            return coordinates.getPlatform();
        }
        return coordinates.getTrace().getPlatformManager().getHostPlatform();
    }

    public abstract boolean canEdit(DebuggerCoordinates var1);

    public abstract boolean isVariableEditable(DebuggerCoordinates var1, Address var2, int var3);

    public abstract CompletableFuture<Void> setVariable(PluginTool var1, DebuggerCoordinates var2, Address var3, byte[] var4);

    public abstract boolean useEmulatedBreakpoints();

    public boolean isSelectable(DebuggerCoordinates coordinates) {
        return true;
    }

    public ControlMode getAlternative(DebuggerCoordinates coordinates) {
        throw new AssertionError((Object)"INTERNAL: Non-selectable mode must provide alternative");
    }

    public ControlMode modeOnChange(DebuggerCoordinates coordinates) {
        if (this.isSelectable(coordinates)) {
            return this;
        }
        return this.getAlternative(coordinates);
    }

    public abstract boolean isTarget();

    static {
        ALL = List.of(ControlMode.values());
        DEFAULT = RO_TARGET;
    }
}

