/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh;

import ghidra.app.plugin.assembler.AssemblyError;
import ghidra.app.plugin.assembler.AssemblySelectionError;
import ghidra.app.plugin.assembler.AssemblySelector;
import ghidra.app.plugin.assembler.AssemblySemanticException;
import ghidra.app.plugin.assembler.AssemblySyntaxException;
import ghidra.app.plugin.assembler.GenericAssembler;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseAcceptResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseErrorResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParseResult;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParser;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyContextGraph;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolutionResults;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericSymbols;
import ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.disassemble.DisassemblerMessageListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ProgramEvent;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;

public abstract class AbstractSleighAssembler<RP extends AssemblyResolvedPatterns>
implements GenericAssembler<RP> {
    protected static final DbgTimer dbg = DbgTimer.INACTIVE;
    protected final Object lock = new Object();
    protected final SleighLanguage lang;
    protected final Program program;
    protected final Listing listing;
    protected final Memory memory;
    protected final AbstractAssemblyResolutionFactory<RP, ?> factory;
    protected final AssemblySelector selector;
    protected final AssemblyParser parser;
    protected final AssemblyDefaultContext defaultContext;
    protected final AssemblyContextGraph ctxGraph;
    protected AssemblyNumericSymbols symbols;

    protected AbstractSleighAssembler(AbstractAssemblyResolutionFactory<RP, ?> factory, AssemblySelector selector, Program program, AssemblyParser parser, AssemblyDefaultContext defaultContext, AssemblyContextGraph ctxGraph) {
        this.factory = factory;
        this.selector = selector;
        this.program = program;
        this.parser = parser;
        this.defaultContext = defaultContext;
        this.ctxGraph = ctxGraph;
        this.lang = (SleighLanguage)program.getLanguage();
        this.listing = program.getListing();
        this.memory = program.getMemory();
    }

    protected AbstractSleighAssembler(AbstractAssemblyResolutionFactory<RP, ?> factory, AssemblySelector selector, SleighLanguage lang, AssemblyParser parser, AssemblyDefaultContext defaultContext, AssemblyContextGraph ctxGraph) {
        this.factory = factory;
        this.selector = selector;
        this.lang = lang;
        this.parser = parser;
        this.defaultContext = defaultContext;
        this.ctxGraph = ctxGraph;
        this.program = null;
        this.listing = null;
        this.memory = null;
    }

    protected abstract AbstractAssemblyTreeResolver<RP> newResolver(Address var1, AssemblyParseBranch var2, AssemblyPatternBlock var3);

    @Override
    public SleighLanguage getLanguage() {
        return this.lang;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public Instruction patchProgram(AssemblyResolvedPatterns res, Address at) throws MemoryAccessException {
        if (!res.getInstruction().isFullMask()) {
            throw new AssemblySelectionError("Selected instruction must have a full mask.");
        }
        return this.patchProgram(res.getInstruction().getVals(), at).next();
    }

    @Override
    public InstructionIterator patchProgram(byte[] insbytes, Address at) throws MemoryAccessException {
        if (insbytes.length == 0) {
            return this.listing.getInstructions(new AddressSet(), true);
        }
        Address end = at.add(insbytes.length - 1);
        this.listing.clearCodeUnits(at, end, false);
        this.memory.setBytes(at, insbytes);
        AddressSet set = new AddressSet(at, end);
        Disassembler dis = Disassembler.getDisassembler(this.program, TaskMonitor.DUMMY, DisassemblerMessageListener.IGNORE);
        dis.disassemble(at, set);
        return this.listing.getInstructions(set, true);
    }

    @Override
    public InstructionIterator assemble(Address at, String ... assembly) throws AssemblySyntaxException, AssemblySemanticException, MemoryAccessException, AddressOverflowException {
        Address start = at;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        for (String part : assembly) {
            for (String line : part.split("\n")) {
                RegisterValue rv = this.program.getProgramContext().getDisassemblyContext(at);
                dbg.println(rv);
                AssemblyPatternBlock ctx = AssemblyPatternBlock.fromRegisterValue(rv);
                ctx = ctx.fillMask();
                byte[] insbytes = this.assembleLine(at, line, ctx);
                if (insbytes == null) {
                    return null;
                }
                try {
                    buf.write(insbytes);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                at = at.addNoWrap(insbytes.length);
            }
        }
        return this.patchProgram(buf.toByteArray(), start);
    }

    @Override
    public byte[] assembleLine(Address at, String line) throws AssemblySyntaxException, AssemblySemanticException {
        AssemblyPatternBlock ctx = this.defaultContext.getDefaultAt(at);
        ctx = ctx.fillMask();
        return this.assembleLine(at, line, ctx);
    }

    @Override
    public Collection<AssemblyParseResult> parseLine(String line) {
        return this.parser.parse(line, this.getNumericSymbols());
    }

    @Override
    public AssemblyResolutionResults resolveTree(AssemblyParseResult parse, Address at, AssemblyPatternBlock ctx) {
        if (parse.isError()) {
            AssemblyResolutionResults results = this.factory.newAssemblyResolutionResults();
            AssemblyParseErrorResult err = (AssemblyParseErrorResult)parse;
            results.add(((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)this.factory.newErrorBuilder().error(err.describeError()).description("Parsing")).build());
            return results;
        }
        AssemblyParseAcceptResult acc = (AssemblyParseAcceptResult)parse;
        AbstractAssemblyTreeResolver<RP> tr = this.newResolver(at, acc.getTree(), ctx);
        return tr.resolve();
    }

    @Override
    public AssemblyResolutionResults resolveTree(AssemblyParseResult parse, Address at) {
        AssemblyPatternBlock ctx = this.getContextAt(at);
        return this.resolveTree(parse, at, ctx);
    }

    @Override
    public AssemblyResolutionResults resolveLine(Address at, String line) throws AssemblySyntaxException {
        return this.resolveLine(at, line, this.getContextAt(at).fillMask());
    }

    @Override
    public AssemblyResolutionResults resolveLine(Address at, String line, AssemblyPatternBlock ctx) throws AssemblySyntaxException {
        if (!ctx.isFullMask()) {
            throw new AssemblyError("Context must be fully-specified (full length, no shift, no unknowns)");
        }
        if (this.lang.getContextBaseRegister() != Register.NO_CONTEXT && ctx.length() < this.lang.getContextBaseRegister().getMinimumByteSize()) {
            throw new AssemblyError("Context must be fully-specified (full length, no shift, no unknowns)");
        }
        Collection<AssemblyParseResult> parse = this.parseLine(line);
        if (!(parse = this.selector.filterParse(parse)).iterator().hasNext()) {
            throw new AssemblySelectionError("Must select at least one parse result. Report errors via AssemblySyntaxError");
        }
        AssemblyResolutionResults results = this.factory.newAssemblyResolutionResults();
        for (AssemblyParseResult p : parse) {
            results.absorb(this.resolveTree(p, at, ctx));
        }
        return results;
    }

    @Override
    public byte[] assembleLine(Address at, String line, AssemblyPatternBlock ctx) throws AssemblySemanticException, AssemblySyntaxException {
        AssemblyResolutionResults results = this.resolveLine(at, line, ctx);
        AssemblySelector.Selection sel = this.selector.select(results, ctx);
        if (sel == null) {
            throw new AssemblySelectionError("Must select exactly one instruction. Report errors via AssemblySemanticError");
        }
        if (!sel.ins().isFullMask()) {
            throw new AssemblySelectionError("Selected instruction must have a full mask.");
        }
        if (sel.ctx().combine(ctx) == null) {
            throw new AssemblySelectionError("Selected instruction must have compatible context");
        }
        return sel.ins().getVals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AssemblyNumericSymbols getNumericSymbols() {
        Object object = this.lock;
        synchronized (object) {
            if (this.symbols != null) {
                return this.symbols;
            }
            this.symbols = this.program == null ? AssemblyNumericSymbols.fromLanguage(this.lang) : AssemblyNumericSymbols.fromProgram(this.program);
            return this.symbols;
        }
    }

    @Override
    public AssemblyPatternBlock getContextAt(Address addr) {
        if (this.program != null) {
            RegisterValue rv = this.program.getProgramContext().getDisassemblyContext(addr);
            return AssemblyPatternBlock.fromRegisterValue(rv);
        }
        return this.defaultContext.getDefaultAt(addr);
    }

    protected class ListenerForSymbolsRefresh
    implements DomainObjectListener {
        protected ListenerForSymbolsRefresh() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            if (ev.contains(new EventType[]{ProgramEvent.SYMBOL_ADDED, ProgramEvent.SYMBOL_ADDRESS_CHANGED, ProgramEvent.SYMBOL_REMOVED, ProgramEvent.SYMBOL_RENAMED})) {
                Object object = AbstractSleighAssembler.this.lock;
                synchronized (object) {
                    AbstractSleighAssembler.this.symbols = null;
                }
            }
        }
    }
}

