/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.Table;
import ghidra.framework.data.DomainObjectDBChangeSet;
import ghidra.program.database.MyChangeDiff;
import ghidra.program.model.listing.DataTypeArchiveChangeSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

class DataTypeArchiveDBChangeSet
implements DataTypeArchiveChangeSet,
DomainObjectDBChangeSet {
    private static final Schema STORED_ID_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE}, new String[]{"value"});
    private static final String DATATYPE_ADDITIONS = "DataType Additions";
    private static final String DATATYPE_CHANGES = "DataType Changes";
    private static final String CATEGORY_ADDITIONS = "Category Additions";
    private static final String CATEGORY_CHANGES = "Category Changes";
    private static final String SOURCE_ARCHIVE_ADDITIONS = "Source Archive Additions";
    private static final String SOURCE_ARCHIVE_CHANGES = "Source Archive Changes";
    private HashSet<Long> changedDataTypeIds;
    private HashSet<Long> changedCategoryIds;
    private HashSet<Long> changedSourceArchiveIds;
    private HashSet<Long> addedDataTypeIds;
    private HashSet<Long> addedCategoryIds;
    private HashSet<Long> addedSourceArchiveIds;
    private HashSet<Long> tmpChangedDataTypeIds;
    private HashSet<Long> tmpChangedCategoryIds;
    private HashSet<Long> tmpChangedSourceArchiveIds;
    private HashSet<Long> tmpAddedDataTypeIds;
    private HashSet<Long> tmpAddedCategoryIds;
    private HashSet<Long> tmpAddedSourceArchiveIds;
    private LinkedList<MyChangeDiff> undoList = new LinkedList();
    private LinkedList<MyChangeDiff> redoList = new LinkedList();
    private boolean inTransaction;
    private int numUndos = 4;

    public DataTypeArchiveDBChangeSet(int numUndos) {
        this.numUndos = numUndos;
        this.changedDataTypeIds = new HashSet();
        this.changedCategoryIds = new HashSet();
        this.changedSourceArchiveIds = new HashSet();
        this.addedDataTypeIds = new HashSet();
        this.addedCategoryIds = new HashSet();
        this.addedSourceArchiveIds = new HashSet();
    }

    @Override
    public synchronized void dataTypeChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedDataTypeIds.contains(lid) && !this.tmpAddedDataTypeIds.contains(lid)) {
            this.tmpChangedDataTypeIds.add(lid);
        }
    }

    @Override
    public synchronized void dataTypeAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedDataTypeIds.add(id);
    }

    @Override
    public synchronized long[] getDataTypeChanges() {
        return this.getLongs(this.changedDataTypeIds);
    }

    @Override
    public synchronized long[] getDataTypeAdditions() {
        return this.getLongs(this.addedDataTypeIds);
    }

    @Override
    public synchronized void categoryChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedCategoryIds.contains(lid) && !this.tmpAddedCategoryIds.contains(lid)) {
            this.tmpChangedCategoryIds.add(lid);
        }
    }

    @Override
    public synchronized void categoryAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedCategoryIds.add(id);
    }

    @Override
    public synchronized long[] getCategoryChanges() {
        return this.getLongs(this.changedCategoryIds);
    }

    @Override
    public synchronized long[] getCategoryAdditions() {
        return this.getLongs(this.addedCategoryIds);
    }

    @Override
    public void sourceArchiveAdded(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        this.tmpAddedSourceArchiveIds.add(id);
    }

    @Override
    public void sourceArchiveChanged(long id) {
        if (!this.inTransaction) {
            throw new IllegalStateException("Not in a transaction");
        }
        Long lid = id;
        if (!this.addedSourceArchiveIds.contains(lid) && !this.tmpAddedSourceArchiveIds.contains(lid)) {
            this.tmpChangedSourceArchiveIds.add(lid);
        }
    }

    @Override
    public long[] getSourceArchiveAdditions() {
        return this.getLongs(this.addedSourceArchiveIds);
    }

    @Override
    public long[] getSourceArchiveChanges() {
        return this.getLongs(this.changedSourceArchiveIds);
    }

    public synchronized void clearUndo(boolean isCheckedOut) {
        if (this.inTransaction) {
            throw new IllegalStateException("Cannot clear in a transaction");
        }
        if (!isCheckedOut) {
            this.changedCategoryIds.clear();
            this.changedDataTypeIds.clear();
            this.changedSourceArchiveIds.clear();
            this.addedCategoryIds.clear();
            this.addedDataTypeIds.clear();
            this.addedSourceArchiveIds.clear();
        }
        this.clearUndo();
    }

    public synchronized void startTransaction() {
        this.redoList.clear();
        this.inTransaction = true;
        this.tmpChangedDataTypeIds = new HashSet();
        this.tmpChangedCategoryIds = new HashSet();
        this.tmpChangedSourceArchiveIds = new HashSet();
        this.tmpAddedDataTypeIds = new HashSet();
        this.tmpAddedCategoryIds = new HashSet();
        this.tmpAddedSourceArchiveIds = new HashSet();
    }

    public synchronized void endTransaction(boolean commit) {
        if (!this.inTransaction) {
            return;
        }
        this.inTransaction = false;
        if (commit) {
            this.tmpChangedDataTypeIds.removeAll(this.changedDataTypeIds);
            this.tmpChangedCategoryIds.removeAll(this.changedCategoryIds);
            this.tmpChangedSourceArchiveIds.removeAll(this.changedSourceArchiveIds);
            this.changedDataTypeIds.addAll(this.tmpChangedDataTypeIds);
            this.changedCategoryIds.addAll(this.tmpChangedCategoryIds);
            this.changedSourceArchiveIds.addAll(this.tmpChangedSourceArchiveIds);
            this.addedDataTypeIds.addAll(this.tmpAddedDataTypeIds);
            this.addedCategoryIds.addAll(this.tmpAddedCategoryIds);
            this.addedSourceArchiveIds.addAll(this.tmpAddedSourceArchiveIds);
            this.undoList.addLast(new MyChangeDiff(this.tmpChangedDataTypeIds, this.tmpChangedCategoryIds, this.tmpChangedSourceArchiveIds, this.tmpAddedDataTypeIds, this.tmpAddedCategoryIds, this.tmpAddedSourceArchiveIds));
            if (this.undoList.size() > this.numUndos) {
                this.undoList.removeFirst();
            }
        }
        this.tmpChangedDataTypeIds = null;
        this.tmpChangedCategoryIds = null;
        this.tmpChangedSourceArchiveIds = null;
        this.tmpAddedDataTypeIds = null;
        this.tmpAddedCategoryIds = null;
        this.tmpAddedSourceArchiveIds = null;
    }

    public synchronized void undo() {
        MyChangeDiff diff = this.undoList.removeLast();
        this.changedDataTypeIds.removeAll(diff.changedDts);
        this.changedCategoryIds.removeAll(diff.changedCats);
        this.changedSourceArchiveIds.removeAll(diff.changedArchives);
        this.addedDataTypeIds.removeAll(diff.addedDts);
        this.addedCategoryIds.removeAll(diff.addedCats);
        this.addedSourceArchiveIds.removeAll(diff.addedArchives);
        this.redoList.addLast(diff);
    }

    public synchronized void redo() {
        MyChangeDiff diff = this.redoList.removeLast();
        this.changedDataTypeIds.addAll(diff.changedDts);
        this.changedCategoryIds.addAll(diff.changedCats);
        this.changedSourceArchiveIds.addAll(diff.changedArchives);
        this.addedDataTypeIds.addAll(diff.addedDts);
        this.addedCategoryIds.addAll(diff.addedCats);
        this.addedSourceArchiveIds.addAll(diff.addedArchives);
        this.undoList.addLast(diff);
    }

    public synchronized void clearUndo() {
        this.undoList.clear();
        this.redoList.clear();
    }

    public synchronized void setMaxUndos(int numUndos) {
        this.numUndos = numUndos;
    }

    public synchronized void read(DBHandle dbh) throws IOException {
        this.startTransaction();
        boolean success = false;
        try {
            this.readIdRecords(dbh, DATATYPE_ADDITIONS, this.tmpAddedDataTypeIds);
            this.readIdRecords(dbh, DATATYPE_CHANGES, this.tmpChangedDataTypeIds);
            this.readIdRecords(dbh, CATEGORY_ADDITIONS, this.tmpAddedCategoryIds);
            this.readIdRecords(dbh, CATEGORY_CHANGES, this.tmpChangedCategoryIds);
            this.readIdRecords(dbh, SOURCE_ARCHIVE_ADDITIONS, this.tmpAddedSourceArchiveIds);
            this.readIdRecords(dbh, SOURCE_ARCHIVE_CHANGES, this.tmpChangedSourceArchiveIds);
            success = true;
        }
        finally {
            this.endTransaction(success);
            this.clearUndo();
        }
    }

    private void readIdRecords(DBHandle dbh, String tableName, Set<Long> ids) throws IOException {
        Table table = dbh.getTable(tableName);
        if (table != null) {
            if (table.getSchema().getVersion() != 0) {
                throw new IOException("Change data produced with newer version of Ghidra");
            }
            for (DBRecord rec : table) {
                ids.add(rec.getLongValue(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(DBHandle dbh, boolean isRecoverySave) throws IOException {
        long txId = dbh.startTransaction();
        boolean success = false;
        try {
            this.writeIdRecords(dbh, DATATYPE_ADDITIONS, this.addedDataTypeIds);
            this.writeIdRecords(dbh, DATATYPE_CHANGES, this.changedDataTypeIds);
            this.writeIdRecords(dbh, CATEGORY_ADDITIONS, this.addedCategoryIds);
            this.writeIdRecords(dbh, CATEGORY_CHANGES, this.changedCategoryIds);
            this.writeIdRecords(dbh, SOURCE_ARCHIVE_ADDITIONS, this.addedSourceArchiveIds);
            this.writeIdRecords(dbh, SOURCE_ARCHIVE_CHANGES, this.changedSourceArchiveIds);
            success = true;
        }
        finally {
            dbh.endTransaction(txId, success);
        }
    }

    private void writeIdRecords(DBHandle dbh, String tableName, Set<Long> ids) throws IOException {
        if (ids.size() > 0) {
            Table table = dbh.createTable(tableName, STORED_ID_SCHEMA);
            DBRecord rec = STORED_ID_SCHEMA.createRecord(0L);
            int key = 1;
            for (long id : ids) {
                rec.setKey((long)key++);
                rec.setLongValue(0, id);
                table.putRecord(rec);
            }
        }
    }

    private long[] getLongs(HashSet<Long> set) {
        long[] result = new long[set.size()];
        Iterator<Long> it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i++] = it.next();
        }
        return result;
    }

    @Override
    public boolean hasChanges() {
        return !this.changedDataTypeIds.isEmpty() || !this.changedCategoryIds.isEmpty() || !this.changedSourceArchiveIds.isEmpty() || !this.addedDataTypeIds.isEmpty() || !this.addedCategoryIds.isEmpty() || !this.addedSourceArchiveIds.isEmpty();
    }
}

