/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.program.database.data.SettingDB;
import ghidra.util.datastruct.FixedSizeHashMap;
import java.util.LinkedHashMap;
import java.util.Objects;

class SettingsCache<K> {
    private LinkedHashMap<IdNamePair, SettingDB> map;

    SettingsCache(int size) {
        this.map = new FixedSizeHashMap(size, size);
    }

    public void remove(K id, String name) {
        IdNamePair key = new IdNamePair(id, name);
        this.map.remove(key);
    }

    void clear() {
        this.map.clear();
    }

    SettingDB get(K id, String name) {
        IdNamePair key = new IdNamePair(id, name);
        return this.map.get(key);
    }

    void put(K id, String name, SettingDB setting) {
        IdNamePair key = new IdNamePair(id, name);
        this.map.put(key, setting);
    }

    private static class IdNamePair {
        Object id;
        String name;

        IdNamePair(Object id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IdNamePair)) {
                return false;
            }
            IdNamePair other = (IdNamePair)obj;
            return other.id.equals(this.id) && other.name.equals(this.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }
    }
}

