/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.BlockMap;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeBlock;
import java.io.IOException;

public class BlockIfGoto
extends BlockGraph {
    private PcodeBlock gototarget;
    private int gototype;

    public BlockIfGoto() {
        this.blocktype = 10;
        this.gototarget = null;
        this.gototype = 1;
    }

    public void setGotoTarget(PcodeBlock bl) {
        this.gototarget = bl;
    }

    public PcodeBlock getGotoTarget() {
        return this.gototarget;
    }

    public int getGotoType() {
        return this.gototype;
    }

    @Override
    protected void encodeBody(Encoder encoder) throws IOException {
        super.encodeBody(encoder);
        PcodeBlock leaf = this.gototarget.getFrontLeaf();
        int depth = this.gototarget.calcDepth(leaf);
        encoder.openElement(ElementId.ELEM_TARGET);
        encoder.writeSignedInteger(AttributeId.ATTRIB_INDEX, leaf.getIndex());
        encoder.writeSignedInteger(AttributeId.ATTRIB_DEPTH, depth);
        encoder.writeSignedInteger(AttributeId.ATTRIB_TYPE, this.gototype);
        encoder.closeElement(ElementId.ELEM_TARGET);
    }

    @Override
    protected void decodeBody(Decoder decoder, BlockMap resolver) throws DecoderException {
        super.decodeBody(decoder, resolver);
        int el = decoder.openElement(ElementId.ELEM_TARGET);
        int target = (int)decoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
        int depth = (int)decoder.readSignedInteger(AttributeId.ATTRIB_DEPTH);
        this.gototype = (int)decoder.readUnsignedInteger(AttributeId.ATTRIB_TYPE);
        decoder.closeElement(el);
        this.gototarget = null;
        resolver.addGotoRef(this, target, depth);
    }
}

