/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.CreateEHESTypeListBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.CreateEHIPToStateMapBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.CreateEHTryBlockMapBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.CreateEHUnwindMapBackgroundCmd;
import ghidra.app.cmd.data.exceptionhandling.EHESTypeListModel;
import ghidra.app.cmd.data.exceptionhandling.EHFunctionInfoModel;
import ghidra.app.cmd.data.exceptionhandling.EHIPToStateModel;
import ghidra.app.cmd.data.exceptionhandling.EHTryBlockModel;
import ghidra.app.cmd.data.exceptionhandling.EHUnwindModel;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.lang.UndefinedValueException;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class CreateEHFuncInfoBackgroundCmd
extends AbstractCreateDataBackgroundCmd<EHFunctionInfoModel> {
    public CreateEHFuncInfoBackgroundCmd(Address address) {
        super("FuncInfo", address, 1);
    }

    public CreateEHFuncInfoBackgroundCmd(Address address, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("FuncInfo", address, 1, validationOptions, applyOptions);
    }

    CreateEHFuncInfoBackgroundCmd(EHFunctionInfoModel funcInfoModel, DataApplyOptions applyOptions) {
        super(funcInfoModel, applyOptions);
    }

    @Override
    protected EHFunctionInfoModel createModel(Program program) {
        if (this.model == null) {
            this.model = new EHFunctionInfoModel(program, this.getDataAddress(), this.validationOptions);
        }
        return (EHFunctionInfoModel)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        boolean unwindMapSuccess = this.createUnwindMapEntries();
        boolean tryBlockMapSuccess = this.createTryBlockMapEntries();
        boolean ipToStateMapSuccess = this.createIPToStateMapEntries();
        boolean typeListSuccess = this.createESTypeListEntries();
        return unwindMapSuccess && tryBlockMapSuccess && ipToStateMapSuccess && typeListSuccess;
    }

    private boolean createUnwindMapEntries() throws CancelledException {
        EHUnwindModel unwindModel;
        int unwindCount;
        Address unwindMapAddress;
        Address compAddress;
        this.monitor.setMessage("Creating UnwindMap");
        this.monitor.checkCancelled();
        try {
            compAddress = ((EHFunctionInfoModel)this.model).getComponentAddressOfUnwindMapAddress();
            unwindMapAddress = ((EHFunctionInfoModel)this.model).getUnwindMapAddress();
            unwindCount = ((EHFunctionInfoModel)this.model).getUnwindCount();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        if (unwindMapAddress == null || unwindCount == 0) {
            return true;
        }
        try {
            unwindModel = ((EHFunctionInfoModel)this.model).getUnwindModel();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        try {
            unwindModel.validate();
        }
        catch (InvalidDataTypeException e1) {
            this.handleErrorMessage(((EHFunctionInfoModel)this.model).getProgram(), unwindModel.getName(), unwindMapAddress, compAddress, (Exception)((Object)e1));
            return false;
        }
        CreateEHUnwindMapBackgroundCmd cmd = new CreateEHUnwindMapBackgroundCmd(unwindModel, this.applyOptions);
        return cmd.applyTo(((EHFunctionInfoModel)this.model).getProgram(), this.monitor);
    }

    private boolean createTryBlockMapEntries() throws CancelledException {
        EHTryBlockModel tryBlockModel;
        int tryBlockCount;
        Address tryBlockMapAddress;
        Address compAddress;
        this.monitor.setMessage("Creating TryBlockMap");
        this.monitor.checkCancelled();
        try {
            compAddress = ((EHFunctionInfoModel)this.model).getComponentAddressOfTryBlockMapAddress();
            tryBlockMapAddress = ((EHFunctionInfoModel)this.model).getTryBlockMapAddress();
            tryBlockCount = ((EHFunctionInfoModel)this.model).getTryBlockCount();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        if (tryBlockMapAddress == null || tryBlockCount == 0) {
            return true;
        }
        try {
            tryBlockModel = ((EHFunctionInfoModel)this.model).getTryBlockModel();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        try {
            tryBlockModel.validate();
        }
        catch (InvalidDataTypeException e1) {
            this.handleErrorMessage(((EHFunctionInfoModel)this.model).getProgram(), tryBlockModel.getName(), tryBlockMapAddress, compAddress, (Exception)((Object)e1));
            return false;
        }
        CreateEHTryBlockMapBackgroundCmd cmd = new CreateEHTryBlockMapBackgroundCmd(tryBlockModel, this.applyOptions);
        return cmd.applyTo(((EHFunctionInfoModel)this.model).getProgram(), this.monitor);
    }

    private boolean createIPToStateMapEntries() throws CancelledException {
        EHIPToStateModel ipToStateModel;
        int ipToStateCount;
        Address ipToStateMapAddress;
        Address compAddress;
        this.monitor.setMessage("Creating IPToStateMap");
        this.monitor.checkCancelled();
        try {
            compAddress = ((EHFunctionInfoModel)this.model).getComponentAddressOfIPToStateMapAddress();
            ipToStateMapAddress = ((EHFunctionInfoModel)this.model).getIPToStateMapAddress();
            ipToStateCount = ((EHFunctionInfoModel)this.model).getIPToStateCount();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        if (ipToStateMapAddress == null || ipToStateCount == 0) {
            return true;
        }
        try {
            ipToStateModel = ((EHFunctionInfoModel)this.model).getIPToStateModel();
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        try {
            ipToStateModel.validate();
        }
        catch (InvalidDataTypeException e1) {
            this.handleErrorMessage(((EHFunctionInfoModel)this.model).getProgram(), ipToStateModel.getName(), ipToStateMapAddress, compAddress, (Exception)((Object)e1));
            return false;
        }
        CreateEHIPToStateMapBackgroundCmd cmd = new CreateEHIPToStateMapBackgroundCmd(ipToStateModel, this.applyOptions);
        return cmd.applyTo(((EHFunctionInfoModel)this.model).getProgram(), this.monitor);
    }

    private boolean createESTypeListEntries() throws CancelledException {
        EHESTypeListModel esTypeListModel;
        Address esTypeListAddress;
        Address compAddress;
        this.monitor.setMessage("Creating ESTypeList");
        this.monitor.checkCancelled();
        try {
            compAddress = ((EHFunctionInfoModel)this.model).getComponentAddressOfESTypeListAddress();
            esTypeListAddress = ((EHFunctionInfoModel)this.model).getESTypeListAddress();
            esTypeListModel = ((EHFunctionInfoModel)this.model).getESTypeListModel();
        }
        catch (UndefinedValueException e) {
            return true;
        }
        catch (InvalidDataTypeException e) {
            throw new AssertException((Throwable)e);
        }
        if (esTypeListAddress == null) {
            return true;
        }
        try {
            esTypeListModel.validate();
        }
        catch (InvalidDataTypeException e1) {
            this.handleErrorMessage(((EHFunctionInfoModel)this.model).getProgram(), esTypeListModel.getName(), esTypeListAddress, compAddress, (Exception)((Object)e1));
            return false;
        }
        CreateEHESTypeListBackgroundCmd cmd = new CreateEHESTypeListBackgroundCmd(esTypeListModel, this.applyOptions);
        return cmd.applyTo(((EHFunctionInfoModel)this.model).getProgram(), this.monitor);
    }

    @Override
    protected boolean createMarkup() throws CancelledException {
        return true;
    }
}

