/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.location;

import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompilerLocation;
import ghidra.app.decompiler.DecompilerLocationInfo;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionNameFieldLocation;
import java.util.Objects;

public class FunctionNameDecompilerLocation
extends FunctionNameFieldLocation
implements DecompilerLocation {
    private DecompilerLocationInfo info;

    public FunctionNameDecompilerLocation(Program program, Address address, String funcionName, DecompilerLocationInfo info) {
        super(program, address, funcionName);
        this.info = info;
    }

    public FunctionNameDecompilerLocation() {
        this.info = new DecompilerLocationInfo();
    }

    @Override
    public Address getFunctionEntryPoint() {
        return this.info.getFunctionEntryPoint();
    }

    @Override
    public DecompileResults getDecompile() {
        return this.info.getDecompile();
    }

    @Override
    public ClangToken getToken() {
        return this.info.getToken();
    }

    @Override
    public String getTokenName() {
        return this.info.getTokenName();
    }

    @Override
    public int getLineNumber() {
        return this.info.getLineNumber();
    }

    @Override
    public int getCharPos() {
        return this.info.getCharPos();
    }

    public void saveState(SaveState ss) {
        super.saveState(ss);
        this.info.saveState(ss);
    }

    public void restoreState(Program p, SaveState ss) {
        super.restoreState(p, ss);
        this.info.restoreState(p, ss);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = this.info.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FunctionNameDecompilerLocation other = (FunctionNameDecompilerLocation)obj;
        return Objects.equals(this.info, other.info);
    }
}

