/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import ghidra.trace.database.target.DBTraceObjectValueRStarTree;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.database.target.ValueTriple;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.database.spatial.DBTreeNodeRecord;
import java.io.IOException;
import java.util.Objects;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceObjectValueNode
extends DBTreeNodeRecord<ValueBox>
implements ValueBox {
    protected static final byte NODE_TYPE_MASK = 3;
    protected static final int NODE_TYPE_SHIFT = 6;
    protected static final byte NODE_TYPE_CLEAR = 63;
    protected static final byte CHILD_COUNT_MASK = 63;
    protected static final int CHILD_COUNT_SHIFT = 0;
    protected static final byte CHILD_COUNT_CLEAR = -64;
    static final String PARENT_COLUMN_NAME = "Parent";
    static final String MIN_PARENT_KEY_COLUMN_NAME = "MinParentKey";
    static final String MAX_PARENT_KEY_COLUMN_NAME = "MaxParentKey";
    static final String MIN_CHILD_KEY_COLUMN_NAME = "MinChildKey";
    static final String MAX_CHILD_KEY_COLUMN_NAME = "MaxChildKey";
    static final String MIN_ENTRY_KEY_COLUMN_NAME = "MinEntryKey";
    static final String MAX_ENTRY_KEY_COLUMN_NAME = "MaxEntryKey";
    static final String MIN_SNAP_COLUMN_NAME = "MinSnap";
    static final String MAX_SNAP_COLUMN_NAME = "MaxSnap";
    static final String MIN_SPACE_COLUMN_NAME = "MinSpace";
    static final String MAX_SPACE_COLUMN_NAME = "MaxSpace";
    static final String MIN_ADDRESS_COLUMN_NAME = "MinAddress";
    static final String MAX_ADDRESS_COLUMN_NAME = "MaxAddress";
    static final String TYPE_AND_CHILD_COUNT_COLUMN_NAME = "Type/ChildCount";
    static final String DATA_COUNT_COLUMN_NAME = "DataCount";
    @DBAnnotatedColumn(value="Parent")
    static DBObjectColumn PARENT_COLUMN;
    @DBAnnotatedColumn(value="MinParentKey")
    static DBObjectColumn MIN_PARENT_KEY_COLUMN;
    @DBAnnotatedColumn(value="MaxParentKey")
    static DBObjectColumn MAX_PARENT_KEY_COLUMN;
    @DBAnnotatedColumn(value="MinChildKey")
    static DBObjectColumn MIN_CHILD_KEY_COLUMN;
    @DBAnnotatedColumn(value="MaxChildKey")
    static DBObjectColumn MAX_CHILD_KEY_COLUMN;
    @DBAnnotatedColumn(value="MinEntryKey")
    static DBObjectColumn MIN_ENTRY_KEY_COLUMN;
    @DBAnnotatedColumn(value="MaxEntryKey")
    static DBObjectColumn MAX_ENTRY_KEY_COLUMN;
    @DBAnnotatedColumn(value="MinSnap")
    static DBObjectColumn MIN_SNAP_COLUMN;
    @DBAnnotatedColumn(value="MaxSnap")
    static DBObjectColumn MAX_SNAP_COLUMN;
    @DBAnnotatedColumn(value="MinSpace")
    static DBObjectColumn MIN_SPACE_COLUMN;
    @DBAnnotatedColumn(value="MaxSpace")
    static DBObjectColumn MAX_SPACE_COLUMN;
    @DBAnnotatedColumn(value="MinAddress")
    static DBObjectColumn MIN_ADDRESS_COLUMN;
    @DBAnnotatedColumn(value="MaxAddress")
    static DBObjectColumn MAX_ADDRESS_COLUMN;
    @DBAnnotatedColumn(value="Type/ChildCount")
    static DBObjectColumn TYPE_AND_CHILD_COUNT_COLUMN;
    @DBAnnotatedColumn(value="DataCount")
    static DBObjectColumn DATA_COUNT_COLUMN;
    @DBAnnotatedField(column="Parent", indexed=true)
    private long parentKey;
    @DBAnnotatedField(column="MinParentKey")
    private long minObjParentKey;
    @DBAnnotatedField(column="MaxParentKey")
    private long maxObjParentKey;
    @DBAnnotatedField(column="MinChildKey")
    private long minObjChildKey;
    @DBAnnotatedField(column="MaxChildKey")
    private long maxObjChildKey;
    @DBAnnotatedField(column="MinEntryKey")
    private String minEntryKey;
    @DBAnnotatedField(column="MaxEntryKey")
    private String maxEntryKey;
    @DBAnnotatedField(column="MinSnap")
    private long minSnap;
    @DBAnnotatedField(column="MaxSnap")
    private long maxSnap;
    @DBAnnotatedField(column="MinSpace")
    private int minSpace;
    @DBAnnotatedField(column="MaxSpace")
    private int maxSpace;
    @DBAnnotatedField(column="MinAddress")
    private long minAddress;
    @DBAnnotatedField(column="MaxAddress")
    private long maxAddress;
    @DBAnnotatedField(column="Type/ChildCount")
    private byte typeAndChildCount;
    @DBAnnotatedField(column="DataCount")
    private int dataCount;
    protected final DBTraceObjectValueRStarTree tree;
    private ValueTriple lCorner;
    private ValueTriple uCorner;

    public DBTraceObjectValueNode(DBTraceObjectValueRStarTree tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.tree = tree;
    }

    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.lCorner = new ValueTriple(this.minObjParentKey, this.minObjChildKey, this.minEntryKey, this.minSnap, new DBCachedObjectStoreFactory.RecAddress(this.minSpace, this.minAddress));
        this.uCorner = new ValueTriple(this.maxObjParentKey, this.maxObjChildKey, this.maxEntryKey, this.maxSnap, new DBCachedObjectStoreFactory.RecAddress(this.maxSpace, this.maxAddress));
    }

    public ValueTriple lCorner() {
        return Objects.requireNonNull(this.lCorner);
    }

    public ValueTriple uCorner() {
        return Objects.requireNonNull(this.uCorner);
    }

    protected DBTreeNodeRecord.NodeType getType() {
        return (DBTreeNodeRecord.NodeType)DBTreeNodeRecord.NodeType.VALUES.get(this.typeAndChildCount >> 6 & 3);
    }

    protected void setType(DBTreeNodeRecord.NodeType type) {
        this.typeAndChildCount = (byte)(this.typeAndChildCount & 0x3F | type.ordinal() << 6);
        this.update(TYPE_AND_CHILD_COUNT_COLUMN);
    }

    protected int getChildCount() {
        return this.typeAndChildCount >> 0 & 0x3F;
    }

    protected void setChildCount(int childCount) {
        assert ((childCount & 0x3F) == childCount);
        this.typeAndChildCount = (byte)(this.typeAndChildCount & 0xFFFFFFC0 | childCount << 0);
        this.update(TYPE_AND_CHILD_COUNT_COLUMN);
    }

    protected int getDataCount() {
        return this.dataCount;
    }

    protected void setDataCount(int dataCount) {
        this.dataCount = dataCount;
        this.update(DATA_COUNT_COLUMN);
    }

    public ValueBox getShape() {
        return this;
    }

    public void setShape(ValueBox shape) {
        this.minObjParentKey = ((ValueTriple)shape.lCorner()).parentKey();
        this.maxObjParentKey = ((ValueTriple)shape.uCorner()).parentKey();
        this.minObjChildKey = ((ValueTriple)shape.lCorner()).childKey();
        this.maxObjChildKey = ((ValueTriple)shape.uCorner()).childKey();
        this.minEntryKey = ((ValueTriple)shape.lCorner()).entryKey();
        this.maxEntryKey = ((ValueTriple)shape.uCorner()).entryKey();
        this.minSnap = ((ValueTriple)shape.lCorner()).snap();
        this.maxSnap = ((ValueTriple)shape.uCorner()).snap();
        this.minSpace = ((ValueTriple)shape.lCorner()).address().spaceId();
        this.maxSpace = ((ValueTriple)shape.uCorner()).address().spaceId();
        this.minAddress = ((ValueTriple)shape.lCorner()).address().offset();
        this.maxAddress = ((ValueTriple)shape.uCorner()).address().offset();
        this.update(new DBObjectColumn[]{MIN_PARENT_KEY_COLUMN, MAX_PARENT_KEY_COLUMN, MIN_CHILD_KEY_COLUMN, MAX_CHILD_KEY_COLUMN, MIN_ENTRY_KEY_COLUMN, MAX_ENTRY_KEY_COLUMN, MIN_SNAP_COLUMN, MAX_SNAP_COLUMN, MIN_SPACE_COLUMN, MAX_SPACE_COLUMN, MIN_ADDRESS_COLUMN, MAX_ADDRESS_COLUMN});
        this.lCorner = (ValueTriple)shape.lCorner();
        this.uCorner = (ValueTriple)shape.uCorner();
    }

    @Override
    public ValueBox getBounds() {
        return this;
    }

    public long getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(long parentKey) {
        this.parentKey = parentKey;
        this.update(PARENT_COLUMN);
    }
}

