/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target.path;

import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathPattern;
import ghidra.util.ReversedListIterator;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public interface PathFilter {
    public static final PathFilter NONE = new PathFilter(){

        @Override
        public PathFilter or(PathFilter that) {
            return that;
        }

        @Override
        public boolean matches(KeyPath path) {
            return false;
        }

        @Override
        public boolean successorCouldMatch(KeyPath path, boolean strict) {
            return false;
        }

        @Override
        public boolean ancestorMatches(KeyPath path, boolean strict) {
            return false;
        }

        @Override
        public boolean ancestorCouldMatchRight(KeyPath path, boolean strict) {
            return false;
        }

        @Override
        public Set<String> getNextKeys(KeyPath path) {
            return Set.of();
        }

        @Override
        public Set<String> getNextNames(KeyPath path) {
            return Set.of();
        }

        @Override
        public Set<String> getNextIndices(KeyPath path) {
            return Set.of();
        }

        @Override
        public Set<String> getPrevKeys(KeyPath path) {
            return Set.of();
        }

        @Override
        public KeyPath getSingletonPath() {
            return null;
        }

        @Override
        public PathPattern getSingletonPattern() {
            return null;
        }

        @Override
        public Set<PathPattern> getPatterns() {
            return Set.of();
        }

        @Override
        public PathFilter removeRight(int count) {
            return this;
        }

        @Override
        public PathFilter applyKeys(Align align, List<String> keys) {
            return this;
        }

        @Override
        public boolean isNone() {
            return true;
        }
    };

    public static boolean keyMatches(String pat, String key) {
        if (key.equals(pat)) {
            return true;
        }
        if ("[]".equals(pat)) {
            return KeyPath.isIndex(key);
        }
        if ("".equals(pat)) {
            return KeyPath.isName(key);
        }
        return false;
    }

    public static boolean anyMatches(Set<String> pats, String key) {
        return pats.stream().anyMatch(p -> PathFilter.keyMatches(p, key));
    }

    public static PathFilter pattern(String ... keyPatterns) {
        return new PathPattern(KeyPath.of(keyPatterns));
    }

    public static PathFilter pattern(KeyPath keyPatterns) {
        return new PathPattern(keyPatterns);
    }

    public static PathPattern parse(String pattern) {
        return new PathPattern(KeyPath.parse(pattern));
    }

    public PathFilter or(PathFilter var1);

    public boolean matches(KeyPath var1);

    public boolean successorCouldMatch(KeyPath var1, boolean var2);

    public boolean ancestorMatches(KeyPath var1, boolean var2);

    public boolean ancestorCouldMatchRight(KeyPath var1, boolean var2);

    public Set<String> getNextKeys(KeyPath var1);

    public Set<String> getNextNames(KeyPath var1);

    public Set<String> getNextIndices(KeyPath var1);

    public Set<String> getPrevKeys(KeyPath var1);

    public KeyPath getSingletonPath();

    public PathPattern getSingletonPattern();

    public Set<PathPattern> getPatterns();

    public PathFilter removeRight(int var1);

    public PathFilter applyKeys(Align var1, List<String> var2);

    default public PathFilter applyKeys(Align align, String ... keys) {
        return this.applyKeys(align, List.of(keys));
    }

    default public PathFilter applyKeys(String ... keys) {
        return this.applyKeys(Align.LEFT, keys);
    }

    default public PathFilter applyIntKeys(int radix, Align align, List<Integer> keys) {
        return this.applyKeys(align, keys.stream().map(k -> Integer.toString(k, radix)).collect(Collectors.toList()));
    }

    default public PathFilter applyIntKeys(int radix, Align align, int ... keys) {
        return this.applyKeys(align, IntStream.of(keys).mapToObj(k -> Integer.toString(k, radix)).collect(Collectors.toList()));
    }

    default public PathFilter applyIntKeys(int ... keys) {
        return this.applyIntKeys(10, Align.LEFT, keys);
    }

    public boolean isNone();

    public static enum Align {
        LEFT{

            @Override
            <T> ListIterator<T> iterator(List<T> list) {
                return list.listIterator();
            }
        }
        ,
        RIGHT{

            @Override
            <T> ListIterator<T> iterator(List<T> list) {
                return new ReversedListIterator(list.listIterator(list.size()));
            }
        };


        abstract <T> ListIterator<T> iterator(List<T> var1);

        <T> ListIterator<T> iterator(T[] arr) {
            return this.iterator(Arrays.asList(arr));
        }
    }
}

