/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericColor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import jspecview.api.PlatformDialog;
import jspecview.common.Annotation;
import jspecview.dialog.DialogManager;
import jspecview.dialog.JSVDialog;
import jspecview.java.AwtDialogManager;
import jspecview.java.DialogTableModel;

public class AwtDialog
extends JDialog
implements PlatformDialog {
    protected String optionKey;
    protected String registryKey;
    protected Map<String, Object> options;
    protected DialogManager manager;
    private Annotation.AType type;
    protected JPanel leftPanel;
    private JSplitPane mainSplitPane;
    private JPanel rightPanel;
    private JPanel thisPanel;
    private JTable dataTable;
    private int iRow;
    private boolean haveColors;
    protected boolean tableCellAlignLeft;
    private boolean haveTwoPanels = true;
    private Insets buttonInsets = new Insets(5, 5, 5, 5);
    private Insets panelInsets = new Insets(0, 0, 2, 2);
    private int defaultHeight = 350;
    protected int selectedRow = -1;
    private DialogTableModel tableModel;

    public AwtDialog(DialogManager dialogManager, JSVDialog jSVDialog, String string) {
        this.manager = dialogManager;
        this.registryKey = string;
        this.type = jSVDialog.getAType();
        this.optionKey = jSVDialog.optionKey;
        this.options = jSVDialog.options;
        if (this.options == null) {
            this.options = new Hashtable<String, Object>();
        }
        this.addFocusListener((AwtDialogManager)dialogManager);
    }

    @Override
    public void setFocus(boolean bl) {
        if (bl) {
            this.requestFocus();
            this.toFront();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    protected int getColumnCentering(int n) {
        return this.tableCellAlignLeft ? 2 : (n == 0 ? 0 : 4);
    }

    @Override
    public Object addButton(String string, String string2) {
        JButton jButton = new JButton();
        jButton.setPreferredSize(new Dimension(120, 25));
        jButton.setText(string2);
        jButton.setName(String.valueOf(this.registryKey) + "/" + string);
        jButton.addActionListener((AwtDialogManager)this.manager);
        this.thisPanel.add((Component)jButton, new GridBagConstraints(0, this.iRow++, 3, 1, 0.0, 0.0, 10, 0, this.buttonInsets, 0, 0));
        return jButton;
    }

    @Override
    public Object addCheckBox(String string, String string2, int n, boolean bl) {
        if (string == null) {
            this.iRow = 0;
            this.thisPanel = this.rightPanel;
            return null;
        }
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        jCheckBox.setText(string2);
        jCheckBox.setName(String.valueOf(this.registryKey) + "/" + string);
        jCheckBox.addActionListener((AwtDialogManager)this.manager);
        Insets insets = new Insets(0, 20 * n, 2, 2);
        this.thisPanel.add((Component)jCheckBox, new GridBagConstraints(0, this.iRow++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        return jCheckBox;
    }

    private void addPanelLine(String string, String string2, JComponent jComponent, String string3) {
        this.thisPanel.add((Component)new JLabel(string2 == null ? string : string2), new GridBagConstraints(0, this.iRow, 1, 1, 0.0, 0.0, 13, 0, this.panelInsets, 0, 0));
        if (string3 == null) {
            this.thisPanel.add((Component)jComponent, new GridBagConstraints(1, this.iRow, 2, 1, 0.0, 0.0, 17, 0, this.panelInsets, 0, 0));
        } else {
            this.thisPanel.add((Component)jComponent, new GridBagConstraints(1, this.iRow, 1, 1, 0.0, 0.0, 10, 0, this.panelInsets, 0, 0));
            this.thisPanel.add((Component)new JLabel(string3), new GridBagConstraints(2, this.iRow, 1, 1, 0.0, 0.0, 17, 0, this.panelInsets, 0, 0));
        }
        ++this.iRow;
    }

    @Override
    public Object addSelectOption(String string, String string2, String[] stringArray, int n, boolean bl) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(n);
        jComboBox.setName(String.valueOf(this.registryKey) + "/" + string);
        if (bl) {
            jComboBox.addActionListener((AwtDialogManager)this.manager);
            this.addPanelLine(string, string2, jComboBox, null);
        }
        return jComboBox;
    }

    @Override
    public Object addTextField(String string, String string2, String string3, String string4, String string5, boolean bl) {
        String string6 = String.valueOf(this.optionKey) + "_" + string;
        if (string3 == null && (string3 = (String)this.options.get(string6)) == null) {
            string3 = string5;
            this.options.put(string6, string3);
        }
        JTextField jTextField = new JTextField(string3);
        jTextField.setName(String.valueOf(this.registryKey) + "/" + string);
        if (bl) {
            jTextField.setPreferredSize(new Dimension(75, 25));
            jTextField.addActionListener((AwtDialogManager)this.manager);
            this.addPanelLine(string, string2, jTextField, string4);
        }
        return jTextField;
    }

    @Override
    public void createTable(Object[][] objectArray, String[] stringArray, int[] nArray) {
        try {
            this.dataTable = this.getDataTable(objectArray, stringArray, nArray, this.leftPanel == null ? this.defaultHeight : this.leftPanel.getHeight() - 50);
            JScrollPane jScrollPane = new JScrollPane(this.dataTable);
            if (this.mainSplitPane == null) {
                this.getContentPane().add(jScrollPane);
            } else {
                this.mainSplitPane.setRightComponent(jScrollPane);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void endLayout() {
        this.getContentPane().removeAll();
        this.getContentPane().add(this.mainSplitPane);
        this.pack();
    }

    private synchronized JTable getDataTable(Object[][] objectArray, String[] stringArray, int[] nArray, int n) {
        this.selectedRow = -1;
        this.tableModel = new DialogTableModel(stringArray, objectArray, !this.haveColors);
        JTable jTable = new JTable(this.tableModel);
        jTable.setSelectionMode(0);
        if (this.haveColors) {
            jTable.setDefaultRenderer(GenericColor.class, new ColorRenderer());
        }
        jTable.setDefaultRenderer(String.class, new TitleRenderer());
        jTable.setCellSelectionEnabled(true);
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener((AwtDialogManager)this.manager);
        this.manager.registerSelector(String.valueOf(this.registryKey) + "/ROW", listSelectionModel);
        listSelectionModel = jTable.getColumnModel().getSelectionModel();
        listSelectionModel.addListSelectionListener((AwtDialogManager)this.manager);
        this.manager.registerSelector(String.valueOf(this.registryKey) + "/COL", listSelectionModel);
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            jTable.getColumnModel().getColumn(n3).setPreferredWidth(nArray[n3]);
            n2 += nArray[n3];
            ++n3;
        }
        jTable.setPreferredScrollableViewportSize(new Dimension(n2, n));
        return jTable;
    }

    @Override
    public int getSelectedIndex(Object object) {
        return ((JComboBox)object).getSelectedIndex();
    }

    @Override
    public Object getSelectedItem(Object object) {
        return ((JComboBox)object).getSelectedItem();
    }

    @Override
    public String getText(Object object) {
        return object instanceof JTextComponent ? ((JTextComponent)object).getText() : ((AbstractButton)object).getText();
    }

    @Override
    public boolean isSelected(Object object) {
        return ((JCheckBox)object).isSelected();
    }

    @Override
    public void selectTableRow(int n) {
        this.selectedRow = n;
        this.dataTable.clearSelection();
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void setCellSelectionEnabled(boolean bl) {
        this.dataTable.setCellSelectionEnabled(bl);
    }

    @Override
    public void setEnabled(Object object, boolean bl) {
        ((Component)object).setEnabled(bl);
    }

    @Override
    public void setIntLocation(int[] nArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        nArray[0] = Math.min(dimension.width - 50, nArray[0]);
        nArray[1] = Math.min(dimension.height - 50, nArray[1]);
        Point point = new Point(nArray[0], nArray[1]);
        this.setLocation(point);
    }

    @Override
    public void setPreferredSize(int n, int n2) {
        this.setPreferredSize(new Dimension(n, n2));
    }

    @Override
    public void setSelected(Object object, boolean bl) {
        ((JCheckBox)object).setSelected(bl);
    }

    @Override
    public void setSelectedIndex(Object object, int n) {
        ((JComboBox)object).setSelectedIndex(n);
    }

    @Override
    public void setText(Object object, String string) {
        if (object instanceof JTextComponent) {
            ((JTextComponent)object).setText(string);
        } else {
            ((AbstractButton)object).setText(string);
        }
    }

    @Override
    public void startLayout() {
        this.setPreferredSize(new Dimension(600, 370));
        this.getContentPane().removeAll();
        this.thisPanel = this.rightPanel = new JPanel();
        switch (this.type) {
            case Integration: 
            case PeakList: 
            case Measurements: 
            case NONE: {
                break;
            }
            case OverlayLegend: {
                this.tableCellAlignLeft = true;
                this.haveColors = true;
                this.haveTwoPanels = false;
                break;
            }
            case Views: {
                this.rightPanel = new JPanel(new GridBagLayout());
            }
        }
        if (this.haveTwoPanels) {
            this.thisPanel = this.leftPanel = new JPanel(new GridBagLayout());
            this.leftPanel.setMinimumSize(new Dimension(200, 300));
            this.mainSplitPane = new JSplitPane(1);
            this.mainSplitPane.setOneTouchExpandable(true);
            this.mainSplitPane.setResizeWeight(0.0);
            this.mainSplitPane.setLeftComponent(this.leftPanel);
            this.mainSplitPane.setRightComponent(new JScrollPane(this.rightPanel));
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((Color)object);
            if (bl) {
                MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                this.setBorder(matteBorder);
            } else {
                MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                this.setBorder(matteBorder);
            }
            return this;
        }
    }

    class TitleRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public TitleRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(AwtDialog.this.getColumnCentering(n2));
            this.setText(object.toString());
            bl = n == AwtDialog.this.selectedRow;
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            return this;
        }
    }
}

