/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.InetAddressImplFactory;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;
import sun.net.InetAddressCachePolicy;
import sun.net.spi.nameservice.NameService;
import sun.net.spi.nameservice.NameServiceDescriptor;
import sun.net.util.IPAddressUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

public class InetAddress
implements Serializable {
    static final int IPv4 = 1;
    static final int IPv6 = 2;
    static transient boolean preferIPv6Address;
    final transient InetAddressHolder holder = new InetAddressHolder();
    private static List<NameService> nameServices;
    private transient String canonicalHostName = null;
    private static final long serialVersionUID = 3286316764910316507L;
    private static final ConcurrentMap<String, Addresses> cache;
    private static final NavigableSet<CachedAddresses> expirySet;
    static InetAddressImpl impl;
    private static volatile CachedLocalHost cachedLocalHost;
    private static final long FIELDS_OFFSET;
    private static final Unsafe UNSAFE;
    private static final ObjectStreamField[] serialPersistentFields;

    InetAddressHolder holder() {
        return this.holder;
    }

    InetAddress() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new Inet4Address(this.holder().getHostName(), this.holder().getAddress());
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public boolean isReachable(int n) throws IOException {
        return this.isReachable(null, 0, n);
    }

    public boolean isReachable(NetworkInterface networkInterface, int n, int n2) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("ttl can't be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        return impl.isReachable(this, n2, networkInterface, n);
    }

    public String getHostName() {
        return this.getHostName(true);
    }

    String getHostName(boolean bl) {
        if (this.holder().getHostName() == null) {
            this.holder().hostName = InetAddress.getHostFromNameService(this, bl);
        }
        return this.holder().getHostName();
    }

    public String getCanonicalHostName() {
        if (this.canonicalHostName == null) {
            this.canonicalHostName = InetAddress.getHostFromNameService(this, true);
        }
        return this.canonicalHostName;
    }

    private static String getHostFromNameService(InetAddress inetAddress, boolean bl) {
        String string = null;
        for (NameService nameService : nameServices) {
            try {
                InetAddress[] inetAddressArray;
                string = nameService.getHostByAddr(inetAddress.getAddress());
                if (bl && (inetAddressArray = System.getSecurityManager()) != null) {
                    inetAddressArray.checkConnect(string, -1);
                }
                inetAddressArray = InetAddress.getAllByName0(string, bl);
                boolean bl2 = false;
                if (inetAddressArray != null) {
                    for (int i = 0; !bl2 && i < inetAddressArray.length; ++i) {
                        bl2 = inetAddress.equals(inetAddressArray[i]);
                    }
                }
                if (!bl2) {
                    string = inetAddress.getHostAddress();
                    return string;
                }
                break;
            }
            catch (SecurityException securityException) {
                string = inetAddress.getHostAddress();
                break;
            }
            catch (UnknownHostException unknownHostException) {
                string = inetAddress.getHostAddress();
            }
        }
        return string;
    }

    public byte[] getAddress() {
        return null;
    }

    public String getHostAddress() {
        return null;
    }

    public int hashCode() {
        return -1;
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        String string = this.holder().getHostName();
        return (string != null ? string : "") + "/" + this.getHostAddress();
    }

    private static NameService createNSProvider(String string) {
        if (string == null) {
            return null;
        }
        NameService nameService = null;
        if (string.equals("default")) {
            nameService = new NameService(){

                @Override
                public InetAddress[] lookupAllHostAddr(String string) throws UnknownHostException {
                    InetAddress.validate(string);
                    return impl.lookupAllHostAddr(string);
                }

                @Override
                public String getHostByAddr(byte[] byArray) throws UnknownHostException {
                    return impl.getHostByAddr(byArray);
                }
            };
        } else {
            final String string2 = string;
            try {
                nameService = AccessController.doPrivileged(new PrivilegedExceptionAction<NameService>(){

                    @Override
                    public NameService run() {
                        for (NameServiceDescriptor nameServiceDescriptor : ServiceLoader.load(NameServiceDescriptor.class)) {
                            if (!string2.equalsIgnoreCase(nameServiceDescriptor.getType() + "," + nameServiceDescriptor.getProviderName())) continue;
                            try {
                                return nameServiceDescriptor.createNameService();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                System.err.println("Cannot create name service:" + string2 + ": " + exception);
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
        }
        return nameService;
    }

    public static InetAddress getByAddress(String string, byte[] byArray) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null) {
            if (byArray.length == 4) {
                return new Inet4Address(string, byArray);
            }
            if (byArray.length == 16) {
                byte[] byArray2 = IPAddressUtil.convertFromIPv4MappedAddress(byArray);
                if (byArray2 != null) {
                    return new Inet4Address(string, byArray2);
                }
                return new Inet6Address(string, byArray);
            }
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string)[0];
    }

    private static InetAddress getByName(String string, InetAddress inetAddress) throws UnknownHostException {
        return InetAddress.getAllByName(string, inetAddress)[0];
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException {
        return InetAddress.getAllByName(string, null);
    }

    private static InetAddress[] getAllByName(String string, InetAddress inetAddress) throws UnknownHostException {
        if (string == null || string.length() == 0) {
            InetAddress[] inetAddressArray = new InetAddress[]{impl.loopbackAddress()};
            return inetAddressArray;
        }
        InetAddress.validate(string);
        boolean bl = false;
        if (string.charAt(0) == '[') {
            if (string.length() > 2 && string.charAt(string.length() - 1) == ']') {
                string = string.substring(1, string.length() - 1);
                bl = true;
            } else {
                throw InetAddress.invalidIPv6LiteralException(string, false);
            }
        }
        if (IPAddressUtil.digit(string.charAt(0), 16) != -1 || string.charAt(0) == ':') {
            byte[] byArray = null;
            int n = -1;
            String string2 = null;
            if (!bl) {
                try {
                    byArray = IPAddressUtil.validateNumericFormatV4(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    UnknownHostException unknownHostException = new UnknownHostException(string);
                    unknownHostException.initCause(illegalArgumentException);
                    throw unknownHostException;
                }
            }
            if (byArray == null) {
                int n2 = string.indexOf(37);
                if (n2 != -1 && (n = InetAddress.checkNumericZone(string)) == -1) {
                    string2 = string.substring(n2 + 1);
                }
                if ((byArray = IPAddressUtil.textToNumericFormatV6(string)) == null && (string.contains(":") || bl)) {
                    throw InetAddress.invalidIPv6LiteralException(string, bl);
                }
            }
            if (byArray != null) {
                InetAddress[] inetAddressArray = new InetAddress[1];
                if (byArray.length == 4) {
                    if (n != -1 || string2 != null) {
                        throw new UnknownHostException(string + ": invalid IPv4-mapped address");
                    }
                    inetAddressArray[0] = new Inet4Address(null, byArray);
                } else {
                    inetAddressArray[0] = string2 != null ? new Inet6Address(null, byArray, string2) : new Inet6Address(null, byArray, n);
                }
                return inetAddressArray;
            }
        } else if (bl) {
            throw InetAddress.invalidIPv6LiteralException(string, true);
        }
        return InetAddress.getAllByName0(string, inetAddress, true, true);
    }

    private static UnknownHostException invalidIPv6LiteralException(String string, boolean bl) {
        String string2 = bl ? "[" + string + "]" : string;
        return new UnknownHostException(string2 + ": invalid IPv6 address literal");
    }

    public static InetAddress getLoopbackAddress() {
        return impl.loopbackAddress();
    }

    private static int checkNumericZone(String string) throws UnknownHostException {
        int n = string.indexOf(37);
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0xCCCCCCC;
        if (n == -1) {
            return -1;
        }
        for (int i = n + 1; i < n2; ++i) {
            char c = string.charAt(i);
            int n5 = IPAddressUtil.parseAsciiDigit(c, 10);
            if (n5 < 0) {
                return -1;
            }
            if (n3 > n4) {
                return -1;
            }
            if ((n3 = n3 * 10 + n5) >= 0) continue;
            return -1;
        }
        return n3;
    }

    private static InetAddress[] getAllByName0(String string) throws UnknownHostException {
        return InetAddress.getAllByName0(string, true);
    }

    static InetAddress[] getAllByName0(String string, boolean bl) throws UnknownHostException {
        return InetAddress.getAllByName0(string, null, bl, true);
    }

    private static InetAddress[] getAllByName0(String string, InetAddress inetAddress, boolean bl, boolean bl2) throws UnknownHostException {
        Object object;
        Addresses addresses2;
        SecurityManager securityManager;
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkConnect(string, -1);
        }
        long l = System.nanoTime();
        for (Addresses addresses2 : expirySet) {
            if (addresses2.expiryTime - l >= 0L) break;
            if (!expirySet.remove(addresses2)) continue;
            cache.remove(addresses2.host, addresses2);
        }
        if (bl2) {
            object = (Addresses)cache.get(string);
        } else {
            object = (Addresses)cache.remove(string);
            if (object != null) {
                if (object instanceof CachedAddresses) {
                    expirySet.remove(object);
                }
                object = null;
            }
        }
        if (object == null && (addresses2 = cache.putIfAbsent(string, (Addresses)(object = new NameServiceAddresses(string, inetAddress)))) != null) {
            object = addresses2;
        }
        return (InetAddress[])object.get().clone();
    }

    static InetAddress[] getAddressesFromNameService(String string, InetAddress inetAddress) throws UnknownHostException {
        InetAddress[] inetAddressArray = null;
        UnknownHostException unknownHostException = null;
        for (NameService object2 : nameServices) {
            try {
                inetAddressArray = object2.lookupAllHostAddr(string);
                break;
            }
            catch (UnknownHostException unknownHostException2) {
                if (string.equalsIgnoreCase("localhost")) {
                    inetAddressArray = new InetAddress[]{impl.loopbackAddress()};
                    break;
                }
                unknownHostException = unknownHostException2;
            }
        }
        if (inetAddressArray == null) {
            throw unknownHostException == null ? new UnknownHostException(string) : unknownHostException;
        }
        if (inetAddress != null && inetAddressArray.length > 1 && !inetAddressArray[0].equals(inetAddress)) {
            int n;
            for (n = 1; n < inetAddressArray.length && !inetAddressArray[n].equals(inetAddress); ++n) {
            }
            if (n < inetAddressArray.length) {
                InetAddress inetAddress2 = inetAddress;
                for (int i = 0; i < n; ++i) {
                    InetAddress inetAddress3 = inetAddressArray[i];
                    inetAddressArray[i] = inetAddress2;
                    inetAddress2 = inetAddress3;
                }
                inetAddressArray[n] = inetAddress2;
            }
        }
        return inetAddressArray;
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        return InetAddress.getByAddress(null, byArray);
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        SecurityManager securityManager = System.getSecurityManager();
        try {
            InetAddress inetAddress;
            CachedLocalHost cachedLocalHost = InetAddress.cachedLocalHost;
            if (cachedLocalHost != null && cachedLocalHost.expiryTime - System.nanoTime() >= 0L) {
                if (securityManager != null) {
                    securityManager.checkConnect(cachedLocalHost.host, -1);
                }
                return cachedLocalHost.addr;
            }
            String string = impl.getLocalHostName();
            if (securityManager != null) {
                securityManager.checkConnect(string, -1);
            }
            if (string.equals("localhost")) {
                inetAddress = impl.loopbackAddress();
            } else {
                try {
                    inetAddress = InetAddress.getAllByName0(string, null, false, false)[0];
                }
                catch (UnknownHostException unknownHostException) {
                    UnknownHostException unknownHostException2 = new UnknownHostException(string + ": " + unknownHostException.getMessage());
                    unknownHostException2.initCause(unknownHostException);
                    throw unknownHostException2;
                }
            }
            InetAddress.cachedLocalHost = new CachedLocalHost(string, inetAddress);
            return inetAddress;
        }
        catch (SecurityException securityException) {
            return impl.loopbackAddress();
        }
    }

    private static native void init();

    static InetAddress anyLocalAddress() {
        return impl.anyLocalAddress();
    }

    static InetAddressImpl loadImpl(String string) {
        Object var1_1 = null;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("impl.prefix", ""));
        try {
            var1_1 = Class.forName("java.net." + string2 + string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: java.net." + string2 + string + ":\ncheck impl.prefix property in your properties file.");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate: java.net." + string2 + string + ":\ncheck impl.prefix property in your properties file.");
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access class: java.net." + string2 + string + ":\ncheck impl.prefix property in your properties file.");
        }
        if (var1_1 == null) {
            try {
                var1_1 = Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
        return var1_1;
    }

    private void readObjectNoData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        String string = (String)getField.get("hostName", null);
        int n = getField.get("address", 0);
        int n2 = getField.get("family", 0);
        if (n2 != 1 && n2 != 2) {
            throw new InvalidObjectException("invalid address family type: " + n2);
        }
        InetAddressHolder inetAddressHolder = new InetAddressHolder(string, n, n2);
        UNSAFE.putObject((Object)this, FIELDS_OFFSET, (Object)inetAddressHolder);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.getClass().getClassLoader() != null) {
            throw new SecurityException("invalid address type");
        }
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("hostName", this.holder().getHostName());
        putField.put("address", this.holder().getAddress());
        putField.put("family", this.holder().getFamily());
        objectOutputStream.writeFields();
    }

    private static void validate(String string) throws UnknownHostException {
        if (string.indexOf(0) != -1) {
            throw new UnknownHostException("NUL character not allowed in hostname");
        }
    }

    static {
        NameService nameService;
        preferIPv6Address = false;
        nameServices = null;
        preferIPv6Address = AccessController.doPrivileged(new GetBooleanAction("java.net.preferIPv6Addresses"));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("net");
                return null;
            }
        });
        InetAddress.init();
        cache = new ConcurrentHashMap<String, Addresses>();
        expirySet = new ConcurrentSkipListSet<CachedAddresses>();
        impl = InetAddressImplFactory.create();
        Object object = null;
        String string = "sun.net.spi.nameservice.provider.";
        int n = 1;
        nameServices = new ArrayList<NameService>();
        object = AccessController.doPrivileged(new GetPropertyAction(string + n));
        while (object != null) {
            nameService = InetAddress.createNSProvider((String)object);
            if (nameService != null) {
                nameServices.add(nameService);
            }
            object = AccessController.doPrivileged(new GetPropertyAction(string + ++n));
        }
        if (nameServices.size() == 0) {
            nameService = InetAddress.createNSProvider("default");
            nameServices.add(nameService);
        }
        try {
            object = Unsafe.getUnsafe();
            FIELDS_OFFSET = ((Unsafe)object).objectFieldOffset(InetAddress.class.getDeclaredField("holder"));
            UNSAFE = object;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new Error(reflectiveOperationException);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("hostName", String.class), new ObjectStreamField("address", Integer.TYPE), new ObjectStreamField("family", Integer.TYPE)};
    }

    private static final class CachedLocalHost {
        final String host;
        final InetAddress addr;
        final long expiryTime = System.nanoTime() + 5000000000L;

        CachedLocalHost(String string, InetAddress inetAddress) {
            this.host = string;
            this.addr = inetAddress;
        }
    }

    private static final class NameServiceAddresses
    implements Addresses {
        private final String host;
        private final InetAddress reqAddr;

        NameServiceAddresses(String string, InetAddress inetAddress) {
            this.host = string;
            this.reqAddr = inetAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetAddress[] get() throws UnknownHostException {
            Addresses addresses;
            NameServiceAddresses nameServiceAddresses = this;
            synchronized (nameServiceAddresses) {
                addresses = cache.putIfAbsent(this.host, this);
                if (addresses == null) {
                    addresses = this;
                }
                if (addresses == this) {
                    int n;
                    UnknownHostException unknownHostException;
                    InetAddress[] inetAddressArray;
                    try {
                        inetAddressArray = InetAddress.getAddressesFromNameService(this.host, this.reqAddr);
                        unknownHostException = null;
                        n = InetAddressCachePolicy.get();
                    }
                    catch (UnknownHostException unknownHostException2) {
                        inetAddressArray = null;
                        unknownHostException = unknownHostException2;
                        n = InetAddressCachePolicy.getNegative();
                    }
                    if (n == 0) {
                        cache.remove(this.host, this);
                    } else {
                        CachedAddresses cachedAddresses = new CachedAddresses(this.host, inetAddressArray, n == -1 ? 0L : System.nanoTime() + 1000000000L * (long)n);
                        if (cache.replace(this.host, this, cachedAddresses) && n != -1) {
                            expirySet.add(cachedAddresses);
                        }
                    }
                    if (inetAddressArray == null) {
                        throw unknownHostException == null ? new UnknownHostException(this.host) : unknownHostException;
                    }
                    return inetAddressArray;
                }
            }
            return addresses.get();
        }
    }

    private static final class CachedAddresses
    implements Addresses,
    Comparable<CachedAddresses> {
        private static final AtomicLong seq = new AtomicLong();
        final String host;
        final InetAddress[] inetAddresses;
        final long expiryTime;
        final long id = seq.incrementAndGet();

        CachedAddresses(String string, InetAddress[] inetAddressArray, long l) {
            this.host = string;
            this.inetAddresses = inetAddressArray;
            this.expiryTime = l;
        }

        @Override
        public InetAddress[] get() throws UnknownHostException {
            if (this.inetAddresses == null) {
                throw new UnknownHostException(this.host);
            }
            return this.inetAddresses;
        }

        @Override
        public int compareTo(CachedAddresses cachedAddresses) {
            long l = this.expiryTime - cachedAddresses.expiryTime;
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return Long.compare(this.id, cachedAddresses.id);
        }
    }

    private static interface Addresses {
        public InetAddress[] get() throws UnknownHostException;
    }

    static class InetAddressHolder {
        String originalHostName;
        String hostName;
        int address;
        int family;

        InetAddressHolder() {
        }

        InetAddressHolder(String string, int n, int n2) {
            this.originalHostName = string;
            this.hostName = string;
            this.address = n;
            this.family = n2;
        }

        void init(String string, int n) {
            this.originalHostName = string;
            this.hostName = string;
            if (n != -1) {
                this.family = n;
            }
        }

        String getHostName() {
            return this.hostName;
        }

        String getOriginalHostName() {
            return this.originalHostName;
        }

        int getAddress() {
            return this.address;
        }

        int getFamily() {
            return this.family;
        }
    }
}

