/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parseable;

public class ScanJobInfo
implements Parseable {
    public int filesTotal;
    public int filesScanned;
    public String scanning;
    public int status;

    public ScanJobInfo(String[] stringArray) throws LscpException {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public boolean isFinished() {
        if (this.status < 0) {
            return true;
        }
        return this.filesScanned == this.filesTotal && this.status == 100;
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (string.startsWith("FILES_TOTAL: ")) {
            string = string.substring("FILES_TOTAL: ".length());
            try {
                this.filesTotal = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
            }
        } else if (string.startsWith("FILES_SCANNED: ")) {
            string = string.substring("FILES_SCANNED: ".length());
            try {
                this.filesScanned = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
            }
        } else if (string.startsWith("SCANNING: ")) {
            this.scanning = string.substring("SCANNING: ".length());
        } else if (string.startsWith("STATUS: ")) {
            string = string.substring("STATUS: ".length());
            try {
                this.status = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
            }
        } else {
            return false;
        }
        return true;
    }
}

