/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config.runtime.exporter;

import io.quarkus.opentelemetry.runtime.config.runtime.exporter.CompressionType;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.configuration.DurationConverter;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithName;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;

public interface OtlpExporterConfig {
    public static final String DEFAULT_GRPC_BASE_URI = "http://localhost:4317/";
    public static final String DEFAULT_HTTP_BASE_URI = "http://localhost:4318/";
    public static final String DEFAULT_TIMEOUT_SECS = "10";

    @ConfigDocDefault(value="http://localhost:4317/")
    public Optional<String> endpoint();

    public Optional<List<String>> headers();

    public Optional<CompressionType> compression();

    @ConfigDocDefault(value="10s")
    @WithConverter(value=DurationConverter.class)
    public Duration timeout();

    @ConfigDocDefault(value="grpc")
    public Optional<String> protocol();

    @WithName(value="key-cert")
    public KeyCert keyCert();

    @WithName(value="trust-cert")
    public TrustCert trustCert();

    public Optional<String> tlsConfigurationName();

    public ProxyConfig proxyOptions();

    public static class Protocol {
        public static final String GRPC = "grpc";
        public static final String HTTP_PROTOBUF = "http/protobuf";
    }

    public static interface TrustCert {
        public Optional<List<String>> certs();
    }

    public static interface KeyCert {
        public Optional<List<String>> keys();

        public Optional<List<String>> certs();
    }

    public static interface ProxyConfig {
        @ConfigDocDefault(value="false")
        public boolean enabled();

        public Optional<String> username();

        public Optional<String> password();

        public OptionalInt port();

        public Optional<String> host();
    }
}

