/* gweather4.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "GWeather", gir_namespace = "GWeather", gir_version = "4.0", lower_case_cprefix = "gweather_")]
namespace GWeather {
	[CCode (cheader_filename = "libgweather/gweather.h", type_id = "gweather_info_get_type ()")]
	public class Info : GLib.Object {
		[CCode (has_construct_function = false)]
		public Info (GWeather.Location? location);
		public void abort ();
		public string get_apparent ();
		public unowned string get_application_id ();
		public unowned string get_attribution ();
		public string get_conditions ();
		public unowned string get_contact_info ();
		public string get_dew ();
		public GWeather.Provider get_enabled_providers ();
		public unowned GLib.SList<GWeather.Info> get_forecast_list ();
		public string get_humidity ();
		public unowned string get_icon_name ();
		public unowned GWeather.Location get_location ();
		public string get_location_name ();
		public string get_pressure ();
		public string get_sky ();
		public string get_sunrise ();
		public string get_sunset ();
		public unowned string get_symbolic_icon_name ();
		public string get_temp ();
		public string get_temp_max ();
		public string get_temp_min ();
		public string get_temp_summary ();
		public bool get_upcoming_moonphases (time_t phases);
		public string get_update ();
		public bool get_value_apparent (GWeather.TemperatureUnit unit, out double value);
		public bool get_value_conditions (out GWeather.ConditionPhenomenon phenomenon, out GWeather.ConditionQualifier qualifier);
		public bool get_value_dew (GWeather.TemperatureUnit unit, out double value);
		public bool get_value_moonphase (out GWeather.MoonPhase value, out GWeather.MoonLatitude lat);
		public bool get_value_pressure (GWeather.PressureUnit unit, out double value);
		public bool get_value_sky (out GWeather.Sky sky);
		public bool get_value_sunrise (out ulong value);
		public bool get_value_sunset (out ulong value);
		public bool get_value_temp (GWeather.TemperatureUnit unit, out double value);
		public bool get_value_temp_max (GWeather.TemperatureUnit unit, out double value);
		public bool get_value_temp_min (GWeather.TemperatureUnit unit, out double value);
		public bool get_value_update (out time_t value);
		public bool get_value_visibility (GWeather.DistanceUnit unit, out double value);
		public bool get_value_wind (GWeather.SpeedUnit unit, out double speed, out GWeather.WindDirection direction);
		public string get_visibility ();
		public string get_weather_summary ();
		public string get_wind ();
		public bool is_daytime ();
		public bool is_valid ();
		public bool network_error ();
		public int next_sun_event ();
		public void set_application_id (string application_id);
		public void set_contact_info (string contact_info);
		public void set_enabled_providers (GWeather.Provider providers);
		public void set_location (GWeather.Location? location);
		public static void store_cache ();
		public void update ();
		public string application_id { get; set; }
		public string contact_info { get; set; }
		public GWeather.Provider enabled_providers { get; set; }
		public GWeather.Location location { get; set construct; }
		public signal void updated ();
	}
	[CCode (cheader_filename = "libgweather/gweather.h", type_id = "gweather_location_get_type ()")]
	public class Location : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Location ();
		public GWeather.Location deserialize (GLib.Variant serialized);
		[CCode (has_construct_function = false)]
		public Location.detached (string name, string? icao, double latitude, double longitude);
		[CCode (finish_instance = false)]
		public async GWeather.Location detect_nearest_city (double lat, double lon, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool equal (GWeather.Location two);
		public GWeather.Location find_by_country_code (string country_code);
		public GWeather.Location? find_by_station_code (string station_code);
		public GWeather.Location find_nearest_city (double lat, double lon);
		public GWeather.Location find_nearest_city_full (double lat, double lon, owned GWeather.FilterFunc? func);
		public void free_timezones ([CCode (array_length = false, array_null_terminated = true)] owned GLib.TimeZone[] zones);
		public string? get_city_name ();
		public unowned string? get_code ();
		public void get_coords (out double latitude, out double longitude);
		public unowned string? get_country ();
		public string? get_country_name ();
		public double get_distance (GWeather.Location loc2);
		public unowned string? get_english_name ();
		public unowned string? get_english_sort_name ();
		public GWeather.LocationLevel get_level ();
		public unowned string? get_name ();
		public GWeather.Location? get_parent ();
		public unowned string? get_sort_name ();
		public unowned GLib.TimeZone? get_timezone ();
		public unowned string? get_timezone_str ();
		[CCode (array_length = false, array_null_terminated = true)]
		public GLib.TimeZone[] get_timezones ();
		public static GWeather.Location? get_world ();
		public bool has_coords ();
		public bool has_timezone ();
		public GWeather.Location? next_child (owned GWeather.Location? child);
		public unowned GLib.Variant serialize ();
	}
	[CCode (cheader_filename = "libgweather/gweather.h", has_type_id = false)]
	public struct Conditions {
		public bool significant;
		public GWeather.ConditionPhenomenon phenomenon;
		public GWeather.ConditionQualifier qualifier;
		public unowned string to_string ();
		public unowned string to_string_full (GWeather.FormatOptions options);
	}
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[SimpleType]
	public struct MoonLatitude : double {
	}
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[SimpleType]
	public struct MoonPhase : double {
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_PHENOMENON_", type_id = "gweather_phenomenon_get_type ()")]
	public enum ConditionPhenomenon {
		INVALID,
		NONE,
		DRIZZLE,
		RAIN,
		SNOW,
		SNOW_GRAINS,
		ICE_CRYSTALS,
		ICE_PELLETS,
		HAIL,
		SMALL_HAIL,
		UNKNOWN_PRECIPITATION,
		MIST,
		FOG,
		SMOKE,
		VOLCANIC_ASH,
		SAND,
		HAZE,
		SPRAY,
		DUST,
		SQUALL,
		SANDSTORM,
		DUSTSTORM,
		FUNNEL_CLOUD,
		TORNADO,
		DUST_WHIRLS,
		LAST
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_QUALIFIER_", type_id = "gweather_qualifier_get_type ()")]
	public enum ConditionQualifier {
		INVALID,
		NONE,
		VICINITY,
		LIGHT,
		MODERATE,
		HEAVY,
		SHALLOW,
		PATCHES,
		PARTIAL,
		THUNDERSTORM,
		BLOWING,
		SHOWERS,
		DRIFTING,
		FREEZING,
		LAST
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_DISTANCE_UNIT_", type_id = "gweather_distance_unit_get_type ()")]
	public enum DistanceUnit {
		INVALID,
		DEFAULT,
		METERS,
		KM,
		MILES
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_FORMAT_OPTION_", type_id = "gweather_format_options_get_type ()")]
	[Flags]
	public enum FormatOptions {
		DEFAULT,
		SENTENCE_CAPITALIZATION,
		NO_CAPITALIZATION
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_LOCATION_", type_id = "gweather_location_level_get_type ()")]
	public enum LocationLevel {
		WORLD,
		REGION,
		COUNTRY,
		ADM1,
		CITY,
		WEATHER_STATION,
		DETACHED,
		NAMED_TIMEZONE;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_PRESSURE_UNIT_", type_id = "gweather_pressure_unit_get_type ()")]
	public enum PressureUnit {
		INVALID,
		DEFAULT,
		KPA,
		HPA,
		MB,
		MM_HG,
		INCH_HG,
		ATM
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_PROVIDER_", type_id = "gweather_provider_get_type ()")]
	[Flags]
	public enum Provider {
		NONE,
		METAR,
		IWIN,
		MET_NO,
		OWM,
		NWS,
		ALL
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_SKY_", type_id = "gweather_sky_get_type ()")]
	public enum Sky {
		INVALID,
		CLEAR,
		BROKEN,
		SCATTERED,
		FEW,
		OVERCAST,
		LAST;
		public unowned string to_string ();
		public unowned string to_string_full (GWeather.FormatOptions options);
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_SPEED_UNIT_", type_id = "gweather_speed_unit_get_type ()")]
	public enum SpeedUnit {
		INVALID,
		DEFAULT,
		MS,
		KPH,
		MPH,
		KNOTS,
		BFT;
		public unowned string to_string ();
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_TEMP_UNIT_", type_id = "gweather_temperature_unit_get_type ()")]
	public enum TemperatureUnit {
		INVALID,
		DEFAULT,
		KELVIN,
		CENTIGRADE,
		FAHRENHEIT;
		public GWeather.TemperatureUnit to_real ();
	}
	[CCode (cheader_filename = "libgweather/gweather.h", cprefix = "GWEATHER_WIND_", type_id = "gweather_wind_direction_get_type ()")]
	public enum WindDirection {
		INVALID,
		VARIABLE,
		N,
		NNE,
		NE,
		ENE,
		E,
		ESE,
		SE,
		SSE,
		S,
		SSW,
		SW,
		WSW,
		W,
		WNW,
		NW,
		NNW,
		LAST;
		public unowned string to_string ();
		public unowned string to_string_full (GWeather.FormatOptions options);
	}
	[CCode (cheader_filename = "libgweather/gweather.h", instance_pos = 1.9)]
	public delegate bool FilterFunc (GWeather.Location location);
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[Version (replacement = "LocationLevel.to_string")]
	public static unowned string location_level_to_string (GWeather.LocationLevel level);
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[Version (replacement = "Sky.to_string")]
	public static unowned string sky_to_string (GWeather.Sky sky);
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[Version (replacement = "Sky.to_string_full")]
	public static unowned string sky_to_string_full (GWeather.Sky sky, GWeather.FormatOptions options);
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[Version (replacement = "SpeedUnit.to_string")]
	public static unowned string speed_unit_to_string (GWeather.SpeedUnit unit);
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[Version (replacement = "TemperatureUnit.to_real")]
	public static GWeather.TemperatureUnit temperature_unit_to_real (GWeather.TemperatureUnit unit);
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[Version (replacement = "WindDirection.to_string")]
	public static unowned string wind_direction_to_string (GWeather.WindDirection wind);
	[CCode (cheader_filename = "libgweather/gweather.h")]
	[Version (replacement = "WindDirection.to_string_full")]
	public static unowned string wind_direction_to_string_full (GWeather.WindDirection wind, GWeather.FormatOptions options);
}
