/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ons.NotificationManager;
import oracle.ons.spi.WorkloadManager;

public class ThreadPoolWorkloadManager
implements WorkloadManager {
    public static final int DEFAULT_POOL_SIZE = 12;
    public static final int POOL_TIMEOUT = 2000;
    private final int maxPoolSize;
    private final AtomicInteger poolSize = new AtomicInteger(0);
    private final AtomicInteger freePool = new AtomicInteger(0);
    private final DelayQueue<SimpleDelayedTask> queue = new DelayQueue();

    private void createWorker() {
        int n = this.poolSize.incrementAndGet();
        if (n > this.maxPoolSize) {
            NotificationManager.logger.finer("In createWorker, id = " + n);
            this.poolSize.decrementAndGet();
        } else {
            NotificationManager.logger.finer("In createWorker, call start()");
            new ExecutorThread().start();
        }
    }

    public ThreadPoolWorkloadManager() {
        this.maxPoolSize = 12;
    }

    @Override
    public void scheduleDelayed(Runnable runnable, long l) {
        SimpleDelayedTask simpleDelayedTask = new SimpleDelayedTask(runnable, l);
        NotificationManager.logger.finer("Calling offer for task " + simpleDelayedTask.action.toString());
        this.queue.offer(simpleDelayedTask);
        NotificationManager.getNotificationManager();
        NotificationManager.logger.finer("In SCH scheduleDelayed, poolSize.get() = " + this.poolSize.get() + ", delay_ms = " + l + ", poolSize.get() = " + this.poolSize.get() + "Queue size= " + this.queue.size());
        if (this.poolSize.get() < this.maxPoolSize && (this.freePool.get() <= 0 || l == 0L || this.poolSize.get() <= 0)) {
            NotificationManager.getNotificationManager();
            NotificationManager.logger.finer("In scheduleDelayed. call createWorker");
            this.createWorker();
        }
    }

    @Override
    public void schedule(Runnable runnable) {
        this.scheduleDelayed(runnable, 0L);
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            this.setDaemon(true);
            this.setName(String.format("ONS-task-thread-%d", this.getId()));
        }

        @Override
        public void run() {
            SimpleDelayedTask simpleDelayedTask = null;
            long l = 2000L;
            try {
                boolean bl;
                do {
                    ThreadPoolWorkloadManager.this.freePool.incrementAndGet();
                    bl = true;
                    NotificationManager.logger.finer("Before queue.poll, queue.size() = " + ThreadPoolWorkloadManager.this.queue.size() + " freePool = " + ThreadPoolWorkloadManager.this.freePool);
                    while (null != (simpleDelayedTask = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.poll(l, TimeUnit.MILLISECONDS))) {
                        SimpleDelayedTask simpleDelayedTask2;
                        NotificationManager.logger.finer("Calling poll for task " + simpleDelayedTask);
                        NotificationManager.logger.finer("In ExecutorThread.run, queue.size() = " + ThreadPoolWorkloadManager.this.queue.size() + ", poolSize.get() " + ThreadPoolWorkloadManager.this.poolSize.get() + ", maxPoolSize = " + ThreadPoolWorkloadManager.this.maxPoolSize);
                        if (ThreadPoolWorkloadManager.this.poolSize.get() < ThreadPoolWorkloadManager.this.maxPoolSize && (simpleDelayedTask2 = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.peek()) != null && simpleDelayedTask2.getDelay(TimeUnit.MILLISECONDS) <= 0L) {
                            NotificationManager.logger.finer("In ExecutorThread.run, tt = " + simpleDelayedTask2 + ", tt.getDelay(TimeUnit.MILLISECONDS) = " + simpleDelayedTask2.getDelay(TimeUnit.MILLISECONDS));
                            ThreadPoolWorkloadManager.this.createWorker();
                        }
                        ThreadPoolWorkloadManager.this.freePool.decrementAndGet();
                        NotificationManager.logger.finer("Before calling task.action.run()");
                        simpleDelayedTask.action.run();
                        NotificationManager.logger.finer("After calling task.action.run()");
                        l = 2000L;
                    }
                    if (ThreadPoolWorkloadManager.this.poolSize.decrementAndGet() != 0) continue;
                    NotificationManager.logger.finer("In ExecutorThread.run, poolSize = " + ThreadPoolWorkloadManager.this.poolSize);
                    simpleDelayedTask = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.peek();
                    if (simpleDelayedTask == null) continue;
                    l = simpleDelayedTask.getDelay(TimeUnit.MILLISECONDS);
                    NotificationManager.logger.finer("In ExecutorThread.run, delay = " + l);
                    if (ThreadPoolWorkloadManager.this.poolSize.incrementAndGet() <= ThreadPoolWorkloadManager.this.maxPoolSize) {
                        bl = false;
                        continue;
                    }
                    ThreadPoolWorkloadManager.this.poolSize.decrementAndGet();
                } while (!bl);
            }
            catch (InterruptedException interruptedException) {
                this.interrupt();
            }
        }
    }

    private static class SimpleDelayedTask
    implements Delayed {
        long runAt;
        Runnable action;

        SimpleDelayedTask(Runnable runnable, long l) {
            NotificationManager.logger.finer("Calling SimpleDelayedTask for action " + runnable + " with delay " + l);
            this.action = runnable;
            this.runAt = System.currentTimeMillis() + l;
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.runAt - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return (int)(this.runAt - ((SimpleDelayedTask)delayed).runAt);
        }
    }
}

