"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getAliases = getAliases;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class AliasServices extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "getAliases", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [aliases, apiAccessible, errMsg] = await getAliases(callWithRequest, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              aliases: aliases,
              totalAliases: aliases.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - AliasesService - getAliases:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = AliasServices;
async function getAliases(callWithRequest, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const aliasesResponse = await callWithRequest("cat.aliases", {
    format: "json",
    name: searchPattern
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        alias: []
      };
    }
    throw e;
  });
  return [aliasesResponse, accessible, errMsg];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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