/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AsPathCopier;
import software.amazon.awssdk.services.ec2.model.RouteServerRouteInstallationDetail;
import software.amazon.awssdk.services.ec2.model.RouteServerRouteInstallationDetailsCopier;
import software.amazon.awssdk.services.ec2.model.RouteServerRouteStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteServerRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteServerRoute> {
    private static final SdkField<String> ROUTE_SERVER_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerEndpointId").getter(RouteServerRoute.getter(RouteServerRoute::routeServerEndpointId)).setter(RouteServerRoute.setter(Builder::routeServerEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerEndpointId").unmarshallLocationName("routeServerEndpointId").build()}).build();
    private static final SdkField<String> ROUTE_SERVER_PEER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteServerPeerId").getter(RouteServerRoute.getter(RouteServerRoute::routeServerPeerId)).setter(RouteServerRoute.setter(Builder::routeServerPeerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerPeerId").unmarshallLocationName("routeServerPeerId").build()}).build();
    private static final SdkField<List<RouteServerRouteInstallationDetail>> ROUTE_INSTALLATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouteInstallationDetails").getter(RouteServerRoute.getter(RouteServerRoute::routeInstallationDetails)).setter(RouteServerRoute.setter(Builder::routeInstallationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteInstallationDetailSet").unmarshallLocationName("routeInstallationDetailSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteServerRouteInstallationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteStatus").getter(RouteServerRoute.getter(RouteServerRoute::routeStatusAsString)).setter(RouteServerRoute.setter(Builder::routeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteStatus").unmarshallLocationName("routeStatus").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(RouteServerRoute.getter(RouteServerRoute::prefix)).setter(RouteServerRoute.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("prefix").build()}).build();
    private static final SdkField<List<String>> AS_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AsPaths").getter(RouteServerRoute.getter(RouteServerRoute::asPaths)).setter(RouteServerRoute.setter(Builder::asPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsPathSet").unmarshallLocationName("asPathSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> MED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Med").getter(RouteServerRoute.getter(RouteServerRoute::med)).setter(RouteServerRoute.setter(Builder::med)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Med").unmarshallLocationName("med").build()}).build();
    private static final SdkField<String> NEXT_HOP_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextHopIp").getter(RouteServerRoute.getter(RouteServerRoute::nextHopIp)).setter(RouteServerRoute.setter(Builder::nextHopIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextHopIp").unmarshallLocationName("nextHopIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_ENDPOINT_ID_FIELD, ROUTE_SERVER_PEER_ID_FIELD, ROUTE_INSTALLATION_DETAILS_FIELD, ROUTE_STATUS_FIELD, PREFIX_FIELD, AS_PATHS_FIELD, MED_FIELD, NEXT_HOP_IP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteServerRoute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String routeServerEndpointId;
    private final String routeServerPeerId;
    private final List<RouteServerRouteInstallationDetail> routeInstallationDetails;
    private final String routeStatus;
    private final String prefix;
    private final List<String> asPaths;
    private final Integer med;
    private final String nextHopIp;

    private RouteServerRoute(BuilderImpl builder) {
        this.routeServerEndpointId = builder.routeServerEndpointId;
        this.routeServerPeerId = builder.routeServerPeerId;
        this.routeInstallationDetails = builder.routeInstallationDetails;
        this.routeStatus = builder.routeStatus;
        this.prefix = builder.prefix;
        this.asPaths = builder.asPaths;
        this.med = builder.med;
        this.nextHopIp = builder.nextHopIp;
    }

    public final String routeServerEndpointId() {
        return this.routeServerEndpointId;
    }

    public final String routeServerPeerId() {
        return this.routeServerPeerId;
    }

    public final boolean hasRouteInstallationDetails() {
        return this.routeInstallationDetails != null && !(this.routeInstallationDetails instanceof SdkAutoConstructList);
    }

    public final List<RouteServerRouteInstallationDetail> routeInstallationDetails() {
        return this.routeInstallationDetails;
    }

    public final RouteServerRouteStatus routeStatus() {
        return RouteServerRouteStatus.fromValue(this.routeStatus);
    }

    public final String routeStatusAsString() {
        return this.routeStatus;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final boolean hasAsPaths() {
        return this.asPaths != null && !(this.asPaths instanceof SdkAutoConstructList);
    }

    public final List<String> asPaths() {
        return this.asPaths;
    }

    public final Integer med() {
        return this.med;
    }

    public final String nextHopIp() {
        return this.nextHopIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeServerPeerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouteInstallationDetails() ? this.routeInstallationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAsPaths() ? this.asPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.med());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextHopIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServerRoute)) {
            return false;
        }
        RouteServerRoute other = (RouteServerRoute)obj;
        return Objects.equals(this.routeServerEndpointId(), other.routeServerEndpointId()) && Objects.equals(this.routeServerPeerId(), other.routeServerPeerId()) && this.hasRouteInstallationDetails() == other.hasRouteInstallationDetails() && Objects.equals(this.routeInstallationDetails(), other.routeInstallationDetails()) && Objects.equals(this.routeStatusAsString(), other.routeStatusAsString()) && Objects.equals(this.prefix(), other.prefix()) && this.hasAsPaths() == other.hasAsPaths() && Objects.equals(this.asPaths(), other.asPaths()) && Objects.equals(this.med(), other.med()) && Objects.equals(this.nextHopIp(), other.nextHopIp());
    }

    public final String toString() {
        return ToString.builder((String)"RouteServerRoute").add("RouteServerEndpointId", (Object)this.routeServerEndpointId()).add("RouteServerPeerId", (Object)this.routeServerPeerId()).add("RouteInstallationDetails", this.hasRouteInstallationDetails() ? this.routeInstallationDetails() : null).add("RouteStatus", (Object)this.routeStatusAsString()).add("Prefix", (Object)this.prefix()).add("AsPaths", this.hasAsPaths() ? this.asPaths() : null).add("Med", (Object)this.med()).add("NextHopIp", (Object)this.nextHopIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteServerEndpointId": {
                return Optional.ofNullable(clazz.cast(this.routeServerEndpointId()));
            }
            case "RouteServerPeerId": {
                return Optional.ofNullable(clazz.cast(this.routeServerPeerId()));
            }
            case "RouteInstallationDetails": {
                return Optional.ofNullable(clazz.cast(this.routeInstallationDetails()));
            }
            case "RouteStatus": {
                return Optional.ofNullable(clazz.cast(this.routeStatusAsString()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "AsPaths": {
                return Optional.ofNullable(clazz.cast(this.asPaths()));
            }
            case "Med": {
                return Optional.ofNullable(clazz.cast(this.med()));
            }
            case "NextHopIp": {
                return Optional.ofNullable(clazz.cast(this.nextHopIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RouteServerEndpointId", ROUTE_SERVER_ENDPOINT_ID_FIELD);
        map.put("RouteServerPeerId", ROUTE_SERVER_PEER_ID_FIELD);
        map.put("RouteInstallationDetailSet", ROUTE_INSTALLATION_DETAILS_FIELD);
        map.put("RouteStatus", ROUTE_STATUS_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("AsPathSet", AS_PATHS_FIELD);
        map.put("Med", MED_FIELD);
        map.put("NextHopIp", NEXT_HOP_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServerRoute, T> g) {
        return obj -> g.apply((RouteServerRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String routeServerEndpointId;
        private String routeServerPeerId;
        private List<RouteServerRouteInstallationDetail> routeInstallationDetails = DefaultSdkAutoConstructList.getInstance();
        private String routeStatus;
        private String prefix;
        private List<String> asPaths = DefaultSdkAutoConstructList.getInstance();
        private Integer med;
        private String nextHopIp;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServerRoute model) {
            this.routeServerEndpointId(model.routeServerEndpointId);
            this.routeServerPeerId(model.routeServerPeerId);
            this.routeInstallationDetails(model.routeInstallationDetails);
            this.routeStatus(model.routeStatus);
            this.prefix(model.prefix);
            this.asPaths(model.asPaths);
            this.med(model.med);
            this.nextHopIp(model.nextHopIp);
        }

        public final String getRouteServerEndpointId() {
            return this.routeServerEndpointId;
        }

        public final void setRouteServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
        }

        @Override
        public final Builder routeServerEndpointId(String routeServerEndpointId) {
            this.routeServerEndpointId = routeServerEndpointId;
            return this;
        }

        public final String getRouteServerPeerId() {
            return this.routeServerPeerId;
        }

        public final void setRouteServerPeerId(String routeServerPeerId) {
            this.routeServerPeerId = routeServerPeerId;
        }

        @Override
        public final Builder routeServerPeerId(String routeServerPeerId) {
            this.routeServerPeerId = routeServerPeerId;
            return this;
        }

        public final List<RouteServerRouteInstallationDetail.Builder> getRouteInstallationDetails() {
            List<RouteServerRouteInstallationDetail.Builder> result = RouteServerRouteInstallationDetailsCopier.copyToBuilder(this.routeInstallationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteInstallationDetails(Collection<RouteServerRouteInstallationDetail.BuilderImpl> routeInstallationDetails) {
            this.routeInstallationDetails = RouteServerRouteInstallationDetailsCopier.copyFromBuilder(routeInstallationDetails);
        }

        @Override
        public final Builder routeInstallationDetails(Collection<RouteServerRouteInstallationDetail> routeInstallationDetails) {
            this.routeInstallationDetails = RouteServerRouteInstallationDetailsCopier.copy(routeInstallationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeInstallationDetails(RouteServerRouteInstallationDetail ... routeInstallationDetails) {
            this.routeInstallationDetails(Arrays.asList(routeInstallationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeInstallationDetails(Consumer<RouteServerRouteInstallationDetail.Builder> ... routeInstallationDetails) {
            this.routeInstallationDetails(Stream.of(routeInstallationDetails).map(c -> (RouteServerRouteInstallationDetail)((RouteServerRouteInstallationDetail.Builder)RouteServerRouteInstallationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRouteStatus() {
            return this.routeStatus;
        }

        public final void setRouteStatus(String routeStatus) {
            this.routeStatus = routeStatus;
        }

        @Override
        public final Builder routeStatus(String routeStatus) {
            this.routeStatus = routeStatus;
            return this;
        }

        @Override
        public final Builder routeStatus(RouteServerRouteStatus routeStatus) {
            this.routeStatus(routeStatus == null ? null : routeStatus.toString());
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final Collection<String> getAsPaths() {
            if (this.asPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.asPaths;
        }

        public final void setAsPaths(Collection<String> asPaths) {
            this.asPaths = AsPathCopier.copy(asPaths);
        }

        @Override
        public final Builder asPaths(Collection<String> asPaths) {
            this.asPaths = AsPathCopier.copy(asPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asPaths(String ... asPaths) {
            this.asPaths(Arrays.asList(asPaths));
            return this;
        }

        public final Integer getMed() {
            return this.med;
        }

        public final void setMed(Integer med) {
            this.med = med;
        }

        @Override
        public final Builder med(Integer med) {
            this.med = med;
            return this;
        }

        public final String getNextHopIp() {
            return this.nextHopIp;
        }

        public final void setNextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
        }

        @Override
        public final Builder nextHopIp(String nextHopIp) {
            this.nextHopIp = nextHopIp;
            return this;
        }

        public RouteServerRoute build() {
            return new RouteServerRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteServerRoute> {
        public Builder routeServerEndpointId(String var1);

        public Builder routeServerPeerId(String var1);

        public Builder routeInstallationDetails(Collection<RouteServerRouteInstallationDetail> var1);

        public Builder routeInstallationDetails(RouteServerRouteInstallationDetail ... var1);

        public Builder routeInstallationDetails(Consumer<RouteServerRouteInstallationDetail.Builder> ... var1);

        public Builder routeStatus(String var1);

        public Builder routeStatus(RouteServerRouteStatus var1);

        public Builder prefix(String var1);

        public Builder asPaths(Collection<String> var1);

        public Builder asPaths(String ... var1);

        public Builder med(Integer var1);

        public Builder nextHopIp(String var1);
    }
}

