/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeSpec {
    private static Pattern timepat = Pattern.compile("(?:(\\d+)(d))??(?:(\\d+)(h))??(?:(\\d+)(m))??(?:(\\d+)(s))??(?:(\\d+)(ms))??");
    private static final Map<String, TimeUnit> tum = new HashMap<String, TimeUnit>();

    public static long parse(String timespec) throws IllegalArgumentException {
        Matcher m = timepat.matcher(timespec);
        long nms = 0L;
        if (m.matches()) {
            for (int i = 1; i <= m.groupCount(); i += 2) {
                if (m.group(i) == null) continue;
                long dur = Integer.parseInt(m.group(i));
                TimeUnit tu = tum.get(m.group(i + 1));
                nms += tu.toMillis(dur);
            }
        } else {
            throw new IllegalArgumentException("Couldn't parse timespec " + timespec);
        }
        return nms;
    }

    static {
        tum.put("d", TimeUnit.DAYS);
        tum.put("h", TimeUnit.HOURS);
        tum.put("m", TimeUnit.MINUTES);
        tum.put("s", TimeUnit.SECONDS);
        tum.put("ms", TimeUnit.MILLISECONDS);
    }
}

