/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.security.PatchOperation;
import org.opensearch.client.opensearch.security.PatchUserResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PatchUserRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PatchUserRequest> {
    @Nonnull
    private final List<PatchOperation> operations;
    @Nonnull
    private final String username;
    public static final JsonpDeserializer<PatchUserRequest> _DESERIALIZER = PatchUserRequest.createPatchUserRequestDeserializer();
    public static final Endpoint<PatchUserRequest, PatchUserResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PatchUserRequest, PatchUserResponse>(request -> "PATCH", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_security/api/internalusers/");
        SimpleEndpoint.pathEncode(request.username, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PatchUserResponse._DESERIALIZER);

    private PatchUserRequest(Builder builder) {
        super(builder);
        this.operations = ApiTypeHelper.unmodifiableRequired(builder.operations, (Object)this, "operations");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
    }

    public static PatchUserRequest of(Function<Builder, ObjectBuilder<PatchUserRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<PatchOperation> operations() {
        return this.operations;
    }

    @Nonnull
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (PatchOperation item0 : this.operations) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static JsonpDeserializer<PatchUserRequest> createPatchUserRequestDeserializer() {
        JsonpDeserializer<List<PatchOperation>> valueDeserializer = JsonpDeserializer.arrayDeserializer(PatchOperation._DESERIALIZER);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().operations((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.operations.hashCode();
        result = 31 * result + this.username.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchUserRequest other = (PatchUserRequest)o;
        return this.operations.equals(other.operations) && this.username.equals(other.username);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PatchUserRequest> {
        private List<PatchOperation> operations;
        private String username;

        public Builder() {
        }

        private Builder(PatchUserRequest o) {
            super(o);
            this.operations = Builder._listCopy(o.operations);
            this.username = o.username;
        }

        private Builder(Builder o) {
            super(o);
            this.operations = Builder._listCopy(o.operations);
            this.username = o.username;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder operations(List<PatchOperation> list) {
            this.operations = Builder._listAddAll(this.operations, list);
            return this;
        }

        @Nonnull
        public final Builder operations(PatchOperation value, PatchOperation ... values) {
            this.operations = Builder._listAdd(this.operations, value, values);
            return this;
        }

        @Nonnull
        public final Builder operations(Function<PatchOperation.Builder, ObjectBuilder<PatchOperation>> fn) {
            return this.operations(fn.apply(new PatchOperation.Builder()).build(), new PatchOperation[0]);
        }

        @Nonnull
        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        @Override
        @Nonnull
        public PatchUserRequest build() {
            this._checkSingleUse();
            return new PatchUserRequest(this);
        }
    }
}

