/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.SortMode;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MatrixAggregation;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MatrixStatsAggregation
extends MatrixAggregation
implements AggregationVariant,
ToCopyableBuilder<Builder, MatrixStatsAggregation> {
    @Nullable
    private final SortMode mode;
    public static final JsonpDeserializer<MatrixStatsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatrixStatsAggregation::setupMatrixStatsAggregationDeserializer);

    private MatrixStatsAggregation(Builder builder) {
        super(builder);
        this.mode = builder.mode;
    }

    public static MatrixStatsAggregation of(Function<Builder, ObjectBuilder<MatrixStatsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MatrixStats;
    }

    @Nullable
    public final SortMode mode() {
        return this.mode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMatrixStatsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MatrixStatsAggregation.setupMatrixAggregationDeserializer(op);
        op.add(Builder::mode, SortMode._DESERIALIZER, "mode");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.mode);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatrixStatsAggregation other = (MatrixStatsAggregation)o;
        return Objects.equals(this.mode, other.mode);
    }

    public static class Builder
    extends MatrixAggregation.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, MatrixStatsAggregation> {
        @Nullable
        private SortMode mode;

        public Builder() {
        }

        private Builder(MatrixStatsAggregation o) {
            super(o);
            this.mode = o.mode;
        }

        private Builder(Builder o) {
            super(o);
            this.mode = o.mode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder mode(@Nullable SortMode value) {
            this.mode = value;
            return this;
        }

        @Override
        @Nonnull
        public MatrixStatsAggregation build() {
            this._checkSingleUse();
            return new MatrixStatsAggregation(this);
        }
    }
}

