/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Breaker
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Breaker> {
    @Nullable
    private final String estimatedSize;
    @Nullable
    private final Long estimatedSizeInBytes;
    @Nullable
    private final String limitSize;
    @Nullable
    private final Long limitSizeInBytes;
    @Nullable
    private final Double overhead;
    @Nullable
    private final Long tripped;
    public static final JsonpDeserializer<Breaker> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Breaker::setupBreakerDeserializer);

    private Breaker(Builder builder) {
        this.estimatedSize = builder.estimatedSize;
        this.estimatedSizeInBytes = builder.estimatedSizeInBytes;
        this.limitSize = builder.limitSize;
        this.limitSizeInBytes = builder.limitSizeInBytes;
        this.overhead = builder.overhead;
        this.tripped = builder.tripped;
    }

    public static Breaker of(Function<Builder, ObjectBuilder<Breaker>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String estimatedSize() {
        return this.estimatedSize;
    }

    @Nullable
    public final Long estimatedSizeInBytes() {
        return this.estimatedSizeInBytes;
    }

    @Nullable
    public final String limitSize() {
        return this.limitSize;
    }

    @Nullable
    public final Long limitSizeInBytes() {
        return this.limitSizeInBytes;
    }

    @Nullable
    public final Double overhead() {
        return this.overhead;
    }

    @Nullable
    public final Long tripped() {
        return this.tripped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.estimatedSize != null) {
            generator.writeKey("estimated_size");
            generator.write(this.estimatedSize);
        }
        if (this.estimatedSizeInBytes != null) {
            generator.writeKey("estimated_size_in_bytes");
            generator.write(this.estimatedSizeInBytes.longValue());
        }
        if (this.limitSize != null) {
            generator.writeKey("limit_size");
            generator.write(this.limitSize);
        }
        if (this.limitSizeInBytes != null) {
            generator.writeKey("limit_size_in_bytes");
            generator.write(this.limitSizeInBytes.longValue());
        }
        if (this.overhead != null) {
            generator.writeKey("overhead");
            generator.write(this.overhead.doubleValue());
        }
        if (this.tripped != null) {
            generator.writeKey("tripped");
            generator.write(this.tripped.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupBreakerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::estimatedSize, JsonpDeserializer.stringDeserializer(), "estimated_size");
        op.add(Builder::estimatedSizeInBytes, JsonpDeserializer.longDeserializer(), "estimated_size_in_bytes");
        op.add(Builder::limitSize, JsonpDeserializer.stringDeserializer(), "limit_size");
        op.add(Builder::limitSizeInBytes, JsonpDeserializer.longDeserializer(), "limit_size_in_bytes");
        op.add(Builder::overhead, JsonpDeserializer.doubleDeserializer(), "overhead");
        op.add(Builder::tripped, JsonpDeserializer.longDeserializer(), "tripped");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.estimatedSize);
        result = 31 * result + Objects.hashCode(this.estimatedSizeInBytes);
        result = 31 * result + Objects.hashCode(this.limitSize);
        result = 31 * result + Objects.hashCode(this.limitSizeInBytes);
        result = 31 * result + Objects.hashCode(this.overhead);
        result = 31 * result + Objects.hashCode(this.tripped);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breaker other = (Breaker)o;
        return Objects.equals(this.estimatedSize, other.estimatedSize) && Objects.equals(this.estimatedSizeInBytes, other.estimatedSizeInBytes) && Objects.equals(this.limitSize, other.limitSize) && Objects.equals(this.limitSizeInBytes, other.limitSizeInBytes) && Objects.equals(this.overhead, other.overhead) && Objects.equals(this.tripped, other.tripped);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Breaker> {
        @Nullable
        private String estimatedSize;
        @Nullable
        private Long estimatedSizeInBytes;
        @Nullable
        private String limitSize;
        @Nullable
        private Long limitSizeInBytes;
        @Nullable
        private Double overhead;
        @Nullable
        private Long tripped;

        public Builder() {
        }

        private Builder(Breaker o) {
            this.estimatedSize = o.estimatedSize;
            this.estimatedSizeInBytes = o.estimatedSizeInBytes;
            this.limitSize = o.limitSize;
            this.limitSizeInBytes = o.limitSizeInBytes;
            this.overhead = o.overhead;
            this.tripped = o.tripped;
        }

        private Builder(Builder o) {
            this.estimatedSize = o.estimatedSize;
            this.estimatedSizeInBytes = o.estimatedSizeInBytes;
            this.limitSize = o.limitSize;
            this.limitSizeInBytes = o.limitSizeInBytes;
            this.overhead = o.overhead;
            this.tripped = o.tripped;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder estimatedSize(@Nullable String value) {
            this.estimatedSize = value;
            return this;
        }

        @Nonnull
        public final Builder estimatedSizeInBytes(@Nullable Long value) {
            this.estimatedSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder limitSize(@Nullable String value) {
            this.limitSize = value;
            return this;
        }

        @Nonnull
        public final Builder limitSizeInBytes(@Nullable Long value) {
            this.limitSizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder overhead(@Nullable Double value) {
            this.overhead = value;
            return this;
        }

        @Nonnull
        public final Builder tripped(@Nullable Long value) {
            this.tripped = value;
            return this;
        }

        @Override
        @Nonnull
        public Breaker build() {
            this._checkSingleUse();
            return new Breaker(this);
        }
    }
}

