/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.util;

import com.azure.xml.implementation.aalto.in.ReaderConfig;
import java.util.ArrayList;

public final class TextBuilder {
    static final char[] sNoChars = new char[0];
    static final int DEF_INITIAL_BUFFER_SIZE = 500;
    static final int MAX_SEGMENT_LENGTH = 262144;
    private final ReaderConfig _config;
    private ArrayList<char[]> _segments;
    private int _segmentSize;
    private char[] _currentSegment;
    private int _currentSize;
    private String _resultString;
    private char[] _resultArray;
    private int _resultLen;
    private boolean _isIndentation = false;
    public static final int MAX_INDENT_SPACES = 32;
    public static final int MAX_INDENT_TABS = 8;
    private static final String sIndSpaces = "\n                                 ";
    private static final char[] sIndSpacesArray = "\n                                 ".toCharArray();
    private static final String[] sIndSpacesStrings = new String[sIndSpacesArray.length];
    private static final String sIndTabs = "\n\t\t\t\t\t\t\t\t\t";
    private static final char[] sIndTabsArray = "\n\t\t\t\t\t\t\t\t\t".toCharArray();
    private static final String[] sIndTabsStrings = new String[sIndTabsArray.length];

    private TextBuilder(ReaderConfig cfg) {
        this._config = cfg;
    }

    public static TextBuilder createRecyclableBuffer(ReaderConfig cfg) {
        return new TextBuilder(cfg);
    }

    public void recycle(boolean force) {
        if (this._config != null && this._currentSegment != null) {
            if (force) {
                this._resultString = null;
                this._resultArray = null;
            } else if (this._segmentSize + this._currentSize > 0) {
                return;
            }
            if (this._segments != null && !this._segments.isEmpty()) {
                this._segments.clear();
                this._segmentSize = 0;
            }
            char[] buf = this._currentSegment;
            this._currentSegment = null;
            this._config.freeMediumCBuffer(buf);
        }
    }

    public char[] resetWithEmpty() {
        this._resultString = null;
        this._resultArray = null;
        this._isIndentation = false;
        if (this._segments != null && !this._segments.isEmpty()) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = 0;
        if (this._currentSegment == null) {
            this._currentSegment = this.allocBuffer();
        }
        return this._currentSegment;
    }

    public void resetWithIndentation(int indCharCount, char indChar) {
        String text;
        int strlen;
        if (this._segments != null && !this._segments.isEmpty()) {
            this._segments.clear();
            this._segmentSize = 0;
        }
        this._currentSize = -1;
        this._isIndentation = true;
        this._resultLen = strlen = indCharCount + 1;
        if (indChar == '\t') {
            this._resultArray = sIndTabsArray;
            text = sIndTabsStrings[indCharCount];
            if (text == null) {
                TextBuilder.sIndTabsStrings[indCharCount] = text = sIndTabs.substring(0, strlen);
            }
        } else {
            this._resultArray = sIndSpacesArray;
            text = sIndSpacesStrings[indCharCount];
            if (text == null) {
                TextBuilder.sIndSpacesStrings[indCharCount] = text = sIndSpaces.substring(0, strlen);
            }
        }
        this._resultString = text;
    }

    public char[] getBufferWithoutReset() {
        return this._currentSegment;
    }

    public int size() {
        int size = this._currentSize;
        if (size < 0) {
            return this._resultLen;
        }
        return size + this._segmentSize;
    }

    public char[] getTextBuffer() {
        if (this._segments == null || this._segments.isEmpty()) {
            if (this._resultArray != null) {
                return this._resultArray;
            }
            return this._currentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this._resultString == null) {
            if (this._resultArray != null) {
                this._resultString = new String(this._resultArray);
            } else {
                int segLen = this._segmentSize;
                int currLen = this._currentSize;
                if (segLen == 0) {
                    this._resultString = currLen == 0 ? "" : new String(this._currentSegment, 0, currLen);
                    return this._resultString;
                }
                StringBuilder sb = new StringBuilder(segLen + currLen);
                if (this._segments != null) {
                    for (char[] segment : this._segments) {
                        sb.append(segment, 0, segment.length);
                    }
                }
                sb.append(this._currentSegment, 0, currLen);
                this._resultString = sb.toString();
            }
        }
        return this._resultString;
    }

    public char[] contentsAsArray() {
        char[] result = this._resultArray;
        if (result == null) {
            this._resultArray = result = this.buildResultArray();
        }
        return result;
    }

    public int contentsToArray(int srcStart, char[] dst, int dstStart, int len) {
        int totalAmount = 0;
        if (this._segments != null) {
            for (char[] chars : this._segments) {
                int segLen = chars.length;
                int amount = segLen - srcStart;
                if (amount < 1) {
                    srcStart -= segLen;
                    continue;
                }
                if (amount >= len) {
                    System.arraycopy(chars, srcStart, dst, dstStart, len);
                    return totalAmount + len;
                }
                System.arraycopy(chars, srcStart, dst, dstStart, amount);
                totalAmount += amount;
                dstStart += amount;
                len -= amount;
                srcStart = 0;
            }
        }
        if (len > 0) {
            int maxAmount = this._currentSize - srcStart;
            if (len > maxAmount) {
                len = maxAmount;
            }
            if (len > 0) {
                System.arraycopy(this._currentSegment, srcStart, dst, dstStart, len);
                totalAmount += len;
            }
        }
        return totalAmount;
    }

    public boolean isAllWhitespace() {
        if (this._isIndentation) {
            return true;
        }
        if (this._segments != null) {
            for (char[] segment : this._segments) {
                for (char c : segment) {
                    if (c <= ' ') continue;
                    return false;
                }
            }
        }
        char[] buf = this._currentSegment;
        int len = this._currentSize;
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= ' ') continue;
            return false;
        }
        return true;
    }

    public int getCurrentLength() {
        return this._currentSize;
    }

    public void setCurrentLength(int len) {
        this._currentSize = len;
    }

    public char[] finishCurrentSegment() {
        if (this._segments == null) {
            this._segments = new ArrayList();
        }
        this._segments.add(this._currentSegment);
        int oldLen = this._currentSegment.length;
        this._segmentSize += oldLen;
        char[] curr = new char[this.calcNewSize(oldLen)];
        this._currentSize = 0;
        this._currentSegment = curr;
        return curr;
    }

    private int calcNewSize(int latestSize) {
        int incr = latestSize < 8000 ? latestSize : latestSize >> 1;
        int size = latestSize + incr;
        return Math.min(size, 262144);
    }

    public String toString() {
        this._resultString = null;
        this._resultArray = null;
        return this.contentsAsString();
    }

    private char[] allocBuffer() {
        int size = Math.max(500, 0);
        if (this._config != null) {
            char[] buf = this._config.allocMediumCBuffer(size);
            return buf;
        }
        return new char[size];
    }

    private char[] buildResultArray() {
        if (this._resultString != null) {
            return this._resultString.toCharArray();
        }
        int size = this.size();
        if (size < 1) {
            return sNoChars;
        }
        int offset = 0;
        char[] result = new char[size];
        if (this._segments != null) {
            for (char[] curr : this._segments) {
                int currLen = curr.length;
                System.arraycopy(curr, 0, result, offset, currLen);
                offset += currLen;
            }
        }
        System.arraycopy(this._currentSegment, 0, result, offset, this._currentSize);
        return result;
    }
}

