/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.headers;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.lang.index.HeaderAnchorIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.model.psi.MarkdownPsiSymbolReferenceBase;
import org.intellij.plugins.markdown.model.psi.headers.HeaderAnchorLinkDestinationReference$collectHtmlAnchorAttributesValues$;
import org.intellij.plugins.markdown.model.psi.headers.HeaderSymbol;
import org.intellij.plugins.markdown.model.psi.headers.html.HtmlAnchorSymbol;
import org.intellij.plugins.markdown.model.psi.headers.html.HtmlAnchorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorLinkDestinationReference;", "Lorg/intellij/plugins/markdown/model/psi/MarkdownPsiSymbolReferenceBase;", "Lcom/intellij/model/psi/PsiCompletableReference;", "element", "Lcom/intellij/psi/PsiElement;", "anchorRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "anchorText", "", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;Lcom/intellij/psi/PsiFile;)V", "resolveReference", "", "Lcom/intellij/model/Symbol;", "collectInjectedHtmlAnchors", "Lkotlin/sequences/Sequence;", "Lorg/intellij/plugins/markdown/model/psi/headers/html/HtmlAnchorSymbol;", "getCompletionVariants", "Lcom/intellij/codeInsight/lookup/LookupElement;", "collectHtmlAnchorAttributesValues", "Lcom/intellij/psi/xml/XmlAttributeValue;", "intellij.markdown.model"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nHeaderAnchorLinkDestinationReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderAnchorLinkDestinationReference.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorLinkDestinationReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,74:1\n1617#2,9:75\n1869#2:84\n1870#2:86\n1626#2:87\n1617#2,9:89\n1869#2:98\n1870#2:101\n1626#2:102\n1#3:85\n1#3:99\n1#3:100\n455#4:88\n477#5:103\n*S KotlinDebug\n*F\n+ 1 HeaderAnchorLinkDestinationReference.kt\norg/intellij/plugins/markdown/model/psi/headers/HeaderAnchorLinkDestinationReference\n*L\n33#1:75,9\n33#1:84\n33#1:86\n33#1:87\n46#1:89,9\n46#1:98\n46#1:101\n46#1:102\n33#1:85\n46#1:100\n45#1:88\n70#1:103\n*E\n"})
public final class HeaderAnchorLinkDestinationReference
extends MarkdownPsiSymbolReferenceBase
implements PsiCompletableReference {
    @NotNull
    private final String anchorText;
    @NotNull
    private final PsiFile file;

    public HeaderAnchorLinkDestinationReference(@NotNull PsiElement element2, @NotNull TextRange anchorRangeInElement, @NotNull String anchorText, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)anchorRangeInElement, (String)"anchorRangeInElement");
        Intrinsics.checkNotNullParameter((Object)anchorText, (String)"anchorText");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(element2, anchorRangeInElement);
        this.anchorText = anchorText;
        this.file = file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<Symbol> resolveReference() {
        void $this$mapNotNullTo$iv$iv;
        Project project = this.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        Collection<MarkdownHeader> headers = HeaderAnchorIndex.Companion.collectHeaders(project, globalSearchScope, this.anchorText);
        Iterable $this$mapNotNull$iv = headers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HeaderSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownHeader it = (MarkdownHeader)element$iv$iv;
            boolean bl2 = false;
            Pointer<HeaderSymbol> pointer = HeaderSymbol.Companion.createPointer(it);
            if ((pointer != null ? (HeaderSymbol)pointer.dereference() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List headerSymbols = (List)destination$iv$iv;
        Sequence<HtmlAnchorSymbol> injectedSymbols = this.collectInjectedHtmlAnchors();
        return CollectionsKt.plus((Collection)headerSymbols, injectedSymbols);
    }

    private final Sequence<HtmlAnchorSymbol> collectInjectedHtmlAnchors() {
        PsiFile psiFile = HtmlAnchorsKt.findInjectedHtmlFile(this.file);
        if (psiFile == null) {
            return SequencesKt.emptySequence();
        }
        PsiFile injectedFile = psiFile;
        Sequence htmlValues = SequencesKt.filter(this.collectHtmlAnchorAttributesValues(injectedFile), arg_0 -> HeaderAnchorLinkDestinationReference.collectInjectedHtmlAnchors$lambda$1(this, arg_0));
        return SequencesKt.map((Sequence)htmlValues, arg_0 -> HeaderAnchorLinkDestinationReference.collectInjectedHtmlAnchors$lambda$2(this, arg_0));
    }

    @NotNull
    public Collection<LookupElement> getCompletionVariants() {
        LookupElementBuilder lookup;
        Pair $this$mapNotNullTo$iv$iv2;
        PsiElement $this$childrenOfType$iv = (PsiElement)this.file;
        boolean $i$f$childrenOfType = false;
        List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, MarkdownHeader.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
        List headers = list2;
        Iterable $this$mapNotNull$iv = headers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownHeader header = (MarkdownHeader)element$iv$iv;
            boolean bl2 = false;
            if (header.getAnchorText() != null) {
                String it;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)it, (Object)header.getLevel());
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List anchors = (List)destination$iv$iv;
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (Pair $this$mapNotNullTo$iv$iv2 : anchors) {
            String anchorText = (String)$this$mapNotNullTo$iv$iv2.component1();
            int level = ((Number)$this$mapNotNullTo$iv$iv2.component2()).intValue();
            Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)anchorText).withIcon(MarkdownIcons.EditorActions.Link).withTypeText("H" + level, true), (String)"withTypeText(...)");
            result.add(lookup);
        }
        PsiFile injectedFile = HtmlAnchorsKt.findInjectedHtmlFile(this.file);
        if (injectedFile != null) {
            Sequence<XmlAttributeValue> values = this.collectHtmlAnchorAttributesValues(injectedFile);
            for (XmlAttributeValue value : values) {
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)value.getValue()).withIcon(PlatformIcons.XML_TAG_ICON).withTypeText("Anchor", true), (String)"withTypeText(...)");
                result.add(lookup);
            }
        }
        return result;
    }

    private final Sequence<XmlAttributeValue> collectHtmlAnchorAttributesValues(PsiFile file) {
        Sequence traverser;
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
        Sequence $this$filterIsInstance$iv = traverser = CollectionsKt.asSequence((Iterable)((Iterable)syntaxTraverser));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)collectHtmlAnchorAttributesValues$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence values = sequence;
        return SequencesKt.filter((Sequence)values, HeaderAnchorLinkDestinationReference::collectHtmlAnchorAttributesValues$lambda$5);
    }

    private static final boolean collectInjectedHtmlAnchors$lambda$1(HeaderAnchorLinkDestinationReference this$0, XmlAttributeValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getValue(), (Object)this$0.anchorText);
    }

    private static final HtmlAnchorSymbol collectInjectedHtmlAnchors$lambda$2(HeaderAnchorLinkDestinationReference this$0, XmlAttributeValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = this$0.file;
        TextRange textRange = it.getValueTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return new HtmlAnchorSymbol(psiFile, textRange, this$0.anchorText);
    }

    private static final boolean collectHtmlAnchorAttributesValues$lambda$5(XmlAttributeValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HtmlAnchorsKt.isValidAnchorAttributeValue(it);
    }
}

