/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.ast.PyAstDecoratorList;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecorator;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyAbstractClassInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyAbstractClassInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Visitor
    extends PyInspectionVisitor {
        private Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, context);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyClass pyClass;
            PyReferenceExpression calleeReferenceExpression;
            QualifiedResolveResult resolveResult;
            PsiElement psiElement;
            PyExpression pyExpression;
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((pyExpression = node.getCallee()) instanceof PyReferenceExpression && (psiElement = (resolveResult = (calleeReferenceExpression = (PyReferenceExpression)pyExpression).followAssignmentsChain(this.getResolveContext())).getElement()) instanceof PyClass && PyClassImpl.canHaveAbstractMethods(pyClass = (PyClass)psiElement, this.myTypeEvalContext)) {
                boolean hasAbstractMethod = ContainerUtil.exists((Object[])pyClass.getMethods(), method -> PyKnownDecoratorUtil.hasAbstractDecorator(method, this.myTypeEvalContext));
                if (hasAbstractMethod || !this.getAllSuperAbstractMethods(pyClass).isEmpty()) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.abstract.class.cannot.instantiate.abstract.class", pyClass.getName()), ProblemHighlightType.WARNING);
                } else if (this.isAbstract(pyClass)) {
                    this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.abstract.class.cannot.instantiate.abstract.class", pyClass.getName()));
                }
            }
        }

        @Override
        public void visitPyClass(@NotNull PyClass pyClass) {
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (this.isAbstract(pyClass) || PyProtocolsKt.isProtocol(pyClass, this.myTypeEvalContext)) {
                return;
            }
            ArrayList<PyDecorator> abstractDecorators = new ArrayList<PyDecorator>();
            for (PyFunction method : pyClass.getMethods()) {
                PyAstDecoratorList decoratorList = method.getDecoratorList();
                if (decoratorList == null) continue;
                for (PyDecorator decorator : decoratorList.getDecorators()) {
                    boolean isAbstract = ContainerUtil.exists(PyKnownDecoratorUtil.asKnownDecorators(decorator, this.myTypeEvalContext), PyKnownDecorator::isAbstract);
                    if (!isAbstract) continue;
                    abstractDecorators.add(decorator);
                }
            }
            if (!PyClassImpl.canHaveAbstractMethods(pyClass, this.myTypeEvalContext)) {
                for (PyDecorator decorator : abstractDecorators) {
                    SmartList quickFixes = new SmartList();
                    Visitor.addMakeClassAbstractFixes(pyClass, (Collection<LocalQuickFix>)quickFixes);
                    this.registerProblem((PsiElement)decorator, PyPsiBundle.message("INSP.abstract.class.abstract.methods.are.allowed.in.classes.whose.metaclass.is.abcmeta", new Object[0]), (LocalQuickFix[])quickFixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY));
                }
            }
            if (abstractDecorators.isEmpty()) {
                List<PyFunction> toImplement = this.getAllSuperAbstractMethods(pyClass);
                ASTNode nameNode = pyClass.getNameNode();
                if (!toImplement.isEmpty() && nameNode != null) {
                    SmartList quickFixes = new SmartList();
                    LocalQuickFix qf = PythonUiService.getInstance().createPyImplementMethodsQuickFix(pyClass, toImplement);
                    if (qf != null) {
                        quickFixes.add((Object)qf);
                    }
                    Visitor.addMakeClassAbstractFixes(pyClass, (Collection<LocalQuickFix>)quickFixes);
                    this.registerProblem(nameNode.getPsi(), PyPsiBundle.message("INSP.abstract.class.class.must.implement.all.abstract.methods", pyClass.getName()), (LocalQuickFix[])quickFixes.toArray((Object[])LocalQuickFix.EMPTY_ARRAY));
                }
            }
        }

        private boolean isAbstract(@NotNull PyClass pyClass) {
            PyClassLikeType metaClass;
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if ((metaClass = pyClass.getMetaClassType(false, this.myTypeEvalContext)) != null && "ABCMeta".equals(metaClass.getName())) {
                return true;
            }
            for (PyClassLikeType superClassType : pyClass.getSuperClassTypes(this.myTypeEvalContext)) {
                if (superClassType == null || !"abc.ABC".equals(superClassType.getClassQName())) continue;
                return true;
            }
            return false;
        }

        @NotNull
        private List<PyFunction> getAllSuperAbstractMethods(@NotNull PyClass pyClass) {
            if (pyClass == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            List list = ContainerUtil.filter(PyPsiRefactoringUtil.getAllSuperAbstractMethods(pyClass, this.myTypeEvalContext), function -> PyKnownDecoratorUtil.hasAbstractDecorator(function, this.myTypeEvalContext));
            if (list == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static void addMakeClassAbstractFixes(@NotNull PsiElement element, @NotNull Collection<LocalQuickFix> fixes) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (fixes == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            fixes.add((LocalQuickFix)new SetABCMetaAsMetaclassQuickFix());
            if (LanguageLevel.forElement(element).isPy3K()) {
                fixes.add((LocalQuickFix)new AddABCToSuperclassesQuickFix());
            }
        }

        @Nullable
        private static PyClass getPyClass(@NotNull PsiElement element) {
            PsiElement psiElement;
            if (element == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            if ((psiElement = element.getParent()) instanceof PyClass) {
                PyClass pyClass = (PyClass)psiElement;
                return pyClass;
            }
            if (element instanceof PyDecorator) {
                PyDecorator decorator = (PyDecorator)element;
                return Optional.ofNullable(decorator.getTarget()).map(PyFunction::getContainingClass).orElse(null);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pyClass";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllSuperAbstractMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAbstract";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllSuperAbstractMethods";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addMakeClassAbstractFixes";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getPyClass";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }

        private static class SetABCMetaAsMetaclassQuickFix
        extends PsiUpdateModCommandQuickFix {
            private SetABCMetaAsMetaclassQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                String string = PyPsiBundle.message("INSP.abstract.class.set.as.metaclass", "abc.ABCMeta");
                if (string == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                PyClass cls;
                if (project == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    SetABCMetaAsMetaclassQuickFix.$$$reportNull$$$0(3);
                }
                if ((cls = Visitor.getPyClass(element)) == null) {
                    return;
                }
                PyClass abcMetaClass = PyPsiFacade.getInstance(project).createClassByQName("abc.ABCMeta", cls);
                if (abcMetaClass == null) {
                    return;
                }
                TypeEvalContext context = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile());
                PyPsiRefactoringUtil.addMetaClassIfNotExist(cls, abcMetaClass, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$SetABCMetaAsMetaclassQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }

        private static class AddABCToSuperclassesQuickFix
        extends PsiUpdateModCommandQuickFix {
            private AddABCToSuperclassesQuickFix() {
            }

            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                String string = PyPsiBundle.message("INSP.abstract.class.add.to.superclasses", "abc.ABC");
                if (string == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                PyClass cls;
                if (project == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(1);
                }
                if (element == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(2);
                }
                if (updater == null) {
                    AddABCToSuperclassesQuickFix.$$$reportNull$$$0(3);
                }
                if ((cls = Visitor.getPyClass(element)) == null) {
                    return;
                }
                PyClass abcClass = PyPsiFacade.getInstance(project).createClassByQName("abc.ABC", cls);
                if (abcClass == null) {
                    return;
                }
                PyPsiRefactoringUtil.addSuperclasses(project, cls, abcClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/inspections/PyAbstractClassInspection$Visitor$AddABCToSuperclassesQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3 -> new IllegalArgumentException(string);
                };
            }
        }
    }
}

