/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AugmentedAssignmentQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.augment.assignment", new Object[0]);
        if (string == null) {
            AugmentedAssignmentQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            AugmentedAssignmentQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            AugmentedAssignmentQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            AugmentedAssignmentQuickFix.$$$reportNull$$$0(3);
        }
        if (element instanceof PyAssignmentStatement) {
            PyAssignmentStatement statement = (PyAssignmentStatement)element;
            if (element.isWritable()) {
                PyExpression target = statement.getLeftHandSideExpression();
                PyBinaryExpression expression = (PyBinaryExpression)statement.getAssignedValue();
                if (expression == null) {
                    return;
                }
                PyExpression leftExpression = expression.getLeftExpression();
                PyExpression rightExpression = expression.getRightExpression();
                if (rightExpression instanceof PyParenthesizedExpression) {
                    rightExpression = ((PyParenthesizedExpression)rightExpression).getContainedExpression();
                }
                if (target != null && rightExpression != null) {
                    String targetText = target.getText();
                    String rightText = rightExpression.getText();
                    if (rightText.equals(targetText)) {
                        PyExpression tmp = rightExpression;
                        rightExpression = leftExpression;
                        leftExpression = tmp;
                    }
                    List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement, PsiComment.class);
                    if ((leftExpression instanceof PyReferenceExpression || leftExpression instanceof PySubscriptionExpression) && leftExpression.getText().equals(targetText)) {
                        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                        StringBuilder stringBuilder = new StringBuilder();
                        PsiElement psiOperator = expression.getPsiOperator();
                        if (psiOperator == null) {
                            return;
                        }
                        stringBuilder.append(targetText).append(" ").append(psiOperator.getText()).append("= ").append(rightExpression.getText());
                        PyAugAssignmentStatementImpl augAssignment = elementGenerator.createFromText(LanguageLevel.forElement(element), PyAugAssignmentStatementImpl.class, stringBuilder.toString());
                        for (PsiComment comment : comments) {
                            augAssignment.add((PsiElement)comment);
                        }
                        statement.replace((PsiElement)augAssignment);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AugmentedAssignmentQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AugmentedAssignmentQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

