/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstExpressionStatement;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstPassStatement;
import com.jetbrains.python.ast.PyAstStatementList;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class PyAstElementGenerator {
    private final Project myProject;
    static final int[] FROM_ROOT = new int[]{0};

    public static PyAstElementGenerator getInstance(Project project) {
        return (PyAstElementGenerator)project.getService(PyAstElementGenerator.class);
    }

    protected PyAstElementGenerator(Project project) {
        this.myProject = project;
    }

    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text) {
        T t = this.createFromText(langLevel, aClass, text, FROM_ROOT);
        if (t == null) {
            PyAstElementGenerator.$$$reportNull$$$0(0);
        }
        return t;
    }

    @NotNull
    public <T> T createPhysicalFromText(LanguageLevel langLevel, Class<T> aClass, String text) {
        return this.createFromText(langLevel, aClass, text, FROM_ROOT, true);
    }

    @NotNull
    public <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text, int[] path2) {
        return this.createFromText(langLevel, aClass, text, path2, false);
    }

    @NotNull
    private <T> T createFromText(LanguageLevel langLevel, Class<T> aClass, String text, int[] path2, boolean physical) {
        PsiFile ret = this.createDummyFile(langLevel, text, physical);
        block0: for (int skip : path2) {
            if (ret == null) break;
            ret = ret.getFirstChild();
            for (int i = 0; i < skip; ++i) {
                if (ret == null) {
                    ret = null;
                    continue block0;
                }
                ret = ret.getNextSibling();
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("Can't find element matching path " + Arrays.toString(path2) + " in text '" + text + "'");
        }
        if (aClass.isInstance(ret)) {
            PsiFile psiFile = ret;
            if (psiFile == null) {
                PyAstElementGenerator.$$$reportNull$$$0(1);
            }
            return (T)psiFile;
        }
        throw new IllegalArgumentException("Can't create an element of type " + String.valueOf(aClass) + " from text '" + text + "', got " + String.valueOf(ret.getClass()) + " instead");
    }

    public PsiFile createDummyFile(LanguageLevel langLevel, String contents) {
        return this.createDummyFile(langLevel, contents, false);
    }

    @NotNull
    public static String getDummyFileName() {
        String string = "dummy." + PythonFileType.INSTANCE.getDefaultExtension();
        if (string == null) {
            PyAstElementGenerator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private PsiFile createDummyFile(LanguageLevel langLevel, String contents, boolean physical) {
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        String name2 = PyAstElementGenerator.getDummyFileName();
        LightVirtualFile virtualFile = new LightVirtualFile(name2, (FileType)PythonFileType.INSTANCE, (CharSequence)contents);
        this.specifyFileLanguageLevel((VirtualFile)virtualFile, langLevel);
        PsiFile psiFile = ((PsiFileFactoryImpl)factory).trySetupPsiForFile(virtualFile, (Language)PythonLanguage.getInstance(), physical, true);
        assert (psiFile != null);
        return psiFile;
    }

    public ASTNode createComma() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "[0,]");
        PyAstExpressionStatement expressionStatement = (PyAstExpressionStatement)dummyFile.getFirstChild();
        ASTNode zero = expressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return zero.getTreeNext().copyElement();
    }

    public PyAstExpressionStatement createDocstring(String content) {
        return this.createFromText(LanguageLevel.getDefault(), PyAstExpressionStatement.class, content + "\n");
    }

    public PyAstPassStatement createPassStatement() {
        PyAstFunction function = this.createFromText(LanguageLevel.getDefault(), PyAstFunction.class, "def foo():\n\tpass");
        PyAstStatementList statementList = function.getStatementList();
        return (PyAstPassStatement)statementList.getStatements()[0];
    }

    protected void specifyFileLanguageLevel(@NotNull VirtualFile virtualFile, @Nullable LanguageLevel langLevel) {
        if (virtualFile == null) {
            PyAstElementGenerator.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    public PyAstExpression createExpressionFromText(@NotNull LanguageLevel languageLevel, @NotNull String text) throws IncorrectOperationException {
        PsiFile dummyFile;
        PsiElement element;
        if (languageLevel == null) {
            PyAstElementGenerator.$$$reportNull$$$0(4);
        }
        if (text == null) {
            PyAstElementGenerator.$$$reportNull$$$0(5);
        }
        if ((element = (dummyFile = this.createDummyFile(languageLevel, text)).getFirstChild()) instanceof PyAstExpressionStatement) {
            PyAstExpressionStatement expressionStatement = (PyAstExpressionStatement)element;
            PyAstExpression pyAstExpression = expressionStatement.getExpression();
            if (pyAstExpression == null) {
                PyAstElementGenerator.$$$reportNull$$$0(6);
            }
            return pyAstExpression;
        }
        throw new IncorrectOperationException("could not parse text as expression: " + text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyAstElementGenerator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDummyFileName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyAstElementGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionFromText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "specifyFileLanguageLevel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

