/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.AbstractFilesScope;
import com.intellij.psi.search.FileScope;
import com.intellij.psi.search.FileTypeRestrictionScope;
import com.intellij.psi.search.FileWeakScope;
import com.intellij.psi.search.FilesScopeWithDisplayName;
import com.intellij.psi.search.GlobalAndLocalUnionScope;
import com.intellij.psi.search.IntersectionScope;
import com.intellij.psi.search.LazyFilesScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.NotScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UnionScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    public static final GlobalSearchScope[] EMPTY_ARRAY = new GlobalSearchScope[0];
    private final Project myProject;
    private static final Key<Boolean> USE_WEAK_FILE_SCOPE = Key.create("virtual.file.use.weak.scope");
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @ApiStatus.NonExtendable
    public Project getProject() {
        return this.myProject;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            GlobalSearchScope.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(1);
        }
        return 0;
    }

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            GlobalSearchScope.$$$reportNull$$$0(2);
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(@NotNull VirtualFile file) {
        if (file == null) {
            GlobalSearchScope.$$$reportNull$$$0(3);
        }
        return this.contains(file);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    public @Unmodifiable @NotNull Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Set<UnloadedModuleDescription> set = Collections.emptySet();
        if (set == null) {
            GlobalSearchScope.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(5);
        }
        return this.defaultIntersectWith(scope);
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    @NotNull
    protected final GlobalSearchScope defaultIntersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(6);
        }
        if (scope == this) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        if (scope instanceof IntersectionScope && ((IntersectionScope)scope).containsScope(this)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        return new IntersectionScope(this, scope);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(9);
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localSearchScope = this.intersectWith((LocalSearchScope)scope2);
            if (localSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(10);
            }
            return localSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(12);
        }
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result.add(element2);
        }
        return result.isEmpty() ? LocalSearchScope.EMPTY : new LocalSearchScope(result.toArray(PsiElement.EMPTY_ARRAY), null, localScope2.isIgnoreInjectedPsi());
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(13);
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = this.uniteWith((GlobalSearchScope)scope);
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(14);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.union((LocalSearchScope)scope);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope union(@NotNull LocalSearchScope scope) {
        PsiElement[] localScopeElements;
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(16);
        }
        if ((localScopeElements = scope.getScope()).length == 0) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(17);
            }
            return globalSearchScope;
        }
        return new GlobalAndLocalUnionScope(this, scope, localScopeElements[0].getProject());
    }

    @Contract(pure=true)
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(18);
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(new GlobalSearchScope[]{this, scope});
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope union(@NotNull Collection<? extends GlobalSearchScope> scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(20);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("Empty scope collection");
        }
        if (scopes.size() == 1) {
            GlobalSearchScope globalSearchScope = scopes.iterator().next();
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(21);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes.toArray(EMPTY_ARRAY));
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(22);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope union(GlobalSearchScope @NotNull [] scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(23);
        }
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            GlobalSearchScope globalSearchScope = scopes[0];
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(24);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(25);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(26);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(28);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(29);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope everythingScope(@NotNull Project project) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(30);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getEverythingScope(project);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(31);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(32);
        }
        return new NotScope(scope);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(33);
        }
        GlobalSearchScope globalSearchScope = module.getModuleScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(34);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(35);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(36);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(37);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(38);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(39);
        }
        GlobalSearchScope globalSearchScope = module.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(40);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(41);
        }
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(42);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(43);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(44);
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(45);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            GlobalSearchScope.$$$reportNull$$$0(46);
        }
        GlobalSearchScope globalSearchScope = module.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(47);
        }
        return globalSearchScope;
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GlobalSearchScope.$$$reportNull$$$0(48);
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return new FileScope(psiFile.getProject(), virtualFile != null ? BackedVirtualFile.getOriginFileIfBacked(virtualFile) : null, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(49);
        }
        return GlobalSearchScope.fileScope(project, virtualFile, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, @Nullable VirtualFile virtualFile, @Nullable @Nls String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(50);
        }
        if (virtualFile != null && virtualFile.getUserData(USE_WEAK_FILE_SCOPE) == Boolean.TRUE) {
            return new FileWeakScope(project, virtualFile, displayName);
        }
        return new FileScope(project, virtualFile, displayName);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(51);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(52);
        }
        return GlobalSearchScope.filesScope(project, files, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Supplier<? extends Collection<? extends VirtualFile>> files) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(53);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(54);
        }
        return new LazyFilesScope(project, files);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(55);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(56);
        }
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(57);
            }
            return globalSearchScope;
        }
        return new FilesScope(project, files, false);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(58);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(59);
        }
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(60);
            }
            return globalSearchScope;
        }
        return new FilesScope(project, files, true);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<? extends VirtualFile> files, @Nullable @Nls String displayName) {
        if (project == null) {
            GlobalSearchScope.$$$reportNull$$$0(61);
        }
        if (files == null) {
            GlobalSearchScope.$$$reportNull$$$0(62);
        }
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(63);
            }
            return globalSearchScope;
        }
        if (files.size() == 1) {
            return GlobalSearchScope.fileScope(project, files.iterator().next(), displayName);
        }
        if (displayName != null) {
            return new FilesScopeWithDisplayName(project, files, displayName);
        }
        return new FilesScope(project, files, null);
    }

    @Contract(pure=true)
    @NotNull
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(64);
        }
        if (fileTypes == null) {
            GlobalSearchScope.$$$reportNull$$$0(65);
        }
        if (scope == EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(66);
            }
            return globalSearchScope;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        return new FileTypeRestrictionScope(scope, fileTypes);
    }

    @ApiStatus.Internal
    public static void markFileForWeakScope(@NotNull VirtualFile file) {
        if (file == null) {
            GlobalSearchScope.$$$reportNull$$$0(67);
        }
        file.putUserData(USE_WEAK_FILE_SCOPE, Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 57: 
            case 60: 
            case 63: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 57: 
            case 60: 
            case 63: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 3: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 57: 
            case 60: 
            case 63: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 16: 
            case 18: 
            case 32: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localScope2";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 52: 
            case 54: 
            case 56: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultIntersectWith";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "projectScope";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "everythingScope";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleScope";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithLibrariesScope";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesScope";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleRuntimeScope";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependentsScope";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleTestsWithDependentsScope";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithoutLibrariesScope";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithLibrariesScope";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "filesScope";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 57: 
            case 60: 
            case 63: 
            case 66: {
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "defaultIntersectWith";
                break;
            }
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "allScope";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "projectScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "everythingScope";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "notScope";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "moduleScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithLibrariesScope";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesScope";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "moduleRuntimeScope";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependentsScope";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "moduleTestsWithDependentsScope";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fileScope";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "filesScope";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "filesWithoutLibrariesScope";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "filesWithLibrariesScope";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getScopeRestrictedByFileTypes";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "markFileForWeakScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 57: 
            case 60: 
            case 63: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilesScope
    extends AbstractFilesScope {
        private final VirtualFileSet myFiles;

        @ApiStatus.Internal
        FilesScope(@Nullable Project project, @NotNull Collection<? extends VirtualFile> files, @Nullable Boolean hasFilesOutOfProjectRoots) {
            if (files == null) {
                FilesScope.$$$reportNull$$$0(0);
            }
            super(project, hasFilesOutOfProjectRoots);
            this.myFiles = VfsUtilCore.createCompactVirtualFileSet(files);
            this.myFiles.freeze();
        }

        @Override
        @NotNull
        public VirtualFileSet getFiles() {
            VirtualFileSet virtualFileSet = this.myFiles;
            if (virtualFileSet == null) {
                FilesScope.$$$reportNull$$$0(1);
            }
            return virtualFileSet;
        }

        public String toString() {
            return "Files: [" + StringUtil.join(this.myFiles, ", ") + "]; search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                EmptyScope.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                EmptyScope.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(2);
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                EmptyScope.$$$reportNull$$$0(3);
            }
            return emptyScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(4);
            }
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                EmptyScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }

        public String toString() {
            return "EMPTY";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

