/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsTreeModelData {
    @NotNull
    public static VcsTreeModelData all(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(0);
        }
        return VcsTreeModelData.all(tree.getModel());
    }

    @NotNull
    public static VcsTreeModelData all(@NotNull TreeModel model) {
        if (model == null) {
            VcsTreeModelData.$$$reportNull$$$0(1);
        }
        assert (model.getRoot() instanceof ChangesBrowserNode);
        return new AllUnderData((ChangesBrowserNode)model.getRoot());
    }

    @NotNull
    public static VcsTreeModelData selected(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(2);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData exactlySelected(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(3);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new ExactlySelectedData(tree);
    }

    @NotNull
    public static VcsTreeModelData included(@NotNull ChangesTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(4);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        Set<Object> includedSet = tree.getIncludedSet();
        return new IncludedUnderData(includedSet, VcsTreeModelData.getRoot((JTree)((Object)tree)));
    }

    @NotNull
    public static VcsTreeModelData allUnderTag(@NotNull JTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(5);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(6);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode(tree, tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        return new AllUnderData(tagNode);
    }

    @NotNull
    public static VcsTreeModelData allUnder(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            VcsTreeModelData.$$$reportNull$$$0(7);
        }
        return new AllUnderData(node);
    }

    @NotNull
    public static VcsTreeModelData selectedUnderTag(@NotNull JTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(8);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(9);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        return new SelectedTagData(tree, tag);
    }

    @NotNull
    public static VcsTreeModelData includedUnderTag(@NotNull ChangesTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(10);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(11);
        }
        assert (tree.getModel().getRoot() instanceof ChangesBrowserNode);
        ChangesBrowserNode<?> tagNode = VcsTreeModelData.findTagNode((JTree)((Object)tree), tag);
        if (tagNode == null) {
            return new EmptyData();
        }
        Set<Object> includedSet = tree.getIncludedSet();
        return new IncludedUnderData(includedSet, tagNode);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final Stream<ChangesBrowserNode<?>> nodesStream() {
        Stream stream = this.iterateNodes().toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(12);
        }
        return stream;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final <U> Stream<U> userObjectsStream(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(13);
        }
        Stream stream = this.iterateUserObjects(clazz).toStream();
        if (stream == null) {
            VcsTreeModelData.$$$reportNull$$$0(14);
        }
        return stream;
    }

    @NotNull
    public abstract JBIterable<ChangesBrowserNode<?>> iterateRawNodes();

    @NotNull
    public final JBIterable<ChangesBrowserNode<?>> iterateNodes() {
        JBIterable jBIterable = this.iterateRawNodes().filter(ChangesBrowserNode::isMeaningfulNode);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<Object> iterateRawUserObjects() {
        JBIterable jBIterable = this.iterateRawNodes().map(ChangesBrowserNode::getUserObject);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    public final <U> JBIterable<U> iterateRawUserObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(17);
        }
        JBIterable jBIterable = this.iterateRawNodes().map(ChangesBrowserNode::getUserObject).filter(clazz);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<Object> iterateUserObjects() {
        JBIterable jBIterable = this.iterateNodes().map(ChangesBrowserNode::getUserObject);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    @NotNull
    public final <U> JBIterable<U> iterateUserObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(20);
        }
        JBIterable jBIterable = this.iterateNodes().map(ChangesBrowserNode::getUserObject).filter(clazz);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    @NotNull
    public final List<Object> userObjects() {
        List list = this.iterateUserObjects().toList();
        if (list == null) {
            VcsTreeModelData.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public final <U> List<U> userObjects(@NotNull Class<U> clazz) {
        if (clazz == null) {
            VcsTreeModelData.$$$reportNull$$$0(23);
        }
        List list = this.iterateUserObjects(clazz).toList();
        if (list == null) {
            VcsTreeModelData.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public static ListSelection<Object> getListSelectionOrAll(@NotNull JTree tree) {
        List<Object> entries;
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(25);
        }
        if ((entries = VcsTreeModelData.selected(tree).userObjects()).size() > 1) {
            ListSelection listSelection = ListSelection.createAt(entries, (int)0).asExplicitSelection();
            if (listSelection == null) {
                VcsTreeModelData.$$$reportNull$$$0(26);
            }
            return listSelection;
        }
        ChangesBrowserNode selected = (ChangesBrowserNode)VcsTreeModelData.selected(tree).iterateNodes().first();
        List<Object> allEntries = VcsTreeModelData.underExpandByDefault(selected) ? new AllExpandedByDefaultData(VcsTreeModelData.getRoot(tree)).userObjects() : VcsTreeModelData.all(tree).userObjects();
        if (allEntries.size() <= entries.size()) {
            ListSelection listSelection = ListSelection.createAt(entries, (int)0).asExplicitSelection();
            if (listSelection == null) {
                VcsTreeModelData.$$$reportNull$$$0(27);
            }
            return listSelection;
        }
        int index = selected != null ? ContainerUtil.indexOfIdentity(allEntries, selected.getUserObject()) : 0;
        ListSelection listSelection = ListSelection.createAt(allEntries, (int)index);
        if (listSelection == null) {
            VcsTreeModelData.$$$reportNull$$$0(28);
        }
        return listSelection;
    }

    public static void uiDataSnapshot(@NotNull DataSink sink, @Nullable Project project, @NotNull JTree tree) {
        if (sink == null) {
            VcsTreeModelData.$$$reportNull$$$0(29);
        }
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(30);
        }
        sink.set(CommonDataKeys.PROJECT, (Object)project);
        Change[] changes = (Change[])VcsTreeModelData.mapToChange(VcsTreeModelData.selected(tree)).toArray((Object[])Change.EMPTY_CHANGE_ARRAY);
        sink.set(VcsDataKeys.CHANGES, (Object)(changes.length != 0 ? changes : (Change[])VcsTreeModelData.mapToChange(VcsTreeModelData.all(tree)).toArray((Object[])Change.EMPTY_CHANGE_ARRAY)));
        sink.set(VcsDataKeys.SELECTED_CHANGES, (Object)changes);
        sink.set(VcsDataKeys.SELECTED_CHANGES_IN_DETAILS, (Object)changes);
        sink.set(VcsDataKeys.CHANGES_SELECTION, (Object)VcsTreeModelData.getListSelectionOrAll(tree).map(entry -> (Change)ObjectUtils.tryCast((Object)entry, Change.class)));
        sink.set(VcsDataKeys.CHANGE_LEAD_SELECTION, (Object)((Change[])VcsTreeModelData.mapToChange(VcsTreeModelData.exactlySelected(tree)).toArray((Object[])Change.EMPTY_CHANGE_ARRAY)));
        sink.set(VcsDataKeys.FILE_PATHS, VcsTreeModelData.mapToFilePath(VcsTreeModelData.selected(tree)));
        VcsTreeModelData treeSelection = VcsTreeModelData.selected(tree);
        VcsTreeModelData exactSelection = VcsTreeModelData.exactlySelected(tree);
        sink.lazy(SelectInContext.DATA_KEY, () -> {
            if (project == null) {
                return null;
            }
            VirtualFile file = (VirtualFile)VcsTreeModelData.mapObjectToVirtualFile(exactSelection.iterateRawUserObjects()).first();
            if (file == null) {
                return null;
            }
            return new FileSelectInContext(project, file, null);
        });
        sink.lazy(VcsDataKeys.VIRTUAL_FILES, () -> VcsTreeModelData.mapToVirtualFile(treeSelection));
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> VcsTreeModelData.findSelectedVirtualFile(tree));
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> (VirtualFile[])VcsTreeModelData.mapToVirtualFile(treeSelection).toArray((Object[])VirtualFile.EMPTY_ARRAY));
        if (project != null) {
            sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> ChangesUtil.getNavigatableArray((Project)project, VcsTreeModelData.mapToNavigatableFile(treeSelection)));
        }
    }

    @NotNull
    private static JBIterable<Change> mapToChange(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(31);
        }
        JBIterable jBIterable = data.iterateUserObjects().filter(Change.class);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(32);
        }
        return jBIterable;
    }

    @NotNull
    static JBIterable<VirtualFile> mapToNavigatableFile(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(33);
        }
        JBIterable jBIterable = data.iterateUserObjects().flatMap(entry -> {
            if (entry instanceof Change) {
                return ChangesUtil.iteratePathsCaseSensitive((Change)((Change)entry)).map(FilePath::getVirtualFile);
            }
            if (entry instanceof VirtualFile) {
                return JBIterable.of((Object)((VirtualFile)entry));
            }
            if (entry instanceof FilePath) {
                return JBIterable.of((Object)((FilePath)entry).getVirtualFile());
            }
            return JBIterable.empty();
        }).filterNotNull().filter(VirtualFile::isValid);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(34);
        }
        return jBIterable;
    }

    @Nullable
    static VirtualFile findSelectedVirtualFile(@NotNull JTree tree) {
        TreePath leadSelectionPath;
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(35);
        }
        if ((leadSelectionPath = tree.getLeadSelectionPath()) == null) {
            return null;
        }
        return VcsTreeModelData.treePathToVirtualFile(leadSelectionPath);
    }

    @Nullable
    private static VirtualFile treePathToVirtualFile(@NotNull TreePath path) {
        VirtualFile virtualFile;
        if (path == null) {
            VcsTreeModelData.$$$reportNull$$$0(36);
        }
        if ((virtualFile = VcsTreeModelData.objectToVirtualFile(((ChangesBrowserNode)path.getLastPathComponent()).getUserObject())) == null || !virtualFile.isValid()) {
            return null;
        }
        return virtualFile;
    }

    @NotNull
    static JBIterable<VirtualFile> mapToVirtualFile(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(37);
        }
        return VcsTreeModelData.mapObjectToVirtualFile(data.iterateUserObjects());
    }

    @NotNull
    static JBIterable<VirtualFile> mapObjectToVirtualFile(@NotNull JBIterable<Object> userObjects) {
        if (userObjects == null) {
            VcsTreeModelData.$$$reportNull$$$0(38);
        }
        JBIterable jBIterable = userObjects.map(VcsTreeModelData::objectToVirtualFile).filterNotNull().filter(VirtualFile::isValid);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(39);
        }
        return jBIterable;
    }

    @Nullable
    private static VirtualFile objectToVirtualFile(@Nullable Object userObject) {
        if (userObject instanceof Change) {
            FilePath path = ChangesUtil.getAfterPath((Change)((Change)userObject));
            return path != null ? path.getVirtualFile() : null;
        }
        if (userObject instanceof VirtualFile) {
            return (VirtualFile)userObject;
        }
        if (userObject instanceof FilePath) {
            return ((FilePath)userObject).getVirtualFile();
        }
        return null;
    }

    @NotNull
    static JBIterable<FilePath> mapToFilePath(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(40);
        }
        JBIterable jBIterable = data.iterateUserObjects().map(VcsTreeModelData::mapUserObjectToFilePath).filterNotNull();
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(41);
        }
        return jBIterable;
    }

    @Nullable
    public static FilePath mapUserObjectToFilePath(@Nullable Object userObject) {
        if (userObject instanceof Change) {
            Change change = (Change)userObject;
            return ChangesUtil.getFilePath((Change)change);
        }
        if (userObject instanceof VirtualFile) {
            VirtualFile file = (VirtualFile)userObject;
            return VcsUtil.getFilePath((VirtualFile)file);
        }
        if (userObject instanceof FilePath) {
            FilePath filePath = (FilePath)userObject;
            return filePath;
        }
        return null;
    }

    @NotNull
    public static JBIterable<VirtualFile> mapToExactVirtualFile(@NotNull VcsTreeModelData data) {
        if (data == null) {
            VcsTreeModelData.$$$reportNull$$$0(42);
        }
        JBIterable jBIterable = data.iterateUserObjects().map(object -> {
            if (object instanceof VirtualFile) {
                return (VirtualFile)object;
            }
            if (object instanceof FilePath) {
                return ((FilePath)object).getVirtualFile();
            }
            return null;
        }).filterNotNull().filter(VirtualFile::isValid);
        if (jBIterable == null) {
            VcsTreeModelData.$$$reportNull$$$0(43);
        }
        return jBIterable;
    }

    @Nullable
    public static ChangesBrowserNode<?> findTagNode(@NotNull JTree tree, @NotNull Object tag) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(44);
        }
        if (tag == null) {
            VcsTreeModelData.$$$reportNull$$$0(45);
        }
        ChangesBrowserNode root = (ChangesBrowserNode)tree.getModel().getRoot();
        return (ChangesBrowserNode)root.iterateNodeChildren().find(node -> tag.equals(node.getUserObject()));
    }

    private static boolean underExpandByDefault(@Nullable ChangesBrowserNode<?> node) {
        while (node != null) {
            if (!node.shouldExpandByDefault()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    @NotNull
    private static ChangesBrowserNode<?> getRoot(@NotNull JTree tree) {
        if (tree == null) {
            VcsTreeModelData.$$$reportNull$$$0(46);
        }
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)tree.getModel().getRoot();
        if (changesBrowserNode == null) {
            VcsTreeModelData.$$$reportNull$$$0(47);
        }
        return changesBrowserNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 15, 16, 18, 19, 21, 22, 24, 26, 27, 28, 32, 34, 39, 41, 43, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 13: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 31: 
            case 33: 
            case 37: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesStream";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjectsStream";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNodes";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateRawUserObjects";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateUserObjects";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "userObjects";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelectionOrAll";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToChange";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToNavigatableFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "mapObjectToVirtualFile";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToFilePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToExactVirtualFile";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selected";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exactlySelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "included";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allUnderTag";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "allUnder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectedUnderTag";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "includedUnderTag";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 39: 
            case 41: 
            case 43: 
            case 47: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "userObjectsStream";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "iterateRawUserObjects";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "iterateUserObjects";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "userObjects";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getListSelectionOrAll";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mapToChange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "mapToNavigatableFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findSelectedVirtualFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "treePathToVirtualFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "mapToVirtualFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "mapObjectToVirtualFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "mapToFilePath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "mapToExactVirtualFile";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findTagNode";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 15, 16, 18, 19, 21, 22, 24, 26, 27, 28, 32, 34, 39, 41, 43, 47 -> new IllegalStateException(string);
        };
    }

    private static class AllUnderData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllUnderData(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                AllUnderData.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable<ChangesBrowserNode<?>> jBIterable = this.myNode.traverse();
            if (jBIterable == null) {
                AllUnderData.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllUnderData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class SelectedData
    extends ExactlySelectedData {
        SelectedData(@NotNull JTree tree) {
            if (tree == null) {
                SelectedData.$$$reportNull$$$0(0);
            }
            super(tree);
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = super.iterateRawNodes().flatMap(ChangesBrowserNode::traverse).unique();
            if (jBIterable == null) {
                SelectedData.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ExactlySelectedData
    extends VcsTreeModelData {
        private final TreePath[] myPaths;

        ExactlySelectedData(@NotNull JTree tree) {
            if (tree == null) {
                ExactlySelectedData.$$$reportNull$$$0(0);
            }
            this.myPaths = tree.getSelectionPaths();
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            Object[] paths = this.myPaths;
            if (paths == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ExactlySelectedData.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.of((Object[])paths).map(path -> (ChangesBrowserNode)path.getLastPathComponent());
            if (jBIterable == null) {
                ExactlySelectedData.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class IncludedUnderData
    extends VcsTreeModelData {
        private final ChangesBrowserNode<?> myNode;
        private final Set<Object> myIncluded;

        IncludedUnderData(@NotNull Set<Object> includedSet, @NotNull ChangesBrowserNode<?> node) {
            if (includedSet == null) {
                IncludedUnderData.$$$reportNull$$$0(0);
            }
            if (node == null) {
                IncludedUnderData.$$$reportNull$$$0(1);
            }
            this.myNode = node;
            this.myIncluded = includedSet;
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = this.myNode.traverse().filter(node -> this.myIncluded.contains(node.getUserObject()));
            if (jBIterable == null) {
                IncludedUnderData.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includedSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$IncludedUnderData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class EmptyData
    extends VcsTreeModelData {
        EmptyData() {
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                EmptyData.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$EmptyData", "iterateRawNodes"));
        }
    }

    private static class SelectedTagData
    extends ExactlySelectedTagData {
        SelectedTagData(@NotNull JTree tree, @NotNull Object tag) {
            if (tree == null) {
                SelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                SelectedTagData.$$$reportNull$$$0(1);
            }
            super(tree, tag);
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBIterable jBIterable = super.iterateRawNodes().flatMap(ChangesBrowserNode::traverse).unique();
            if (jBIterable == null) {
                SelectedTagData.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$SelectedTagData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class AllExpandedByDefaultData
    extends VcsTreeModelData {
        @NotNull
        private final ChangesBrowserNode<?> myNode;

        AllExpandedByDefaultData(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                AllExpandedByDefaultData.$$$reportNull$$$0(0);
            }
            this.myNode = node;
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            JBTreeTraverser traverser = JBTreeTraverser.from(node -> {
                if (node.shouldExpandByDefault()) {
                    return node.iterateNodeChildren();
                }
                return JBIterable.empty();
            });
            JBIterable jBIterable = ((JBTreeTraverser)traverser.withRoot(this.myNode)).preOrderDfsTraversal();
            if (jBIterable == null) {
                AllExpandedByDefaultData.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllExpandedByDefaultData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$AllExpandedByDefaultData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ExactlySelectedTagData
    extends VcsTreeModelData {
        private final TreePath[] myPaths;
        private final ChangesBrowserNode<?> myTagNode;

        ExactlySelectedTagData(@NotNull JTree tree, @NotNull Object tag) {
            if (tree == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(1);
            }
            this.myPaths = tree.getSelectionPaths();
            this.myTagNode = ExactlySelectedTagData.findTagNode(tree, tag);
        }

        @Override
        @NotNull
        public JBIterable<ChangesBrowserNode<?>> iterateRawNodes() {
            ChangesBrowserNode<?> tagNode = this.myTagNode;
            if (tagNode == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(2);
                }
                return jBIterable;
            }
            Object[] paths = this.myPaths;
            if (paths == null) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    ExactlySelectedTagData.$$$reportNull$$$0(3);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.of((Object[])paths).filter(path -> path.getPathCount() <= 1 || path.getPathComponent(1) == tagNode).map(path -> (ChangesBrowserNode)path.getLastPathComponent());
            if (jBIterable == null) {
                ExactlySelectedTagData.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/VcsTreeModelData$ExactlySelectedTagData";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterateRawNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

