/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityConfHandlerLocal
extends SecurityConfHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Path securityJsonPath;

    public SecurityConfHandlerLocal(CoreContainer coreContainer) {
        super(coreContainer);
        this.securityJsonPath = Paths.get(coreContainer.getSolrHome(), new String[0]).resolve("security.json");
    }

    @Override
    public SecurityConfHandler.SecurityConfig getSecurityConfig(boolean getFresh) {
        if (Files.exists(this.securityJsonPath, new LinkOption[0])) {
            SecurityConfHandler.SecurityConfig securityConfig;
            block9: {
                InputStream securityJsonIs = Files.newInputStream(this.securityJsonPath, new OpenOption[0]);
                try {
                    securityConfig = new SecurityConfHandler.SecurityConfig().setData(securityJsonIs);
                    if (securityJsonIs == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (securityJsonIs != null) {
                            try {
                                securityJsonIs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed opening existing security.json file: " + String.valueOf(this.securityJsonPath), (Throwable)e);
                    }
                }
                securityJsonIs.close();
            }
            return securityConfig;
        }
        return new SecurityConfHandler.SecurityConfig();
    }

    @Override
    protected void getConf(SolrQueryResponse rsp, String key) {
        SecurityConfHandler.SecurityConfig props = this.getSecurityConfig(false);
        Object o = props.getData().get(key);
        if (o == null) {
            rsp.add("errorMessages", Collections.singletonList("No " + key + " configured"));
        } else {
            rsp.add(key + ".enabled", this.getPlugin(key) != null);
            rsp.add(key, o);
        }
    }

    @Override
    protected boolean persistConf(SecurityConfHandler.SecurityConfig securityConfig) throws IOException {
        boolean bl;
        block9: {
            if (securityConfig == null || securityConfig.getData().isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed persisting security.json to SOLR_HOME. Object was empty.");
            }
            OutputStream securityJsonOs = Files.newOutputStream(this.securityJsonPath, new OpenOption[0]);
            try {
                securityJsonOs.write(Utils.toJSON(securityConfig.getData()));
                log.debug("Persisted security.json to {}", (Object)this.securityJsonPath);
                bl = true;
                if (securityJsonOs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (securityJsonOs != null) {
                        try {
                            securityJsonOs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed persisting security.json to " + String.valueOf(this.securityJsonPath), (Throwable)e);
                }
            }
            securityJsonOs.close();
        }
        return bl;
    }

    @Override
    public String getDescription() {
        return "Edit or read security configuration locally in SOLR_HOME";
    }

    @Override
    protected void securityConfEdited() {
        this.cores.securityNodeChanged();
    }
}

