/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.Command;
import org.apache.solr.api.EndPoint;
import org.apache.solr.api.PayloadObj;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.MigrateDocsPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.security.PermissionNameProvider;

@EndPoint(path={"/c/{collection}", "/collections/{collection}"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
public class MigrateDocsAPI {
    private static final String V2_MIGRATE_DOCS_CMD = "migrate-docs";
    private final CollectionsHandler collectionsHandler;

    public MigrateDocsAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @Command(name="migrate-docs")
    public void migrateDocs(PayloadObj<MigrateDocsPayload> obj) throws Exception {
        MigrateDocsPayload v2Body = obj.get();
        Map v1Params = v2Body.toMap(new HashMap());
        v1Params.put("action", CollectionParams.CollectionAction.MIGRATE.toLower());
        v1Params.put("collection", obj.getRequest().getPathTemplateValues().get("collection"));
        if (v2Body.splitKey != null) {
            v1Params.remove("splitKey");
            v1Params.put("split.key", v2Body.splitKey);
        }
        if (v2Body.target != null) {
            v1Params.remove("target");
            v1Params.put("target.collection", v2Body.target);
        }
        if (v2Body.forwardTimeout != null) {
            v1Params.remove("forwardTimeout");
            v1Params.put("forward.timeout", v2Body.forwardTimeout);
        }
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(obj.getRequest(), v1Params), obj.getResponse());
    }
}

