/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Collection;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedDoubleFieldSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.schema.DoubleValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class DoublePointField
extends PointField
implements DoubleValueFieldType {
    public DoublePointField() {
        this.type = NumberType.DOUBLE;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof CharSequence) {
            return Double.parseDouble(val.toString());
        }
        return super.toNativeType(val);
    }

    @Override
    public Query getPointRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        double actualMax;
        double actualMin;
        if (min == null) {
            actualMin = Double.NEGATIVE_INFINITY;
        } else {
            actualMin = DoublePointField.parseDoubleFromUser(field.getName(), min);
            if (!minInclusive) {
                if (actualMin == Double.POSITIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                actualMin = DoublePoint.nextUp((double)actualMin);
            }
        }
        if (max == null) {
            actualMax = Double.POSITIVE_INFINITY;
        } else {
            actualMax = DoublePointField.parseDoubleFromUser(field.getName(), max);
            if (!maxInclusive) {
                if (actualMax == Double.NEGATIVE_INFINITY) {
                    return new MatchNoDocsQuery();
                }
                actualMax = DoublePoint.nextDown((double)actualMax);
            }
        }
        return DoublePoint.newRangeQuery((String)field.getName(), (double)actualMin, (double)actualMax);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return DoublePoint.decodeDimension((byte[])term.bytes, (int)term.offset);
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.NUMERIC) {
                return Double.longBitsToDouble(val.longValue());
            }
            if (!f.fieldType().stored() && f.fieldType().docValuesType() == DocValuesType.SORTED_NUMERIC) {
                return NumericUtils.sortableLongToDouble((long)val.longValue());
            }
            return val;
        }
        throw new AssertionError((Object)("Unexpected state. Field: '" + String.valueOf(f) + "'"));
    }

    @Override
    protected Query getExactQuery(SchemaField field, String externalVal) {
        return DoublePoint.newExactQuery((String)field.getName(), (double)DoublePointField.parseDoubleFromUser(field.getName(), externalVal));
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVal) {
        assert (externalVal.size() > 0);
        if (!field.indexed()) {
            return super.getSetQuery(parser, field, externalVal);
        }
        double[] values = new double[externalVal.size()];
        int i = 0;
        for (String val : externalVal) {
            values[i] = DoublePointField.parseDoubleFromUser(field.getName(), val);
            ++i;
        }
        if (field.hasDocValues()) {
            return DoubleField.newSetQuery((String)field.getName(), (double[])values);
        }
        return DoublePoint.newSetQuery((String)field.getName(), (double[])values);
    }

    @Override
    protected String indexedToReadable(BytesRef indexedForm) {
        return Double.toString(DoublePoint.decodeDimension((byte[])indexedForm.bytes, (int)indexedForm.offset));
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        result.grow(8);
        result.setLength(8);
        DoublePoint.encodeDimension((double)DoublePointField.parseDoubleFromUser(null, val.toString()), (byte[])result.bytes(), (int)0);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return null;
        }
        return UninvertingReader.Type.DOUBLE_POINT;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource();
        return new DoubleFieldSource(field.getName());
    }

    @Override
    protected ValueSource getSingleValueSource(SortedNumericSelector.Type choice, SchemaField f) {
        return new MultiValuedDoubleFieldSource(f.getName(), choice);
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
        return new DoublePoint(field.getName(), new double[]{doubleValue});
    }

    @Override
    protected StoredField getStoredField(SchemaField sf, Object value) {
        return new StoredField(sf.getName(), ((Double)this.toNativeType(value)).doubleValue());
    }
}

